/*
 * Decompiled with CFR 0.152.
 */
package bizcal.util;

import bizcal.util.CalendarFactory;
import bizcal.util.LocaleBroker;
import bizcal.util.TimeOfDay;
import bizcal.util.TimeZoneBroker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateUtil {
    public static final int MILLIS_SECOND = 1000;
    public static final int MILLIS_MINUTE = 60000;
    public static final int MILLIS_HOUR = 3600000;
    public static final int MILLIS_DAY = 86400000;
    public static final int MINUTES_HOUR = 60;
    public static final int MINUTES_DAY = 1440;
    public static final int MINUTES_WEEK = 10080;
    public static final int DAYS_WEEK = 7;
    private static CalendarFactory calFactory = new DefaultCalendarFactory();

    public static Date round2Day(Date date) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date round2Hour(Date date, int hour) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        if (hour > -1 && hour < 25) {
            cal.set(11, hour);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        }
        return cal.getTime();
    }

    public static Date round2Minute(Date date, int minute) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.set(13, 0);
        cal.set(14, 0);
        if (minute < 0) {
            minute *= -1;
        }
        int overlapping = minute / 60;
        int oldHour = cal.get(11);
        int addDays = (oldHour + overlapping) / 24;
        cal.set(11, (oldHour + overlapping) % 24);
        if (addDays > 0) {
            cal.set(5, cal.get(5) + addDays);
        }
        cal.set(12, minute % 60);
        return cal.getTime();
    }

    public static Date round2Minute(Date date) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date roundNice(Date date) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.set(13, 0);
        cal.set(14, 0);
        int minutes = cal.get(12);
        int multiplier = minutes / 15;
        minutes = multiplier * 15;
        cal.set(12, minutes);
        return cal.getTime();
    }

    public static int getDayOfWeek(Date date) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        return cal.get(7);
    }

    public static String getWeekday(Date date) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("EEEEE", Locale.getDefault());
        format.setTimeZone(TimeZone.getDefault());
        return format.format(date);
    }

    public static int getHourOfDay(Date date) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        return cal.get(11);
    }

    public static int getMinuteOfHour(Date date) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        return cal.get(12);
    }

    public static TimeOfDay getTimeOfDay(Date date) throws Exception {
        return new TimeOfDay(date.getTime() - DateUtil.round2Day(date).getTime());
    }

    public static Date getStartOfWeek(Date date) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.set(7, cal.getFirstDayOfWeek());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date setDayOfWeek(Date date, int weekday) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.set(7, weekday);
        return cal.getTime();
    }

    public static int getYear(Date date) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(Date date) throws Exception {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        return cal.get(2);
    }

    public static int getDayOfMonth(Date date) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getDayOfYear(Date date) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        return cal.get(6);
    }

    public static Date getDiffDay(Date date, int diff) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.add(7, diff);
        return cal.getTime();
    }

    public static Date move(Date date, int offset) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.add(5, offset);
        return cal.getTime();
    }

    public static Date moveByMinute(Date date, int offset) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.add(12, offset);
        return cal.getTime();
    }

    public static Date moveByYear(Date date, int offset) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.add(1, offset);
        return cal.getTime();
    }

    public static Date move2Midnight(Date date) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date move2Morning(Date date) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static long getDiffDay(Date oldDate, Date newDate) {
        long diff = 0L;
        diff = newDate.getTime() > oldDate.getTime() ? newDate.getTime() - oldDate.getTime() : -1L * (oldDate.getTime() - newDate.getTime());
        return diff;
    }

    public static List<Date> getDayRange(Date start, Date end) {
        ArrayList<Date> dates = new ArrayList<Date>(0);
        if (start == null || end == null) {
            return dates;
        }
        dates.add(start);
        Date normalizedEnd = DateUtil.round2Day(end);
        Date next = start;
        while (next.before(normalizedEnd)) {
            dates.add(DateUtil.getDiffDay(next, 1));
            next = DateUtil.round2Day(DateUtil.getDiffDay(next, 1));
        }
        dates.add(end);
        return dates;
    }

    public static int getDiffDay(int startDay, int endDay) {
        if (startDay > endDay) {
            endDay += 7;
        }
        return endDay - startDay + 1;
    }

    public static long getDiffMinutes(Date startDate, Date endDate) {
        return endDate.getTime() / 60000L - startDate.getTime() / 60000L;
    }

    public static int getMinutesOfRestDay(Date date) {
        if (date == null) {
            return 0;
        }
        int sum = 0;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int minute = cal.get(12);
        int hour = cal.get(11);
        sum = 60 - minute;
        int fac = 23 - hour;
        return sum += fac * 60;
    }

    public static int getMinutesOfDay(Date date) {
        if (date == null) {
            return 0;
        }
        long diffMinutes = DateUtil.getDiffMinutes(DateUtil.move2Morning(date), date);
        return (int)diffMinutes;
    }

    public static boolean isSameDayOfYear(Date d1, Date d2) {
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(d1);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(d2);
        return cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameDay(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(d1);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(d2);
        return cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1);
    }

    public static boolean isSameWeek(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(d1);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(d2);
        return cal1.get(3) == cal2.get(3) && cal1.get(1) == cal2.get(1);
    }

    public static boolean isSameMonth(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(d1);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(d2);
        return cal1.get(2) == cal2.get(2) && cal1.get(1) == cal2.get(1);
    }

    public static boolean isSameYear(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(d1);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(d2);
        return cal1.get(1) == cal2.get(1);
    }

    public static boolean isBeforeDay(Date d1, Date d2) {
        int y2;
        int dy1 = DateUtil.getDayOfYear(d1);
        int dy2 = DateUtil.getDayOfYear(d2);
        int y1 = DateUtil.getYear(d1);
        if (y1 < (y2 = DateUtil.getYear(d2))) {
            return true;
        }
        if (y1 > y2) {
            return false;
        }
        return dy1 < dy2;
    }

    public static int getDateDiff(Date date2, Date date1) {
        long dstOffset = Math.abs(DateUtil.getDaylightSavingOffset(date2)) - Math.abs(DateUtil.getDaylightSavingOffset(date1));
        return (int)((date2.getTime() - date1.getTime() + dstOffset) / 24L / 3600L / 1000L);
    }

    public static Date setTimeOfDate(Date date, TimeOfDay time) throws Exception {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.set(11, time.getHour());
        cal.set(12, time.getMinute());
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date round2Week(Date date) throws Exception {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.set(7, cal.getFirstDayOfWeek());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date round2Month(Date date) throws Exception {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date[] createDateList(int minOffset) {
        if (minOffset < 0) {
            minOffset = 0;
        }
        if (minOffset > 60) {
            minOffset = 60;
        }
        try {
            Calendar cal = DateUtil.newCalendar();
            cal.set(5, 0);
            cal.set(2, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            int capacity = 1440 / minOffset;
            Date[] dates = new Date[capacity];
            int limit = 60 / minOffset;
            int count = 1;
            int i = 0;
            while (i < capacity) {
                dates[i] = cal.getTime();
                cal.roll(12, minOffset);
                if (count == limit) {
                    cal.roll(11, 1);
                    count = 0;
                }
                ++count;
                ++i;
            }
            return dates;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date createDate(int type, int value) {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 0);
        cal.set(2, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(type, value);
        return cal.getTime();
    }

    public static int extractAge(Date dayOfBirth) {
        GregorianCalendar c1 = new GregorianCalendar();
        GregorianCalendar c2 = new GregorianCalendar();
        c2.setTime(dayOfBirth);
        int year = c1.get(1) - c2.get(1);
        if (DateUtil.getDayOfYear(c1.getTime()) < DateUtil.getDayOfYear(dayOfBirth)) {
            --year;
        }
        return year;
    }

    public static boolean isDaylightSavingDay(Date date) {
        Date start = DateUtil.move2Morning(date);
        Date end = DateUtil.move2Midnight(date);
        return DateUtil.getDaylightSavingOffset(start) != DateUtil.getDaylightSavingOffset(end);
    }

    public static boolean isAfterDSTChange(Date date) {
        if (!DateUtil.isDaylightSavingDay(date)) {
            return false;
        }
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        int hour = cal.get(11);
        return hour >= 3;
    }

    public static boolean isBeforeDSTChange(Date date) {
        if (!DateUtil.isDaylightSavingDay(date)) {
            return false;
        }
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        int hour = cal.get(11);
        return hour <= 2;
    }

    public static long getDaylightSavingOffset(Date date) {
        Calendar cal = DateUtil.newCalendar();
        cal.setTime(date);
        return cal.get(16);
    }

    public static long getDSTShiftHourOffset(Date date) {
        Date earlier = DateUtil.moveByMinute(date, -60);
        long dstOffsetEarlier = Math.abs(DateUtil.getDaylightSavingOffset(date)) - Math.abs(DateUtil.getDaylightSavingOffset(earlier));
        if (dstOffsetEarlier != 0L) {
            return dstOffsetEarlier;
        }
        Date later = DateUtil.moveByMinute(date, 60);
        long dstOffsetLater = Math.abs(DateUtil.getDaylightSavingOffset(later)) - Math.abs(DateUtil.getDaylightSavingOffset(date));
        return dstOffsetLater;
    }

    public static Calendar newCalendar() {
        return calFactory.newCalendar();
    }

    public static void setCalendarFactory(CalendarFactory factory) {
        calFactory = factory;
    }

    private static class DefaultCalendarFactory
    implements CalendarFactory {
        private DefaultCalendarFactory() {
        }

        public Calendar newCalendar() {
            Calendar cal = Calendar.getInstance(LocaleBroker.getLocale());
            cal.setTimeZone(TimeZoneBroker.getTimeZone());
            return cal;
        }
    }
}

