/*
 * Decompiled with CFR 0.152.
 */
package bizcal.util;

import bizcal.util.BizcalException;
import bizcal.util.NullSafe;
import java.io.Serializable;

public class Interval
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Comparable start;
    private Comparable end;
    private boolean includeStart = true;
    private boolean includeEnd = false;

    public Interval(Comparable start, Comparable end) {
        this.start = start;
        this.end = end;
    }

    protected Interval() {
    }

    public Comparable getStart() {
        return this.start;
    }

    public void setStart(Comparable start) {
        this.start = start;
    }

    public Comparable getEnd() {
        return this.end;
    }

    public void setEnd(Comparable end) {
        this.end = end;
    }

    public boolean isIncludeEnd() {
        return this.includeEnd;
    }

    public void setIncludeEnd(boolean includeEnd) {
        this.includeEnd = includeEnd;
    }

    public boolean isIncludeStart() {
        return this.includeStart;
    }

    public void setIncludeStart(boolean includeStart) {
        this.includeStart = includeStart;
    }

    public boolean contains(Comparable obj) {
        if (this.start != null) {
            if (obj.compareTo(this.getStart()) < 0) {
                return false;
            }
            if (!this.includeStart && obj.compareTo(this.getStart()) == 0) {
                return false;
            }
        }
        if (this.end != null) {
            if (obj.compareTo(this.getEnd()) > 0) {
                return false;
            }
            if (!this.includeEnd && obj.compareTo(this.getEnd()) == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean contains(Interval interval) {
        int cmp;
        if (this.start != null) {
            cmp = interval.getStart().compareTo(this.start);
            if (cmp < 0) {
                return false;
            }
            if (cmp == 0 && !this.includeStart && interval.isIncludeStart()) {
                return false;
            }
        }
        if (this.end != null) {
            if (interval.getEnd() == null) {
                return false;
            }
            cmp = interval.getEnd().compareTo(this.end);
            if (cmp > 0) {
                return false;
            }
            if (cmp == 0 && !this.includeEnd && interval.isIncludeEnd()) {
                return false;
            }
        }
        return true;
    }

    public boolean overlap(Interval interval) {
        Interval tmpInterv = new Interval(this.getStart(), this.getEnd());
        tmpInterv.setIncludeStart(false);
        tmpInterv.setIncludeEnd(false);
        if (tmpInterv.contains(interval.getStart())) {
            return true;
        }
        if (tmpInterv.contains(interval.getEnd())) {
            return true;
        }
        if (interval.contains(this.getStart()) && interval.contains(this.getEnd())) {
            return true;
        }
        return NullSafe.equals(interval.getStart(), this.getStart()) && NullSafe.equals(interval.getEnd(), this.getEnd());
    }

    public Interval intersection(Interval interval) throws Exception {
        Comparable start = this.getStart();
        Comparable end = this.getEnd();
        if (interval.getStart().compareTo(start) > 0) {
            start = interval.getStart();
        }
        if (interval.getEnd().compareTo(end) < 0) {
            end = interval.getEnd();
        }
        if (start.compareTo(end) > 0) {
            return null;
        }
        return new Interval(start, end);
    }

    public Interval union(Interval interval) throws Exception {
        Comparable start = this.getStart();
        Comparable end = this.getEnd();
        if (interval.getStart().compareTo(start) < 0) {
            start = interval.getStart();
        }
        if (interval.getEnd().compareTo(end) > 0) {
            end = interval.getEnd();
        }
        return new Interval(start, end);
    }

    public boolean equals(Object other) {
        try {
            if (other instanceof Interval) {
                Interval interval = (Interval)other;
                return NullSafe.equals(this.getStart(), interval.getStart()) && NullSafe.equals(this.getEnd(), interval.getEnd());
            }
            return false;
        }
        catch (Exception e) {
            throw BizcalException.create(e);
        }
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public String toString() {
        try {
            StringBuffer str = new StringBuffer();
            if (this.getStart() != null) {
                str.append(this.getStart().toString());
            }
            str.append(" - ");
            if (this.getEnd() != null) {
                str.append(this.getEnd().toString());
            }
            return str.toString();
        }
        catch (Exception e) {
            throw BizcalException.create(e);
        }
    }
}

