/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.views;

import bizcal.common.CalendarViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.CalendarView;
import bizcal.swing.MonthView;
import bizcal.util.DateInterval;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JToggleButton;
import lu.tudor.santec.bizcal.AbstractCalendarView;
import lu.tudor.santec.bizcal.CalendarIcons;
import lu.tudor.santec.bizcal.EventModel;
import lu.tudor.santec.bizcal.NamedCalendar;
import lu.tudor.santec.bizcal.print.PrintUtilities;
import lu.tudor.santec.i18n.Translatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonthViewPanel
extends AbstractCalendarView {
    private static final long serialVersionUID = 1L;
    private JToggleButton button = new JToggleButton(CalendarIcons.getMediumIcon("cal_month.png"));
    private MonthView monthView;
    private EventModel monthModel;
    public static final String VIEW_NAME = "MONTH_VIEW";

    public MonthViewPanel(EventModel model) {
        this.button.setToolTipText(Translatrix.getTranslationString((String)"bizcal.MONTH_VIEW"));
        this.setLayout(new BorderLayout());
        this.monthModel = model;
        try {
            this.monthView = new MonthView(new CalendarViewConfig());
            this.monthView.setModel(this.monthModel);
            this.monthModel.addCalendarView(this.monthView);
            this.add((Component)this.monthView.getComponent(), "Center");
            this.monthView.refresh0();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addCalendarListener(CalendarListener listener) {
        this.monthView.addListener(listener);
    }

    @Override
    public JToggleButton getButton() {
        return this.button;
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    @Override
    public void dateChanged(Date date) {
        this.monthModel.setDate(date);
        try {
            this.monthView.refresh0();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void activeCalendarsChanged(Collection<NamedCalendar> calendars) {
    }

    @Override
    public void selectedCalendarChanged(NamedCalendar selectedCalendar) {
    }

    @Override
    public List<Event> getEvents() {
        try {
            DateInterval interval = this.monthModel.getInterval();
            Date start = (Date)interval.getStart();
            Date end = (Date)interval.getEnd();
            List<Event> evs = this.monthModel.getEvents(null);
            ArrayList<Event> shownEvents = new ArrayList<Event>();
            if (evs != null) {
                for (Event e : evs) {
                    if (!e.getStart().after(start) || !e.getStart().before(end)) continue;
                    shownEvents.add(e);
                }
            }
            return shownEvents;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void print(boolean showPrinterDialog) {
        PrintUtilities.printComponent(this, showPrinterDialog, true);
    }

    @Override
    public CalendarView getView() {
        return this.monthView;
    }
}

