/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.plaf.UIResource;

public class CheckBoxPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JCheckBox checkBox;
    private JToggleButton button;
    private Color bgColor;
    private ColorBoxIcon icon;
    private Vector<ActionListener> listeners = new Vector();

    public CheckBoxPanel(String text, Color c, ButtonGroup group) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.checkBox = new JCheckBox();
        this.checkBox.setOpaque(false);
        this.checkBox.requestFocus(false);
        this.add((Component)this.checkBox, "East");
        this.button = new JToggleButton(text);
        group.add(this.button);
        this.button.addActionListener(this);
        this.icon = new ColorBoxIcon(c);
        this.button.setIcon(this.icon);
        this.button.setHorizontalAlignment(2);
        this.add((Component)this.button, "Center");
    }

    public void setActiv(boolean b) {
        this.checkBox.setSelected(b);
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.checkBox.addActionListener(listener);
        this.listeners.add(listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.checkBox.removeActionListener(listener);
        this.listeners.remove(listener);
    }

    public boolean isActiv() {
        return this.checkBox.isSelected();
    }

    public boolean isSelected() {
        return this.button.isSelected();
    }

    public void setSelected(boolean isSelected) {
        this.button.setSelected(isSelected);
        this.asynchInformActionListeners();
    }

    public void setColor(Color c) {
        this.bgColor = c;
        this.icon.setColor(this.bgColor);
        this.button.updateUI();
    }

    public void setText(String text) {
        this.button.setText(text);
    }

    private synchronized void asynchInformActionListeners() {
        for (ActionListener element : this.listeners) {
            element.actionPerformed(new ActionEvent(this, 1001, "selection changed"));
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.button.equals(e.getSource())) {
            this.asynchInformActionListeners();
        }
    }

    public synchronized void addMouseListener(MouseListener l) {
        this.button.addMouseListener(l);
    }

    public class ColorBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private Color color;
        private static final double FAQ = 1.5;
        private static final long serialVersionUID = 1L;

        public ColorBoxIcon(Color color) {
            this.color = color;
        }

        protected int getControlSize() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int controlSize = this.getControlSize();
            g.setColor(this.color);
            g.fillRect(x, y + 1, (int)((double)(controlSize - 1) * 1.5), controlSize - 1);
            g.setColor(Color.BLACK);
            g.drawRect(x, y + 1, (int)((double)(controlSize - 1) * 1.5), controlSize - 1);
        }

        public int getIconWidth() {
            return (int)((double)this.getControlSize() * 1.5);
        }

        public int getIconHeight() {
            return this.getControlSize();
        }

        public void setColor(Color c) {
            this.color = c;
        }
    }
}

