/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.CompileException;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;

public class ImportNode
extends ASTNode {
    private Class importClass;
    private boolean packageImport;
    private short offset;

    public ImportNode(char[] expr) {
        this.name = expr;
        String name = new String(expr);
        if (name.endsWith(".*")) {
            this.packageImport = true;
            this.offset = (short)name.lastIndexOf(46);
        } else {
            try {
                this.importClass = Thread.currentThread().getContextClassLoader().loadClass(new String(expr));
            }
            catch (ClassNotFoundException e) {
                throw new CompileException("class not found: " + new String(expr));
            }
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (!this.packageImport) {
            return ParseTools.findClassImportResolverFactory(factory).addClass(this.importClass);
        }
        ParseTools.findClassImportResolverFactory(factory).addPackageImport(new String(this.name, 0, (int)this.offset));
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    public Class getImportClass() {
        return this.importClass;
    }

    public boolean isPackageImport() {
        return this.packageImport;
    }

    public void setPackageImport(boolean packageImport) {
        this.packageImport = packageImport;
    }

    public String getPackageImport() {
        return new String(this.name, 0, (int)this.offset);
    }
}

