/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.demoapps;

import ij.ImagePlus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import lu.tudor.santec.dicom.DicomOpener;
import lu.tudor.santec.dicom.demoapps.Dicom2dbImporter;
import lu.tudor.santec.dicom.exporter.DicomExporter;
import lu.tudor.santec.dicom.receiver.DICOMListener;
import lu.tudor.santec.dicom.receiver.DicomEvent;
import lu.tudor.santec.dicom.receiver.DicomStorageServer;
import lu.tudor.santec.dicom.sender.DicomSender;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.TTCCLayout;
import org.dcm4che.util.DcmURL;
import org.dcm4che2.data.DicomObject;

public class TranscodeNode
implements DICOMListener {
    private DicomSender dicomSender;
    private DicomExporter dicomExporter;
    private DicomStorageServer dss;
    private File propertyFile;
    private File LOGFILE = new File("TranscodeNode.log");
    private String DICOM_REC_AET_NAME;
    private Integer DICOM_REC_PORT;
    private String DICOM_SND_AET_NAME;
    private String DICOM_SND_ADDRESS;
    private Integer DICOM_SND_PORT;
    private String DICOM_STORE_DIR;
    private Boolean KEEP_FILES;
    private static Logger logger = Logger.getLogger((String)TranscodeNode.class.getName());

    public TranscodeNode(File propertyFile) {
        this.propertyFile = propertyFile;
        try {
            TTCCLayout layout = new TTCCLayout("ISO8601");
            DailyRollingFileAppender fileAppender = new DailyRollingFileAppender((Layout)layout, this.LOGFILE.getAbsolutePath(), "'.'yyyy-MM-dd");
            BasicConfigurator.configure((Appender)fileAppender);
            Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)layout));
            logger.info((Object)("Added logging to file: " + this.LOGFILE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.readConfig();
    }

    private void readConfig() {
        InputStream in;
        Properties properties = new Properties();
        if (this.propertyFile != null && this.propertyFile.canRead()) {
            try {
                in = new FileInputStream(this.propertyFile);
            }
            catch (FileNotFoundException e) {
                in = Dicom2dbImporter.class.getResourceAsStream("TranscodeNode.properties");
            }
        } else {
            in = Dicom2dbImporter.class.getResourceAsStream("TranscodeNode.properties");
        }
        try {
            properties.load(in);
        }
        catch (Exception e) {
            System.err.println("no usable Settings found");
            logger.warn((Object)"no usable Settings found");
            e.printStackTrace();
            System.exit(-1);
        }
        this.DICOM_REC_AET_NAME = properties.getProperty("DICOM_REC_AET_NAME");
        this.DICOM_REC_PORT = new Integer(properties.getProperty("DICOM_REC_PORT"));
        this.DICOM_SND_AET_NAME = properties.getProperty("DICOM_SND_AET_NAME");
        this.DICOM_SND_ADDRESS = properties.getProperty("DICOM_SND_ADDRESS");
        this.DICOM_SND_PORT = new Integer(properties.getProperty("DICOM_SND_PORT"));
        this.DICOM_STORE_DIR = properties.getProperty("DICOM_STORE_DIR");
        this.KEEP_FILES = new Boolean(properties.getProperty("KEEP_FILES"));
    }

    public void start() {
        try {
            this.dss = new DicomStorageServer(this.DICOM_REC_AET_NAME, this.DICOM_REC_PORT, this.DICOM_STORE_DIR, true, "password", false);
            this.dss.addDICOMListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DcmURL url = new DcmURL("dicom", this.DICOM_SND_AET_NAME, this.DICOM_REC_AET_NAME, this.DICOM_SND_ADDRESS, this.DICOM_SND_PORT);
        this.dicomSender = new DicomSender(url);
        this.dicomExporter = new DicomExporter();
    }

    @Override
    public void fireDicomEvent(DicomEvent event) {
        logger.info((Object)("event: " + event));
        File inFile = event.getFile();
        File outFile = new File(String.valueOf(inFile.getAbsolutePath()) + ".converted.dcm");
        try {
            try {
                ImagePlus ip = DicomOpener.loadImage(inFile, null, null);
                DicomObject header = this.dicomExporter.createHeader(ip, true, true, true);
                this.dicomExporter.write(header, ip, outFile, true);
                this.dicomSender.send(outFile);
            }
            catch (Exception e) {
                logger.log((Priority)Level.WARN, (Object)"Converting/Sending failed:", (Throwable)e);
                e.printStackTrace();
                if (!this.KEEP_FILES.booleanValue()) {
                    if (inFile != null && inFile.exists()) {
                        inFile.delete();
                    }
                    if (outFile != null && outFile.exists()) {
                        outFile.delete();
                    }
                }
            }
        }
        finally {
            if (!this.KEEP_FILES.booleanValue()) {
                if (inFile != null && inFile.exists()) {
                    inFile.delete();
                }
                if (outFile != null && outFile.exists()) {
                    outFile.delete();
                }
            }
        }
    }

    public static void main(String[] args) {
        File f = null;
        try {
            f = new File(args[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TranscodeNode tn = new TranscodeNode(f);
        tn.start();
    }
}

