/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.dicomdb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.receiver.DICOMListener;
import lu.tudor.santec.dicom.receiver.DicomEvent;
import lu.tudor.santec.dicom.receiver.DicomStorageServer;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.TTCCLayout;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomInputStream;

public class DicomHeaderDBImporter
implements DICOMListener {
    public static final String SOFTWARE_VERSION = "0.1";
    private File propertyFile;
    private File filtertagFile;
    private String DB_URL;
    private String DB_USER;
    private String DB_PASSWORD;
    private String DB_DRIVER_CLASS;
    private String DICOM_AET_NAME;
    private Integer DICOM_PORT;
    private String DICOM_STORE_DIR;
    private String ROOT_DIR;
    private String ERROR_DIR;
    private String OK_DIR;
    private boolean DELETE_FILES_AFTER_IMPORT;
    private boolean CHECKSUM;
    private boolean CHECK_RECONSTRUCTION;
    private long used_files;
    private long imported_files;
    private LinkedHashMap<String, String> dicomTags = new LinkedHashMap();
    private LinkedHashMap<String, String> filterTags = new LinkedHashMap();
    private Queue<File> images2import = new ConcurrentLinkedQueue<File>();
    private File LOGFILE = new File("DicomHeaderDBImporter.log");
    int itemOrder = 1;
    private static Logger logger = Logger.getLogger((String)DicomHeaderDBImporter.class.getName());

    public DicomHeaderDBImporter(File propertyFile, File filtertagFile) {
        this.propertyFile = propertyFile;
        this.filtertagFile = filtertagFile;
        try {
            TTCCLayout layout = new TTCCLayout("ISO8601");
            DailyRollingFileAppender fileAppender = new DailyRollingFileAppender((Layout)layout, this.LOGFILE.getAbsolutePath(), "'.'yyyy-MM-dd");
            BasicConfigurator.configure((Appender)fileAppender);
            Logger.getLogger((String)"org.dcm4che2").setLevel(Level.WARN);
            logger.setLevel(Level.INFO);
            logger.info((Object)("Added logging to file: " + this.LOGFILE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.readConfig();
        this.readFilterTags();
        try {
            DicomStorageServer storageServer = new DicomStorageServer(this.DICOM_AET_NAME, this.DICOM_PORT, this.DICOM_STORE_DIR, false, "xxxxx", false);
            storageServer.addDICOMListener(this);
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage());
        }
        int i = 0;
        while (i < 5) {
            this.createDBImporterThread();
            ++i;
        }
    }

    private void createDBImporterThread() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Connection dbCon = DicomHeaderDBImporter.this.getNewDatabaseConnection();
                    PreparedStatement insertDCMSeriesStmt = DicomHeaderDBImporter.this.prepareStatement(DICOM.SERIES, dbCon);
                    PreparedStatement insertDCMObjectStmt = DicomHeaderDBImporter.this.prepareStatement(DICOM.OBJECT, dbCon);
                    PreparedStatement insertDCMTagsStmt = DicomHeaderDBImporter.this.prepareStatement(DICOM.TAGS, dbCon);
                    while (true) {
                        try {
                            while (true) {
                                File f;
                                if ((f = (File)DicomHeaderDBImporter.this.images2import.poll()) != null) {
                                    DicomHeaderDBImporter.this.insertFile2DB(f, insertDCMSeriesStmt, insertDCMObjectStmt, insertDCMTagsStmt, dbCon);
                                    continue;
                                }
                                Thread.sleep(500L);
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)"error importing images...", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
                catch (SQLException ex) {
                    logger.log((Priority)Level.FATAL, null, (Throwable)ex);
                    return;
                }
            }
        }.start();
    }

    private Connection getNewDatabaseConnection() throws SQLException {
        try {
            Class.forName(this.DB_DRIVER_CLASS);
            Connection dbConnection = DriverManager.getConnection(this.DB_URL, this.DB_USER, this.DB_PASSWORD);
            dbConnection.setAutoCommit(false);
            return dbConnection;
        }
        catch (ClassNotFoundException io) {
            System.err.println("unable to connecto to DB: " + this.DB_URL);
            logger.warn((Object)("unable to connecto to DB: " + this.DB_URL));
            io.printStackTrace();
            return null;
        }
    }

    private void readConfig() {
        InputStream in;
        Properties properties = new Properties();
        if (this.propertyFile != null && this.propertyFile.canRead()) {
            try {
                in = new FileInputStream(this.propertyFile);
            }
            catch (FileNotFoundException e) {
                in = DicomHeaderDBImporter.class.getResourceAsStream("DicomHeaderDBImporter.properties");
            }
        } else {
            in = DicomHeaderDBImporter.class.getResourceAsStream("DicomHeaderDBImporter.properties");
        }
        try {
            properties.load(in);
        }
        catch (Exception e) {
            System.err.println("no usable Settings found");
            logger.warn((Object)"no usable Settings found");
            e.printStackTrace();
            System.exit(-1);
        }
        this.ROOT_DIR = properties.getProperty("ROOT_DIR");
        this.ERROR_DIR = String.valueOf(this.ROOT_DIR) + File.separator + properties.getProperty("ERROR_DIR");
        new File(this.ERROR_DIR).mkdirs();
        this.OK_DIR = String.valueOf(this.ROOT_DIR) + File.separator + properties.getProperty("OK_DIR");
        new File(this.OK_DIR).mkdirs();
        String str = properties.getProperty("DELETE_FILES_AFTER_IMPORT");
        this.DELETE_FILES_AFTER_IMPORT = str.toUpperCase().equals("TRUE") || str.toUpperCase().equals("YES");
        this.DICOM_AET_NAME = properties.getProperty("DICOM_AET_NAME");
        this.DICOM_PORT = new Integer(properties.getProperty("DICOM_PORT"));
        this.DICOM_STORE_DIR = String.valueOf(this.ROOT_DIR) + File.separator + properties.getProperty("DICOM_STORE_DIR");
        this.DB_DRIVER_CLASS = properties.getProperty("DB_DRIVER_CLASS");
        this.DB_URL = properties.getProperty("DB_URL");
        this.DB_USER = properties.getProperty("DB_USER");
        this.DB_PASSWORD = properties.getProperty("DB_PASSWORD");
        String strChecksum = properties.getProperty("CHECKSUM");
        this.CHECKSUM = strChecksum.toUpperCase().equals("TRUE") || strChecksum.toUpperCase().equals("YES");
        String strCheckRecon = properties.getProperty("CHECK_RECONSTRUCTION");
        this.CHECK_RECONSTRUCTION = strCheckRecon.toUpperCase().equals("TRUE") || strCheckRecon.toUpperCase().equals("YES");
        for (String string : properties.keySet()) {
            if (!string.startsWith("00")) continue;
            this.dicomTags.put(string, properties.getProperty(string));
        }
    }

    private void readFilterTags() {
        InputStream in;
        Properties properties = new Properties();
        if (this.filtertagFile != null && this.filtertagFile.canRead()) {
            try {
                in = new FileInputStream(this.filtertagFile);
            }
            catch (FileNotFoundException e) {
                in = DicomHeaderDBImporter.class.getResourceAsStream("filtertags.properties");
            }
        } else {
            in = DicomHeaderDBImporter.class.getResourceAsStream("filtertags.properties");
        }
        try {
            properties.load(in);
        }
        catch (Exception e) {
            System.err.println("no filtertags found");
            logger.warn((Object)"no filtertags found");
            e.printStackTrace();
            System.exit(-1);
        }
        for (String string : properties.keySet()) {
            this.filterTags.put(string, properties.getProperty(string));
        }
    }

    private PreparedStatement prepareStatement(DICOM dicom, Connection con) {
        PreparedStatement stmt = null;
        try {
            switch (dicom) {
                case SERIES: {
                    StringBuffer statement = new StringBuffer();
                    statement.append("INSERT INTO dcmseries (");
                    for (String column : this.dicomTags.values()) {
                        statement.append(String.valueOf(column) + ",");
                    }
                    statement.deleteCharAt(statement.length() - 1);
                    statement.append(") VALUES (");
                    int i = 0;
                    while (i < this.dicomTags.size() - 1) {
                        statement.append("?,");
                        ++i;
                    }
                    statement.append("?);");
                    return con.prepareStatement(statement.toString());
                }
                case OBJECT: {
                    return con.prepareStatement("INSERT INTO dcmobject (seriesuid, sopinstanceuid, entrydate, checksumimage, dbimporterversion)VALUES (?,?,?,?,?);");
                }
                case TAGS: {
                    return con.prepareStatement("INSERT INTO dcmtag (dcmobject_id,tag,vr,value,itemorder,parentid) VALUES (?,?,?,?,?,?);");
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return stmt;
    }

    private void insertFile2DB(File f, PreparedStatement insertDCMSeriesStmt, PreparedStatement insertDCMObjectStmt, PreparedStatement insertDCMTagsStmt, Connection currentDbConnection) {
        logger.info((Object)(" \r\n\r\n#######################################################\r\n#\r\n#  STARTING IMPORT FOR " + f.getName() + "\r\n" + "#\r\n" + "#######################################################"));
        ++this.used_files;
        long start = System.currentTimeMillis();
        boolean importFile = true;
        try {
            DicomHeader dh = new DicomHeader(f);
            DicomObject dcmObjectHeader = dh.getDicomObject();
            if (!this.filterTags.isEmpty()) {
                block12: for (String tag : this.filterTags.keySet()) {
                    if (this.filterTags.get(tag).contains(",")) {
                        String[] splittedValue = this.filterTags.get(tag).split(", ");
                        int i = 0;
                        while (i < splittedValue.length) {
                            if (splittedValue[i].equals(dh.getHeaderStringValue(tag))) {
                                importFile = false;
                                logger.info((Object)("NOT importing File, matches Filtertags: " + this.filterTags.get(tag)));
                                continue block12;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (!dh.getHeaderStringValue(tag).equals(this.filterTags.get(tag))) continue;
                    importFile = false;
                    logger.info((Object)("NOT importing File, matches Filtertags: " + this.filterTags.get(tag)));
                    break;
                }
            }
            if (importFile && this.CHECK_RECONSTRUCTION) {
                importFile = this.checkRecontruction(currentDbConnection, dh);
            }
            if (importFile) {
                if (!this.seriesExists(currentDbConnection, dh)) {
                    try {
                        int i = 1;
                        for (String tag : this.dicomTags.keySet()) {
                            java.util.Date d;
                            String VR2 = DicomHeader.getHeaderFieldType(tag);
                            if ("DA".equals(VR2)) {
                                try {
                                    d = dh.getHeaderDateValue(tag);
                                    insertDCMSeriesStmt.setDate(i, new Date(d.getTime()));
                                }
                                catch (Exception e) {
                                    insertDCMSeriesStmt.setDate(i, null);
                                }
                            } else if ("TM".equals(VR2)) {
                                try {
                                    d = dh.getHeaderDateValue(tag);
                                    insertDCMSeriesStmt.setTime(i, new Time(d.getTime()));
                                }
                                catch (Exception e) {
                                    insertDCMSeriesStmt.setTime(i, null);
                                }
                            } else {
                                String s = dh.getHeaderStringValue(tag);
                                s = s.replaceAll("\u0000", "");
                                insertDCMSeriesStmt.setString(i, s);
                            }
                            ++i;
                        }
                        insertDCMSeriesStmt.execute();
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("duplicate key") < 0) {
                            logger.error((Object)"Error adding series: ", (Throwable)sqle);
                        } else {
                            logger.warn((Object)"Series allready in DB");
                        }
                        currentDbConnection.rollback();
                    }
                }
                try {
                    int j = 1;
                    insertDCMObjectStmt.setString(j++, dh.getDicomObject().getString(0x20000E));
                    insertDCMObjectStmt.setString(j++, dh.getDicomObject().getString(524312));
                    insertDCMObjectStmt.setTimestamp(j++, new Timestamp(System.currentTimeMillis()));
                    if (this.CHECKSUM) {
                        DicomInputStream dis = new DicomInputStream(f);
                        BasicDicomObject dcmObj = new BasicDicomObject();
                        dis.readDicomObject((DicomObject)dcmObj, -1);
                        DicomElement de = dcmObj.get(2145386512);
                        byte[] bytes = de.getBytes();
                        MessageDigest md = MessageDigest.getInstance("MD5");
                        md.update(bytes);
                        byte[] md5 = md.digest();
                        BigInteger bi = new BigInteger(1, md5);
                        insertDCMObjectStmt.setString(j++, bi.toString(16));
                    } else {
                        insertDCMObjectStmt.setString(j++, null);
                    }
                    insertDCMObjectStmt.setString(j++, SOFTWARE_VERSION);
                    insertDCMObjectStmt.execute();
                    int parentID = this.getDCMObjectID(currentDbConnection, dh.getDicomObject().getString(524312));
                    this.itemOrder = 1;
                    insertDCMTagsStmt.clearBatch();
                    this.insertDicomTags(parentID, dcmObjectHeader, null, insertDCMTagsStmt);
                    insertDCMTagsStmt.executeBatch();
                    currentDbConnection.commit();
                    logger.info((Object)"File inserted");
                    ++this.imported_files;
                }
                catch (SQLException sqle) {
                    currentDbConnection.rollback();
                    if (sqle.getMessage().indexOf("duplicate key") < 0) {
                        logger.error((Object)"Error importing image: ", (Throwable)sqle);
                    }
                    logger.warn((Object)("File with UID=" + dh.getDicomObject().getString(524312) + " allready in db"));
                }
            }
            if (this.DELETE_FILES_AFTER_IMPORT) {
                f.delete();
            } else {
                boolean success = f.renameTo(new File(this.OK_DIR, f.getName()));
                if (success) {
                    logger.info((Object)("moved file to: " + this.OK_DIR + File.separator + f.getName()));
                } else {
                    logger.warn((Object)("unable to move file to: " + this.OK_DIR + File.separator + f.getName()));
                }
            }
        }
        catch (Exception e) {
            boolean success = f.renameTo(new File(this.ERROR_DIR, f.getName()));
            logger.log((Priority)Level.WARN, (Object)("Failed to insert file: " + f.getAbsolutePath() + " " + e.getMessage()), (Throwable)e);
            if (success) {
                logger.info((Object)("moved file to: " + this.ERROR_DIR + File.separator + f.getName()));
            } else {
                logger.warn((Object)("unable to move file to: " + this.ERROR_DIR + File.separator + f.getName()));
            }
            try {
                currentDbConnection.rollback();
            }
            catch (SQLException e1) {
                logger.log((Priority)Level.ERROR, (Object)e1.getMessage(), (Throwable)e1);
            }
        }
        logger.info((Object)("END OF IMPORT FOR " + f.getName() + " took " + (System.currentTimeMillis() - start) + "\u00b5sec. \r\n" + "Files used: " + this.used_files + "  Files imported: " + this.imported_files + " \r\n" + "#######################################################"));
    }

    private void insertDicomTags(int dcmobject_id, DicomObject obj, Integer parentId, PreparedStatement stmt) throws Exception {
        for (DicomElement e : obj) {
            StringBuffer sb = new StringBuffer();
            try {
                String[] values = e.getStrings(obj.getSpecificCharacterSet(), false);
                sb.append(values[0].replaceAll("\u0000", ""));
                int i = 1;
                while (i < values.length) {
                    sb.append("/").append(values[i].replaceAll("\u0000", ""));
                    ++i;
                }
            }
            catch (Exception ee) {
                try {
                    sb.append(e.getString(obj.getSpecificCharacterSet(), false));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stmt.setInt(1, dcmobject_id);
            stmt.setString(2, DicomHeader.toTagString(e.tag()));
            stmt.setString(3, e.vr().toString());
            if (sb.length() > 150) {
                stmt.setString(4, sb.toString().substring(0, 150).concat("*** end of tag-value not applicable ***"));
            } else {
                stmt.setString(4, sb.toString());
            }
            stmt.setInt(5, this.itemOrder);
            if (parentId == null) {
                stmt.setNull(6, 4);
            } else {
                stmt.setInt(6, parentId);
            }
            stmt.addBatch();
            ++this.itemOrder;
            if (e.countItems() <= 0 || !e.hasDicomObjects()) continue;
            int i = 0;
            while (i < e.countItems()) {
                this.insertDicomTags(dcmobject_id, e.getDicomObject(i), this.itemOrder - 1, stmt);
                ++i;
            }
        }
    }

    boolean checkRecontruction(Connection dbConnection, DicomHeader dh) throws Exception {
        String sqlQueryFilterReconstructions = new String("SELECT seriesinstanceuid FROM dcmseries WHERE '" + dh.getHeaderStringValue(0x20000D) + "' = studyinstanceuid " + "AND '" + dh.getHeaderStringValue(0x20000E) + "' <> seriesinstanceuid " + "AND '" + dh.getHeaderStringValue(0x200012) + "' = seriesnumber " + "OR '" + dh.getHeaderStringValue(0x20000D) + "' = studyinstanceuid " + "AND '" + dh.getHeaderStringValue(0x20000E) + "' <> seriesinstanceuid " + "AND '" + dh.getHeaderStringValue(0x200012) + "' = acquisitionnumber; ");
        ResultSet rs = dbConnection.createStatement().executeQuery(sqlQueryFilterReconstructions);
        if (rs.next()) {
            return false;
        }
        logger.info((Object)"NOT importing File, is recontruction of existing...");
        return true;
    }

    private boolean seriesExists(Connection dbConnection, DicomHeader dh) throws Exception {
        String findseries = new String("SELECT seriesinstanceuid FROM dcmseries WHERE seriesinstanceuid= '" + dh.getHeaderStringValue(0x20000E) + "' ;");
        ResultSet rs = dbConnection.createStatement().executeQuery(findseries);
        return rs.next();
    }

    private int getDCMObjectID(Connection dbConnection, String uid) throws Exception {
        String findDCMObjectID = new String("SELECT id FROM dcmobject WHERE sopinstanceuid= '" + uid + "' ;");
        ResultSet rs = dbConnection.createStatement().executeQuery(findDCMObjectID);
        rs.next();
        return rs.getInt("id");
    }

    public static void main(String[] args) {
        File confFile = null;
        File filterFile = null;
        try {
            confFile = new File(args[0]);
            filterFile = new File(args[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        new DicomHeaderDBImporter(confFile, filterFile);
    }

    @Override
    public void fireDicomEvent(DicomEvent event) {
        this.images2import.add(event.getFile());
    }

    public static enum DICOM {
        SERIES,
        OBJECT,
        TAGS;

    }
}

