/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.exporter;

import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.io.FileInfo;
import ij.io.ImageWriter;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import org.apache.log4j.Logger;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.util.UIDUtils;

public class DicomExporter {
    private NumberFormat nf = new DecimalFormat("0000");
    private String charset = "ISO_IR 100";
    private String transferSyntax = "1.2.840.10008.1.2.2";
    private Properties cfg = new Properties();
    Hashtable ht0028 = new Hashtable();
    private static Logger logger = Logger.getLogger((String)DicomExporter.class.getName());

    public DicomExporter() {
        try {
            this.cfg.load(DicomExporter.class.getResourceAsStream("DicomExporter.cfg"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write(DicomObject header, ImagePlus ip, File dcmFile, boolean multislice) throws IOException {
        boolean isCompressed = false;
        boolean isStack = false;
        String transSynUID = header.getString(131088);
        if (transSynUID.indexOf("1.2.4") > -1 || transSynUID.indexOf("1.2.5") > -1) {
            isCompressed = true;
        }
        if (ip.getStackSize() > 1) {
            isStack = true;
        }
        if (!isStack) {
            this.writeImage(header, ip, dcmFile);
        } else if (isStack) {
            if (multislice) {
                this.writeMultiframe(header, ip, dcmFile);
            } else {
                int stackSize = ip.getStackSize();
                ImageStack is = ip.getStack();
                int i = 1;
                while (i <= stackSize) {
                    ImagePlus thisIP = new ImagePlus(new Integer(i).toString(), is.getProcessor(i));
                    header.putString(2097171, VR.IS, String.valueOf(i));
                    this.createUID(header, 524312);
                    this.writeImage(header, thisIP, new File(dcmFile + "_" + this.nf.format(i) + ".dcm"));
                    ++i;
                }
            }
        }
    }

    public void writeMultiframe(DicomObject header, ImagePlus ip, File dcmFile) throws IOException {
        int stackSize = ip.getStackSize();
        ImageStack is = ip.getStack();
        FileOutputStream fos = new FileOutputStream(dcmFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        DicomOutputStream dos = new DicomOutputStream((OutputStream)bos);
        try {
            try {
                dos.writeDicomFile(header);
                int pixelLength = 0;
                FileInfo fi = new ImagePlus(new Integer(1).toString(), is.getProcessor(1)).getFileInfo();
                Object pixels = fi.pixels;
                if (ip.getBitDepth() == 8) {
                    pixelLength = ((byte[])pixels).length * stackSize;
                    dos.writeHeader(2145386512, VR.OB, pixelLength);
                } else if (ip.getBitDepth() == 16) {
                    pixelLength = ((short[])pixels).length * 2 * stackSize;
                    dos.writeHeader(2145386512, VR.OW, pixelLength);
                } else if (ip.getBitDepth() == 24) {
                    pixelLength = ((int[])pixels).length * 3 * stackSize;
                    dos.writeHeader(2145386512, VR.OW, pixelLength);
                }
                int i = 1;
                while (i <= stackSize) {
                    ImagePlus thisIP = new ImagePlus(new Integer(i).toString(), is.getProcessor(i));
                    FileInfo sliceFI = thisIP.getFileInfo();
                    ImageWriter iw = new ImageWriter(sliceFI);
                    iw.write((OutputStream)dos);
                    if (pixelLength % 2 != 0) {
                        dos.write(0);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                dos.close();
            }
        }
        finally {
            dos.close();
        }
    }

    public void writeCompressedImage(DicomObject header, ImagePlus ip, File dcmFile) throws IOException {
        String transSynUID = header.getString(131088);
        if (!(transSynUID.trim().equals("1.2.840.10008.1.2.4.50") || transSynUID.trim().equals("1.2.840.10008.1.2.4.51") || transSynUID.trim().equals("1.2.840.10008.1.2.4.57") || transSynUID.trim().equals("1.2.840.10008.1.2.4.70") || transSynUID.trim().equals("1.2.840.10008.1.2.4.80") || transSynUID.trim().equals("1.2.840.10008.1.2.4.81") || transSynUID.trim().equals("1.2.840.10008.1.2.4.90") || transSynUID.trim().equals("1.2.840.10008.1.2.4.91"))) {
            transSynUID.trim().equals("1.2.840.10008.1.2.5");
        }
    }

    public void writeImage(DicomObject header, ImagePlus ip, File dcmFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(dcmFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        DicomOutputStream dos = new DicomOutputStream((OutputStream)bos);
        FileInfo fi = ip.getFileInfo();
        Object pixels = fi.pixels;
        ImageWriter iw = new ImageWriter(fi);
        try {
            try {
                dos.writeDicomFile(header);
                int pixelLength = 0;
                if (ip.getBitDepth() == 8) {
                    pixelLength = ((byte[])pixels).length;
                    dos.writeHeader(2145386512, VR.OB, pixelLength);
                } else if (ip.getBitDepth() == 16) {
                    pixelLength = ((short[])pixels).length * 2;
                    dos.writeHeader(2145386512, VR.OW, pixelLength);
                } else if (ip.getBitDepth() == 24) {
                    pixelLength = ((int[])pixels).length * 3;
                    dos.writeHeader(2145386512, VR.OW, pixelLength);
                }
                iw.write((OutputStream)dos);
                if ((pixelLength & 1) != 0) {
                    dos.write(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                dos.close();
            }
        }
        finally {
            dos.close();
        }
    }

    public DicomObject setHeaderFromString(String lociHeader, ImagePlus ip) {
        BasicDicomObject dcmObj = null;
        if (lociHeader.length() > 10) {
            dcmObj = new BasicDicomObject();
            String[] result = lociHeader.split("\\n");
            int i = 0;
            while (i < result.length) {
                try {
                    result[i] = result[i].trim();
                    String tagID = result[i].substring(0, 9);
                    String tagValue = result[i].substring(result[i].indexOf(":") + 1).trim();
                    int tagAsInt = DicomHeader.toTagInt(tagID);
                    String tagType = DicomHeader.getHeaderFieldType(tagAsInt);
                    VR tagTypeVR = DicomHeader.getHeaderFieldTypeAsVR(tagType);
                    if (!tagID.startsWith("0028")) {
                        dcmObj.putString(tagAsInt, tagTypeVR, tagValue);
                    } else if (tagID.equals("0028,0009") || tagID.equals("0028,1040")) {
                        if (tagID.equals("0028,0009")) {
                            dcmObj.putString(tagAsInt, VR.AT, tagValue);
                        } else if (tagID.equals("0028,1040")) {
                            dcmObj.putString(tagAsInt, VR.CS, tagValue);
                        }
                    } else {
                        this.ht0028.put(tagID, tagValue);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        return dcmObj;
    }

    public String parseHeaderTagsInImagePlus(ImagePlus ip) {
        String newHeader = new String();
        String originalHeader = (String)ip.getProperty("Info");
        if (originalHeader != null) {
            String[] result = originalHeader.split("\\n");
            int i = 0;
            while (i < result.length) {
                int splitIndex;
                String seriesString;
                Matcher m2;
                boolean isDicom2;
                result[i] = result[i].trim();
                Pattern p = Pattern.compile("^\\w{4},\\w{4}\\s");
                Matcher m = p.matcher(result[i]);
                boolean isDicom = m.lookingAt();
                if (isDicom) {
                    String newEntry = result[i].replace(" =", ":");
                    newHeader = String.valueOf(newHeader) + newEntry + "\n";
                } else if (result[i].startsWith("Series") && (isDicom2 = (m2 = p.matcher(seriesString = result[i].substring((splitIndex = result[i].indexOf(" ", 7)) + 1))).lookingAt())) {
                    String newEntry = result[i].replace(" =", ":");
                    newHeader = String.valueOf(newHeader) + newEntry + "\n";
                }
                ++i;
            }
        }
        return newHeader;
    }

    public DicomObject processPaletteColorData(DicomObject header, ImagePlus ip) {
        String code;
        boolean codeAsSigned = false;
        if (this.ht0028.contains("0028,0103") && (code = (String)this.ht0028.get("0028,0103")) != null && code.trim().equals("1")) {
            codeAsSigned = true;
        }
        String[] paletteArray = new String[]{"0028,1101", "0028,1102", "0028,1103", "0028,0014", "0028,1199", "0028,1221", "0028,1222", "0028,1223", "0028,0006"};
        byte[] red = ip.getFileInfo().reds;
        byte[] green = ip.getFileInfo().greens;
        byte[] blue = ip.getFileInfo().blues;
        byte[] redOut = new byte[red.length * 2];
        byte[] greenOut = new byte[green.length * 2];
        byte[] blueOut = new byte[blue.length * 2];
        int b = 0;
        if (red != null && green != null && blue != null) {
            int i = 0;
            while (i < red.length) {
                int index = i * 2;
                redOut[index + 1] = red[i];
                redOut[index] = (byte)(b >>> 8);
                blueOut[index + 1] = blue[i];
                blueOut[index] = (byte)(b >>> 8);
                greenOut[index + 1] = green[i];
                greenOut[index] = (byte)(b >>> 8);
                ++i;
            }
            try {
                VR vrValue = VR.OW;
                header.putBytes(DicomHeader.toTagInt("0028,1201"), vrValue, redOut, false);
                header.putBytes(DicomHeader.toTagInt("0028,1202"), vrValue, greenOut, false);
                header.putBytes(DicomHeader.toTagInt("0028,1203"), vrValue, blueOut, false);
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        int i = 0;
        while (i < paletteArray.length) {
            try {
                int numberOfValues = 1;
                String currentTag = paletteArray[i];
                if (this.ht0028.containsKey(currentTag)) {
                    VR vrValue;
                    int tagAsInt = DicomHeader.toTagInt(currentTag);
                    String valString = (String)this.ht0028.get(currentTag);
                    if (currentTag.equals("0028,1101") || currentTag.equals("0028,1102") || currentTag.equals("0028,1103")) {
                        vrValue = codeAsSigned ? VR.US : VR.SS;
                        if (valString.contains(" ")) {
                            String[] count = valString.split(" ");
                            numberOfValues = count.length;
                        }
                    } else {
                        vrValue = currentTag.equals("0028,1221") || currentTag.equals("0028,1222") || currentTag.equals("0028,1223") ? VR.OW : (currentTag.equals("0028,1199") ? VR.UI : VR.US);
                    }
                    if (numberOfValues > 1) {
                        String[] valueArray = valString.split(" ");
                        int k = 0;
                        while (k < valueArray.length) {
                            valueArray[k] = valueArray[k].trim();
                            ++k;
                        }
                        header.putStrings(tagAsInt, vrValue, valueArray);
                        numberOfValues = 1;
                    } else {
                        header.putString(tagAsInt, vrValue, valString);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return header;
    }

    public DicomObject createHeader(ImagePlus ip, boolean derived, boolean keepUID, boolean keepSeriesUID) throws IOException {
        BasicDicomObject header = new BasicDicomObject();
        header.putString(524293, VR.CS, this.charset);
        header.putString(524310, VR.UI, UIDUtils.createUID());
        header.putString(131074, VR.UI, UIDUtils.createUID());
        String headerString = this.parseHeaderTagsInImagePlus(ip);
        DicomObject testObj = this.setHeaderFromString(headerString, ip);
        if (testObj != null) {
            header = testObj;
        } else {
            logger.warn((Object)"file does not contain a dicom header, using default...");
        }
        int bitDepth = ip.getBitDepth();
        String originalType = "";
        if (this.ht0028.containsKey("0028,0004")) {
            originalType = ((String)this.ht0028.get("0028,0004")).trim();
        }
        if (bitDepth == 8) {
            if (originalType.equalsIgnoreCase("PALETTE COLOR")) {
                header.putString(2621444, VR.CS, "PALETTE COLOR");
                header = this.processPaletteColorData((DicomObject)header, ip);
            } else if (originalType.equalsIgnoreCase("MONOCHROME2")) {
                header.putString(2621444, VR.CS, "MONOCHROME2");
            } else {
                header.putString(2621444, VR.CS, "MONOCHROME");
            }
            header.putInt(0x280002, VR.US, 1);
            header.putInt(2621696, VR.US, 8);
            header.putInt(2621698, VR.US, 7);
        } else if (bitDepth == 16) {
            if (originalType.equalsIgnoreCase("PALETTE COLOR")) {
                header.putString(2621444, VR.CS, "PALETTE COLOR");
                header = this.processPaletteColorData((DicomObject)header, ip);
            } else if (originalType.equalsIgnoreCase("MONOCHROME")) {
                header.putString(2621444, VR.CS, "MONOCHROME");
            } else {
                header.putString(2621444, VR.CS, "MONOCHROME2");
            }
            header.putInt(0x280002, VR.US, 1);
            header.putInt(2621696, VR.US, 16);
            header.putInt(2621698, VR.US, 15);
        } else if (bitDepth == 24) {
            header.putString(2621444, VR.CS, "RGB");
            header.putInt(2621446, VR.US, 0);
            header.putInt(0x280002, VR.US, 3);
            header.putInt(2621696, VR.US, 8);
            header.putInt(2621698, VR.US, 7);
        }
        header.putInt(2621697, VR.US, bitDepth);
        header.putInt(2621456, VR.US, ip.getHeight());
        header.putInt(2621457, VR.US, ip.getWidth());
        header.putInt(2621699, VR.US, 0);
        header.putInt(0x280008, VR.IS, ip.getStackSize());
        this.ensureUS((DicomObject)header, 2621696, 8);
        this.ensureUS((DicomObject)header, 2621697, header.getInt(2621696));
        this.ensureUS((DicomObject)header, 2621698, header.getInt(2621697) - 1);
        this.ensureUS((DicomObject)header, 2621699, 0);
        try {
            double[] d = ip.getCalibration().getCoefficients();
            header.putString(2625618, VR.DS, String.valueOf(d[0]));
            header.putString(2625619, VR.DS, String.valueOf(d[1]));
        }
        catch (Exception e) {
            logger.info((Object)"No Calibration found in image...");
        }
        this.ensureCS((DicomObject)header, 524384, "SC");
        this.ensureUID((DicomObject)header, 0x20000D);
        if (keepSeriesUID) {
            this.ensureUID((DicomObject)header, 0x20000E);
        } else {
            this.createUID((DicomObject)header, 0x20000E);
        }
        if (keepUID) {
            this.ensureUID((DicomObject)header, 524312);
        } else {
            this.createUID((DicomObject)header, 524312);
        }
        Date now = new Date();
        this.ensureDate((DicomObject)header, 524306, VR.DA, now);
        this.ensureDate((DicomObject)header, 524307, VR.TM, now);
        if (derived) {
            header.putString(524296, VR.CS, "DERIVED/SECONDARY");
        }
        header.initFileMetaInformation(this.transferSyntax);
        return header;
    }

    private void createUID(DicomObject attrs, int tag) {
        attrs.putString(tag, VR.UI, UIDUtils.createUID());
    }

    private void ensureUID(DicomObject attrs, int tag) {
        if (!attrs.containsValue(tag)) {
            attrs.putString(tag, VR.UI, UIDUtils.createUID());
        }
    }

    private void ensureUS(DicomObject attrs, int tag, int val) {
        if (!attrs.containsValue(tag)) {
            attrs.putInt(tag, VR.US, val);
        }
    }

    private void ensureCS(DicomObject attrs, int tag, String val) {
        if (!attrs.containsValue(tag)) {
            attrs.putString(tag, VR.CS, val);
        }
    }

    private void ensureDate(DicomObject attrs, int tag, VR vr, Date val) {
        if (!attrs.containsValue(tag)) {
            attrs.putDate(tag, vr, val);
        }
    }

    public static void main(String[] args) {
        try {
            DicomExporter exporter = new DicomExporter();
            File dcmFile = new File("/home/hermenj/jhermen.dcm");
            ImagePlus ip = new ImagePlus("/home/hermenj/im0");
            DicomObject dObj = exporter.createHeader(ip, true, true, true);
            exporter.write(dObj, ip, dcmFile, true);
            ImagePlus image = new ImagePlus(dcmFile.getAbsolutePath());
            new ImageJ().show();
            WindowManager.addWindow((Frame)new ImageWindow(image));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

