/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import ij.plugin.BrowserLauncher;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;
import org.apache.log4j.Logger;

public class DICOMWebViewSettingsPlugin
extends SettingsPlugin {
    private static final long serialVersionUID = 1L;
    public static final String WEBVIEW1_ENABLED = "WebView1Enabled";
    public static final String WEBURL1 = "WEBURL1";
    public static final String WEBNAME1 = "WEBNAME1";
    public static final String WEBVIEW2_ENABLED = "WebView2Enabled";
    public static final String WEBURL2 = "WEBURL2";
    public static final String WEBNAME2 = "WEBNAME2";
    public static final String WEBVIEW3_ENABLED = "WebView3Enabled";
    public static final String WEBURL3 = "WEBURL3";
    public static final String WEBNAME3 = "WEBNAME3";
    private JPanel dicomWebViewPanel;
    private JCheckBox url1Enabled;
    private JButton jb1;
    private JLabel url1StringLabel;
    private JTextField url1String;
    private JLabel help1String;
    private JLabel help1StringLabel;
    private JLabel name1StringLabel;
    private JTextField name1String;
    private JCheckBox url2Enabled;
    private JLabel name2StringLabel;
    private JTextField name2String;
    private JLabel url2StringLabel;
    private JTextField url2String;
    private JLabel help2StringLabel;
    private JLabel help2String;
    private JCheckBox url3Enabled;
    private JLabel name3StringLabel;
    private JTextField name3String;
    private JLabel url3StringLabel;
    private JTextField url3String;
    private JLabel help3StringLabel;
    private JLabel help3String;
    private static Logger logger = Logger.getLogger((String)"lu.tudor.santec.dicom.gui.DICOMWebViewSettingsPlugin");
    private static final ImageIcon FAILED = DicomIcons.getIcon("status_failed.png");
    private static final ImageIcon UNKNOWN = DicomIcons.getIcon("status_unknown.png");

    public DICOMWebViewSettingsPlugin(String name) {
        super(name);
        this.init();
    }

    private void init() {
        this.setIcon(DicomIcons.getIcon("web.png"));
        this.setStationaryValues();
        this.buildPanel();
        this.relocalize();
    }

    private void buildPanel() {
        this.initComponents();
        CellConstraints cc = new CellConstraints();
        FormLayout dicomQueryLayout = new FormLayout("55dlu, 2dlu, pref:grow, 2dlu, 40dlu, 2dlu, 20dlu, 2dlu, 20dlu, 10dlu", "pref, 2dlu, pref, 2dlu, pref, 2dlu, top:pref, 2dlu");
        this.dicomWebViewPanel = this.createSubPanel(String.valueOf(Translatrix.getTranslationString((String)"dicom.DicomWebView")) + " 1");
        this.dicomWebViewPanel.setLayout((LayoutManager)dicomQueryLayout);
        this.dicomWebViewPanel.add((Component)this.url1Enabled, cc.xyw(1, 1, 3));
        this.jb1 = this.createTestButton(this.url1String);
        this.dicomWebViewPanel.add((Component)this.jb1, cc.xy(10, 1));
        this.dicomWebViewPanel.add((Component)this.name1StringLabel, cc.xy(1, 3));
        this.dicomWebViewPanel.add((Component)this.name1String, cc.xyw(3, 3, 8));
        this.dicomWebViewPanel.add((Component)this.url1StringLabel, cc.xy(1, 5));
        this.dicomWebViewPanel.add((Component)this.url1String, cc.xyw(3, 5, 8));
        this.dicomWebViewPanel.add((Component)this.help1StringLabel, cc.xy(1, 7));
        this.dicomWebViewPanel.add((Component)this.help1String, cc.xyw(3, 7, 8));
        this.addSubPanel(this.dicomWebViewPanel);
        this.dicomWebViewPanel = this.createSubPanel(String.valueOf(Translatrix.getTranslationString((String)"dicom.DicomWebView")) + " 2");
        this.dicomWebViewPanel.setLayout((LayoutManager)dicomQueryLayout);
        this.dicomWebViewPanel.add((Component)this.url2Enabled, cc.xyw(1, 1, 3));
        JButton jb2 = this.createTestButton(this.url2String);
        this.dicomWebViewPanel.add((Component)jb2, cc.xy(10, 1));
        this.dicomWebViewPanel.add((Component)this.name2StringLabel, cc.xy(1, 3));
        this.dicomWebViewPanel.add((Component)this.name2String, cc.xyw(3, 3, 8));
        this.dicomWebViewPanel.add((Component)this.url2StringLabel, cc.xy(1, 5));
        this.dicomWebViewPanel.add((Component)this.url2String, cc.xyw(3, 5, 8));
        this.dicomWebViewPanel.add((Component)this.help2StringLabel, cc.xy(1, 7));
        this.dicomWebViewPanel.add((Component)this.help2String, cc.xyw(3, 7, 8));
        this.addSubPanel(this.dicomWebViewPanel);
        this.dicomWebViewPanel = this.createSubPanel(String.valueOf(Translatrix.getTranslationString((String)"dicom.DicomWebView")) + " 3");
        this.dicomWebViewPanel.setLayout((LayoutManager)dicomQueryLayout);
        this.dicomWebViewPanel.add((Component)this.url3Enabled, cc.xyw(1, 1, 3));
        JButton jb3 = this.createTestButton(this.url3String);
        this.dicomWebViewPanel.add((Component)jb3, cc.xy(10, 1));
        this.dicomWebViewPanel.add((Component)this.name3StringLabel, cc.xy(1, 3));
        this.dicomWebViewPanel.add((Component)this.name3String, cc.xyw(3, 3, 8));
        this.dicomWebViewPanel.add((Component)this.url3StringLabel, cc.xy(1, 5));
        this.dicomWebViewPanel.add((Component)this.url3String, cc.xyw(3, 5, 8));
        this.dicomWebViewPanel.add((Component)this.help3StringLabel, cc.xy(1, 7));
        this.dicomWebViewPanel.add((Component)this.help3String, cc.xyw(3, 7, 8));
        this.addSubPanel(this.dicomWebViewPanel);
    }

    private void initComponents() {
        String help = "<html>$PATID<br>$ACCNR<br>$STUDYUID<br>$SERIESUID<br>$SOPUID";
        this.url1Enabled = new JCheckBox();
        this.name1StringLabel = new JLabel();
        this.name1String = new JTextField();
        this.url1StringLabel = new JLabel();
        this.url1String = new JTextField();
        this.help1StringLabel = new JLabel();
        this.help1String = new JLabel();
        this.help1String.setText(help);
        this.url2Enabled = new JCheckBox();
        this.name2StringLabel = new JLabel();
        this.name2String = new JTextField();
        this.url2StringLabel = new JLabel();
        this.url2String = new JTextField();
        this.help2StringLabel = new JLabel();
        this.help2String = new JLabel();
        this.help2String.setText(help);
        this.url3Enabled = new JCheckBox();
        this.name3StringLabel = new JLabel();
        this.name3String = new JTextField();
        this.url3StringLabel = new JLabel();
        this.url3String = new JTextField();
        this.help3StringLabel = new JLabel();
        this.help3String = new JLabel();
        this.help3String.setText(help);
    }

    public void revertToDefaults() {
        this.url1Enabled.setSelected((Boolean)this.getDefault(WEBVIEW1_ENABLED));
        this.url1String.setText((String)this.getDefault(WEBURL1));
        this.url2Enabled.setSelected((Boolean)this.getDefault(WEBVIEW2_ENABLED));
        this.url2String.setText((String)this.getDefault(WEBURL2));
        this.url3Enabled.setSelected((Boolean)this.getDefault(WEBVIEW3_ENABLED));
        this.url3String.setText((String)this.getDefault(WEBURL3));
        this.reflectSettings();
        super.revertToDefaults();
    }

    public void setStationaryValues() {
        this.setStationary(WEBVIEW1_ENABLED, new Boolean(false));
        this.setStationary(WEBNAME1, "View Patient");
        this.setStationary(WEBURL1, "http://pacs_ip:8080/webviewer?patID=$PATID");
        this.setStationary(WEBVIEW2_ENABLED, new Boolean(false));
        this.setStationary(WEBNAME2, "View Series");
        this.setStationary(WEBURL2, "http://pacs_ip:8080/webviewer?seriesID=$SERIESUID");
        this.setStationary(WEBVIEW3_ENABLED, new Boolean(false));
        this.setStationary(WEBNAME3, "View Study");
        this.setStationary(WEBURL3, "http://pacs_ip:8080/webviewer?studyID=$STUDYUID");
    }

    public void updateSettings() {
        this.setValue(WEBVIEW1_ENABLED, new Boolean(this.url1Enabled.isSelected()));
        this.setValue(WEBNAME1, this.name1String.getText());
        this.setValue(WEBURL1, this.url1String.getText());
        this.setValue(WEBVIEW2_ENABLED, new Boolean(this.url2Enabled.isSelected()));
        this.setValue(WEBNAME2, this.name2String.getText());
        this.setValue(WEBURL2, this.url2String.getText());
        this.setValue(WEBVIEW3_ENABLED, new Boolean(this.url3Enabled.isSelected()));
        this.setValue(WEBNAME3, this.name3String.getText());
        this.setValue(WEBURL3, this.url3String.getText());
        super.updateSettings();
    }

    public void reflectSettings() {
        super.reflectSettings();
        try {
            this.url1Enabled.setSelected((Boolean)this.getValue(WEBVIEW1_ENABLED));
            this.url1String.setText((String)this.getValue(WEBURL1));
            this.name1String.setText((String)this.getValue(WEBNAME1));
            this.url2Enabled.setSelected((Boolean)this.getValue(WEBVIEW2_ENABLED));
            this.url2String.setText((String)this.getValue(WEBURL2));
            this.name2String.setText((String)this.getValue(WEBNAME2));
            this.url3Enabled.setSelected((Boolean)this.getValue(WEBVIEW3_ENABLED));
            this.url3String.setText((String)this.getValue(WEBURL3));
            this.name3String.setText((String)this.getValue(WEBNAME3));
        }
        catch (Exception e) {
            logger.warn((Object)("Could not load Settings: " + e.getLocalizedMessage()));
        }
    }

    public void relocalize() {
        this.setLabel(Translatrix.getTranslationString((String)"dicom.DicomWebView"));
        this.setSubPanelTitle(this.dicomWebViewPanel, Translatrix.getTranslationString((String)"dicom.DicomWebView"));
        this.url1Enabled.setText(Translatrix.getTranslationString((String)"dicom.Show"));
        this.name1StringLabel.setText(Translatrix.getTranslationString((String)"dicom.WebViewName"));
        this.url1StringLabel.setText(Translatrix.getTranslationString((String)"dicom.WebViewURL"));
        this.help1StringLabel.setText(Translatrix.getTranslationString((String)"dicom.WebViewHelp"));
        this.url2Enabled.setText(Translatrix.getTranslationString((String)"dicom.Show"));
        this.name2StringLabel.setText(Translatrix.getTranslationString((String)"dicom.WebViewName"));
        this.url2StringLabel.setText(Translatrix.getTranslationString((String)"dicom.WebViewURL"));
        this.help2StringLabel.setText(Translatrix.getTranslationString((String)"dicom.WebViewHelp"));
        this.url3Enabled.setText(Translatrix.getTranslationString((String)"dicom.Show"));
        this.name3StringLabel.setText(Translatrix.getTranslationString((String)"dicom.WebViewName"));
        this.url3StringLabel.setText(Translatrix.getTranslationString((String)"dicom.WebViewURL"));
        this.help3StringLabel.setText(Translatrix.getTranslationString((String)"dicom.WebViewHelp"));
    }

    public JButton createTestButton(final JTextField urlString) {
        final JButton jb = new JButton(UNKNOWN);
        jb.setToolTipText("Test connection");
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher.openURL((String)DICOMWebViewSettingsPlugin.getURL(urlString.getText(), "aaaa", "bbbb", "cccc", "dddd", "eeee"));
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    jb.setIcon(FAILED);
                }
            }
        });
        return jb;
    }

    public static String getURL(String url, String patID, String accNr, String studyUID, String seriesUID, String sopUID) {
        url = url.replaceAll("\\$PATID", patID);
        url = url.replaceAll("\\$ACCNR", accNr);
        url = url.replaceAll("\\$STUDYUID", studyUID);
        url = url.replaceAll("\\$SERIESUID", seriesUID);
        url = url.replaceAll("\\$SOPUID", sopUID);
        return url;
    }

    public static void openURL(String url, String patID, String accNr, String studyUID, String seriesUID, String sopUID) throws IOException {
        url = url.replaceAll("\\$PATID", patID);
        url = url.replaceAll("\\$ACCNR", accNr);
        url = url.replaceAll("\\$STUDYUID", studyUID);
        url = url.replaceAll("\\$SERIESUID", seriesUID);
        url = url.replaceAll("\\$SOPUID", sopUID);
        BrowserLauncher.openURL((String)url);
    }

    public Vector<JButton> getButtons() {
        JButton b1;
        Vector<JButton> buttons = new Vector<JButton>();
        if (this.url1Enabled.isSelected()) {
            b1 = new JButton(DicomIcons.getIcon("web1.png"));
            b1.setToolTipText(this.name1String.getText());
            b1.setActionCommand(this.url1String.getText());
            buttons.add(b1);
        }
        if (this.url2Enabled.isSelected()) {
            b1 = new JButton(DicomIcons.getIcon("web2.png"));
            b1.setToolTipText(this.name2String.getText());
            b1.setActionCommand(this.url2String.getText());
            buttons.add(b1);
        }
        if (this.url3Enabled.isSelected()) {
            b1 = new JButton(DicomIcons.getIcon("web3.png"));
            b1.setToolTipText(this.name3String.getText());
            b1.setActionCommand(this.url3String.getText());
            buttons.add(b1);
        }
        return buttons;
    }
}

