/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.plugin.ImageCalculator;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import lu.tudor.santec.dicom.DicomOpener;
import lu.tudor.santec.dicom.gui.DicomFileDialog;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.DicomHeaderInfoPanel;
import lu.tudor.santec.dicom.gui.header.Diff;
import lu.tudor.santec.dicom.gui.viewer.DicomImagePanel;
import lu.tudor.santec.dicom.gui.viewer.WindowListener;

public class DicomImageDiffDialog
extends JFrame
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private MyAdjustmentListener adjustmentListener;
    private DicomFileDialog dicomFileDialog;
    private JPanel headerPanel;
    private JPanel filePanel;
    private JPanel imagePanel;
    private DicomImagePanel dipLeft;
    private DicomImagePanel dipDiff;
    private DicomImagePanel dipRight;
    private DicomHeaderInfoPanel headerPanelLeft;
    private DicomHeaderInfoPanel headerPanelRight;
    protected ImagePlus imageLeft;
    protected ImagePlus imageRight;
    private ImagePlus imageDiff;

    public DicomImageDiffDialog(DicomFileDialog dialog) {
        this.dicomFileDialog = dialog;
        this.setTitle("DICOM Image Diff");
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new BorderLayout());
        this.filePanel = new JPanel(new GridLayout(1, 2));
        this.headerPanel = new JPanel();
        this.headerPanel.setLayout(new GridLayout(1, 2));
        this.setTitle("DICOM Diff");
        this.adjustmentListener = new MyAdjustmentListener();
        this.headerPanelLeft = new DicomHeaderInfoPanel(null);
        this.headerPanelLeft.addAdjustmentListener(this.adjustmentListener);
        this.headerPanelLeft.addPropertyChangeListener(this);
        this.headerPanel.add(this.headerPanelLeft);
        JButton jbLeft = new JButton("select left image");
        jbLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DicomImageDiffDialog.this.dicomFileDialog.showNewDialog(DicomImageDiffDialog.this) == 0) {
                    File f = DicomImageDiffDialog.this.dicomFileDialog.getSelectedFile();
                    DicomHeader dh = new DicomHeader(f);
                    DicomImageDiffDialog.this.headerPanelLeft.setInfo(dh);
                    try {
                        DicomImageDiffDialog.this.imageLeft = DicomOpener.loadImage(f);
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                        DicomImageDiffDialog.this.imageLeft = null;
                    }
                    DicomImageDiffDialog.this.dipLeft.setImage(DicomImageDiffDialog.this.imageLeft);
                    DicomImageDiffDialog.this.createDiffImage();
                }
            }
        });
        this.filePanel.add(jbLeft);
        this.headerPanelRight = new DicomHeaderInfoPanel(null);
        this.headerPanelRight.addAdjustmentListener(this.adjustmentListener);
        this.headerPanelRight.addPropertyChangeListener(this);
        this.headerPanel.add(this.headerPanelRight);
        JButton jbRight = new JButton("select right image");
        jbRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DicomImageDiffDialog.this.dicomFileDialog.showNewDialog(DicomImageDiffDialog.this) == 0) {
                    File f = DicomImageDiffDialog.this.dicomFileDialog.getSelectedFile();
                    DicomHeader dh = new DicomHeader(f);
                    DicomImageDiffDialog.this.headerPanelRight.setInfo(dh);
                    try {
                        DicomImageDiffDialog.this.imageRight = DicomOpener.loadImage(f);
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                        DicomImageDiffDialog.this.imageRight = null;
                    }
                    DicomImageDiffDialog.this.dipRight.setImage(DicomImageDiffDialog.this.imageRight);
                    DicomImageDiffDialog.this.createDiffImage();
                }
            }
        });
        this.filePanel.add(jbRight);
        this.add((Component)this.filePanel, "North");
        this.imagePanel = new JPanel();
        this.imagePanel.setLayout((LayoutManager)new FormLayout("fill:pref:grow, fill:pref:grow, fill:pref:grow", "fill:270dlu, 3dlu, fill:pref:grow"));
        CellConstraints cc = new CellConstraints();
        this.dipLeft = new DicomImagePanel(300, 300);
        this.dipDiff = new DicomImagePanel(300, 300);
        this.dipRight = new DicomImagePanel(300, 300);
        WindowListener wl = new WindowListener(){

            @Override
            public void setWindow(DicomImagePanel source, int windowCenter, int windowWidth) {
                if (!source.equals(DicomImageDiffDialog.this.dipLeft)) {
                    DicomImageDiffDialog.this.dipLeft.setWindow(windowCenter, windowWidth);
                    DicomImageDiffDialog.this.dipLeft.repaint();
                }
                if (!source.equals(DicomImageDiffDialog.this.dipRight)) {
                    DicomImageDiffDialog.this.dipRight.setWindow(windowCenter, windowWidth);
                    DicomImageDiffDialog.this.dipRight.repaint();
                }
            }
        };
        this.dipLeft.addWindowsListener(wl);
        this.dipRight.addWindowsListener(wl);
        this.imagePanel.add((Component)this.dipLeft, cc.xy(1, 1));
        this.imagePanel.add((Component)this.dipDiff, cc.xy(2, 1));
        this.imagePanel.add((Component)this.dipRight, cc.xy(3, 1));
        this.imagePanel.add((Component)this.headerPanel, cc.xyw(1, 3, 3));
        this.add((Component)this.imagePanel, "Center");
        this.setSize(800, 800);
        this.setVisible(true);
        this.setExtendedState(6);
    }

    protected void createDiffImage() {
        if (this.imageLeft == null || this.imageRight == null) {
            this.imageDiff = null;
        } else {
            ImageCalculator ic = new ImageCalculator();
            this.imageDiff = new ImagePlus("diff", this.imageLeft.getProcessor().duplicate());
            FileInfo fi = new FileInfo();
            fi.directory = this.imageLeft.getOriginalFileInfo().directory;
            fi.fileName = this.imageLeft.getOriginalFileInfo().fileName;
            this.imageDiff.setFileInfo(fi);
            ic.calculate("diff", this.imageDiff, this.imageRight);
        }
        this.dipDiff.setImage(this.imageDiff);
    }

    public void setInfo(File f) {
        DicomHeader dh = new DicomHeader(f);
        this.headerPanelLeft.setInfo(dh);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FILE_CHANGED")) {
            if (this.headerPanelLeft.getText() == null || this.headerPanelLeft.getText().length() < 2 || this.headerPanelRight.getText() == null || this.headerPanelRight.getText().length() < 2) {
                return;
            }
            Diff diff = new Diff();
            this.headerPanelLeft.showDiff(diff.diff(this.headerPanelLeft.getText(), this.headerPanelRight.getText()));
            this.headerPanelRight.showDiff(diff.diff(this.headerPanelRight.getText(), this.headerPanelLeft.getText()));
            try {
                this.setTitle("Dicom Diff: " + this.headerPanelLeft.getFile().getName() + " vs " + this.headerPanelRight.getFile().getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class MyAdjustmentListener
    implements AdjustmentListener {
        MyAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent evt) {
            Adjustable source = evt.getAdjustable();
            if (evt.getValueIsAdjusting()) {
                return;
            }
            int orient = source.getOrientation();
            int type = evt.getAdjustmentType();
            switch (type) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
                case 3: {
                    break;
                }
            }
            int value = evt.getValue();
            DicomImageDiffDialog.this.headerPanelLeft.setAdjustment(value);
            DicomImageDiffDialog.this.headerPanelRight.setAdjustment(value);
        }
    }
}

