/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import lu.tudor.santec.dicom.gui.ButtonEditor;
import lu.tudor.santec.dicom.gui.ButtonRenderer;
import lu.tudor.santec.dicom.gui.DicomURLTableModel;
import org.dcm4che.util.DcmURL;

public class DicomURLChooser
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel bottomPanel;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton okButton;
    private JTable urlList;
    private DcmURL url;
    protected DicomURLTableModel urlTableModel;

    public DicomURLChooser(JDialog parent, DcmURL[] urls) {
        super(parent, "Select Dicom Node", true);
        BorderLayout bl = new BorderLayout();
        this.getContentPane().setLayout(bl);
        this.bottomPanel = new JPanel(new BorderLayout());
        this.buttonPanel = new JPanel(new GridLayout(1, 0));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.cancelButton);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.bottomPanel.add((Component)this.buttonPanel, "East");
        this.getContentPane().add((Component)this.bottomPanel, "South");
        JLabel jl = new JLabel("<html><h3>Send to Destination:");
        jl.setOpaque(false);
        this.getContentPane().add((Component)jl, "North");
        this.urlTableModel = new DicomURLTableModel(false);
        this.urlTableModel.setUrls(urls);
        this.urlList = new JTable(this.urlTableModel);
        this.urlList.getColumnModel().getColumn(3).setMaxWidth(50);
        this.urlList.getColumnModel().getColumn(4).setCellRenderer(new ButtonRenderer());
        this.urlList.getColumnModel().getColumn(4).setCellEditor(new ButtonEditor());
        this.urlList.getColumnModel().getColumn(4).setMaxWidth(30);
        this.urlList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DicomURLChooser.this.url = DicomURLChooser.this.urlTableModel.getUrl(DicomURLChooser.this.urlList.getSelectedRow());
                    DicomURLChooser.this.setVisible(false);
                }
            }
        });
        this.getContentPane().add((Component)new JScrollPane(this.urlList), "Center");
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                DicomURLChooser.this.urlList.setRowSelectionInterval(0, 0);
                DicomURLChooser.this.urlTableModel.testURLs();
                DicomURLChooser.this.urlList.setRowSelectionInterval(0, 0);
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.cancelButton)) {
            this.url = null;
        } else if (arg0.getSource().equals(this.okButton)) {
            this.url = this.urlTableModel.getUrl(this.urlList.getSelectedRow());
        }
        this.setVisible(false);
    }

    public static DcmURL showDialog(JDialog parent, DcmURL[] urls) {
        DicomURLChooser dialog = new DicomURLChooser(parent, urls);
        dialog.setSize(480, 320);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.url;
    }

    public static void main(String[] args) {
        JDialog jf = new JDialog();
        DcmURL[] urls = new DcmURL[]{new DcmURL("dicom://receiver:sender@localhost:8080"), new DcmURL("dicom://receiver:sender@localhost:8080"), new DcmURL("dicom://receiver:sender@localhost:8080"), new DcmURL("dicom://receiver:sender@localhost:8080")};
        System.out.println(DicomURLChooser.showDialog(jf, urls));
    }
}

