/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.utils.DCMEcho;
import org.dcm4che.util.DcmURL;

public class DicomURLTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon FAILED = DicomIcons.getIcon("status_failed.png");
    private static final ImageIcon OK = DicomIcons.getIcon("status_ok.png");
    private static final ImageIcon UNKNOWN = DicomIcons.getIcon("status_unknown.png");
    private String[] columns = new String[]{"Send To AET", "Send From AET", "Host", "Port", "Test"};
    private ArrayList urls = new ArrayList();
    private ArrayList<JButton> buttons = new ArrayList();
    private boolean editable;

    public DicomURLTableModel(boolean editable) {
        this.editable = editable;
    }

    @Override
    public int getRowCount() {
        return this.urls.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DcmURL url = (DcmURL)this.urls.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return url.getCalledAET();
            }
            case 1: {
                String s = url.getCallingAET();
                if (s != null) {
                    return s;
                }
                return "";
            }
            case 2: {
                return url.getHost();
            }
            case 3: {
                return String.valueOf(url.getPort());
            }
            case 4: {
                try {
                    return this.buttons.get(rowIndex);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public JButton createTestButton(final int row) {
        final JButton jb = new JButton(UNKNOWN);
        jb.setToolTipText("Test connection");
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DcmURL url = new DcmURL("dicom://" + DicomURLTableModel.this.getValueAt(row, 0) + ":" + DicomURLTableModel.this.getValueAt(row, 1) + "@" + DicomURLTableModel.this.getValueAt(row, 2) + ":" + DicomURLTableModel.this.getValueAt(row, 3));
                    if (DCMEcho.sendEcho(url) == 0) {
                        jb.setIcon(OK);
                    } else {
                        jb.setIcon(FAILED);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return jb;
    }

    public void setUrls(String s) {
        String[] ur = s.split("\n");
        this.urls = new ArrayList();
        this.buttons = new ArrayList();
        int i = 0;
        while (i < ur.length) {
            this.urls.add(new DcmURL(ur[i]));
            this.buttons.add(this.createTestButton(i));
            ++i;
        }
        this.fireTableDataChanged();
    }

    public void setUrls(DcmURL[] ur) {
        this.urls = new ArrayList();
        this.buttons = new ArrayList();
        int i = 0;
        while (i < ur.length) {
            this.urls.add(ur[i]);
            this.buttons.add(this.createTestButton(i));
            ++i;
        }
        this.fireTableDataChanged();
    }

    public DcmURL[] getUrls() {
        return this.urls.toArray(new DcmURL[0]);
    }

    public void removeLine(int line) {
        this.urls.remove(line);
        this.buttons.remove(line);
        this.fireTableDataChanged();
    }

    public void addLine(DcmURL url) {
        this.urls.add(url);
        this.buttons.add(this.createTestButton(this.urls.size()));
        this.fireTableDataChanged();
    }

    public String getUrlsAsString() {
        StringBuffer sb = new StringBuffer();
        for (DcmURL element : this.urls) {
            sb.append(element + "\n");
        }
        return sb.toString();
    }

    public DcmURL getUrl(int line) {
        try {
            return (DcmURL)this.urls.get(line);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 4) {
            return true;
        }
        return this.editable;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        DcmURL url = (DcmURL)this.urls.get(rowIndex);
        String called = url.getCalledAET();
        String calling = url.getCallingAET();
        String host = url.getHost();
        String port = String.valueOf(url.getPort());
        switch (columnIndex) {
            case 0: {
                called = (String)aValue;
                break;
            }
            case 1: {
                calling = (String)aValue;
                break;
            }
            case 2: {
                host = (String)aValue;
                break;
            }
            case 3: {
                port = (String)aValue;
            }
        }
        url = new DcmURL("dicom://" + called + ":" + calling + "@" + host + ":" + port);
        this.urls.set(rowIndex, url);
    }

    public void testURLs() {
        try {
            for (JButton button : this.buttons) {
                button.doClick();
                this.fireTableDataChanged();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

