/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.SpaceListener;

public class DiskspaceMonitorButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 3030537064914356613L;
    private static NumberFormat nf = NumberFormat.getNumberInstance();
    private boolean drawLeds;
    private File path;
    private File disc;
    private Vector<SpaceListener> listeners = new Vector();
    private String label = "Disc";
    private int SIZE;
    private int BAR_WITH = 8;
    private int VOFFSET = 5;
    private int HOFFSET = 5;
    private static final Color USED = Color.RED;
    private static final Color ALLOC = Color.YELLOW;
    private static final Color FREE = Color.GREEN;
    private static final Color USED_DISABLED = new Color(255, 0, 0, 40);
    private static final Color ALLOC_DISABLED = new Color(255, 255, 0, 40);
    private static final Color FREE_DISABLED = new Color(0, 255, 0, 40);
    private static final int LEDSPAN = 1;
    private static final int LEDSIZE = 2;

    public DiskspaceMonitorButton(File path, boolean drawLeds) {
        this(path, drawLeds, "Disc", 32);
    }

    public DiskspaceMonitorButton(File path, boolean drawLeds, int size) {
        this(path, drawLeds, "Disc", size);
    }

    public DiskspaceMonitorButton(File path, boolean drawLeds, String label) {
        this(path, drawLeds, "Disc", 32);
    }

    public DiskspaceMonitorButton(File path, boolean drawLeds, String label, int size) {
        this.SIZE = size;
        this.BAR_WITH = size / 4;
        this.HOFFSET = size / 6;
        this.path = path;
        this.label = label;
        try {
            File[] fileArray = File.listRoots();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File disc = fileArray[n2];
                if (path.getAbsolutePath().startsWith(disc.getAbsolutePath())) {
                    this.disc = disc;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setFocusPainted(false);
        this.drawLeds = drawLeds;
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        try {
            this.setIcon(DicomIcons.getIcon("memory.png", size));
        }
        catch (Exception e) {
            System.out.println("Icon for memory button missing");
        }
        this.setSize(40, 40);
        this.addActionListener(this);
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            DiskspaceMonitorButton.this.repaint();
                            Thread.sleep(10000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        double totalSpace = this.path.getTotalSpace() / 1024L / 1024L;
        double totalAvailable = this.path.getUsableSpace() / 1024L / 1024L;
        double freeMB = this.path.getFreeSpace() / 1024L;
        double free = freeMB / 1024.0;
        double used = totalSpace - free;
        if (this.drawLeds) {
            this.drawLeds(g, used, totalAvailable, totalSpace);
        } else {
            this.drawBar(g, used, totalAvailable, totalSpace);
        }
        if (this.isEnabled()) {
            String pathName = "";
            String discName = "";
            try {
                pathName = this.path.getAbsolutePath();
                discName = this.disc.getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setToolTipText("<html><h2>&nbsp;&nbsp; Disc-Space Status: &nbsp;&nbsp;</h2><b>&nbsp;&nbsp; Dir:</b>" + pathName + " <br>" + "<b>&nbsp;&nbsp; Disc:</b>" + discName + " <br><br>" + "<b>&nbsp;&nbsp; Total: </b>" + nf.format(totalSpace / 1024.0) + " gb<br>" + "<b>&nbsp;&nbsp; Used: </b>" + nf.format(used / 1024.0) + " gb<br>" + "<b>&nbsp;&nbsp; Free: </b>" + nf.format(free / 1024.0) + " gb<br>&nbsp;");
            for (SpaceListener listener : this.listeners) {
                if (!(freeMB <= (double)listener.getFreeMBLimit())) continue;
                listener.spaceLow(this.path.getAbsolutePath(), freeMB);
            }
        }
    }

    public static String getDiskInfo(File path) {
        double totalSpace = path.getTotalSpace() / 1024L / 1024L;
        double freeMB = path.getFreeSpace() / 1024L;
        double free = freeMB / 1024.0;
        return "Total: " + nf.format(totalSpace / 1024.0) + " gb, " + "Free: " + nf.format(free / 1024.0) + " gb ";
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        jf.add(new DiskspaceMonitorButton(new File("."), true, 22));
        jf.pack();
        jf.setVisible(true);
        jf.setDefaultCloseOperation(3);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void drawBar(Graphics g, double used, double totalAlloc, double totalSpace) {
        int usedDraw = (int)(used / totalSpace * 30.0);
        int allocDraw = (int)(totalAlloc / totalSpace * 30.0);
        if (this.isEnabled()) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(Color.LIGHT_GRAY);
        }
        g.setFont(new Font("SansSerif", 0, 10));
        g.drawString(this.label, this.HOFFSET + this.BAR_WITH + 1, this.VOFFSET + (int)((double)this.SIZE / 2.5));
        g.drawString("Info", this.HOFFSET + this.BAR_WITH + 1, this.VOFFSET + (int)((double)this.SIZE / 1.2));
        if (this.isEnabled()) {
            g.setColor(FREE);
        } else {
            g.setColor(FREE_DISABLED);
        }
        g.fillRect(this.HOFFSET, this.VOFFSET, this.BAR_WITH, this.SIZE - 1);
        if (this.isEnabled()) {
            g.setColor(ALLOC);
        } else {
            g.setColor(ALLOC_DISABLED);
        }
        g.fillRect(this.HOFFSET, this.SIZE - allocDraw + this.VOFFSET, this.BAR_WITH, allocDraw);
        if (this.isEnabled()) {
            g.setColor(USED);
        } else {
            g.setColor(USED_DISABLED);
        }
        g.fillRect(this.HOFFSET, this.SIZE - usedDraw + this.VOFFSET, this.BAR_WITH, usedDraw);
    }

    public void drawLeds(Graphics g, double used, double totalAlloc, double totalSpace) {
        int usedDraw = this.SIZE - (int)(used / totalSpace * 30.0);
        int allocDraw = this.SIZE - (int)(totalAlloc / totalSpace * 30.0);
        if (this.isEnabled()) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(Color.LIGHT_GRAY);
        }
        g.setFont(new Font("SansSerif", 0, 10));
        g.drawString(this.label, this.HOFFSET + this.BAR_WITH + 1, this.VOFFSET + (int)((double)this.SIZE / 2.5));
        g.drawString("Info", this.HOFFSET + this.BAR_WITH + 1, this.VOFFSET + (int)((double)this.SIZE / 1.2));
        if (this.isEnabled()) {
            g.setColor(FREE);
        } else {
            g.setColor(FREE_DISABLED);
        }
        int i = 0;
        while (i <= this.SIZE) {
            if (this.VOFFSET + i >= allocDraw) {
                if (this.isEnabled()) {
                    g.setColor(ALLOC);
                } else {
                    g.setColor(ALLOC_DISABLED);
                }
            }
            if (this.VOFFSET + i >= usedDraw) {
                if (this.isEnabled()) {
                    g.setColor(USED);
                } else {
                    g.setColor(USED_DISABLED);
                }
            }
            g.fillRect(this.HOFFSET, this.VOFFSET + i, this.BAR_WITH, 2);
            i += 3;
        }
    }

    public void addDiscSpaceListener(SpaceListener dsl) {
        this.listeners.add(dsl);
    }

    public void removeDiscSpaceListener(SpaceListener dsl) {
        this.listeners.remove(dsl);
    }
}

