/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui;

import ij.ImagePlus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import lu.tudor.santec.dicom.DicomOpener;
import lu.tudor.santec.dicom.OverlayExtractor;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.DicomHeaderInfoDialog;
import lu.tudor.santec.i18n.Translatrix;

public class ImagePreviewDicom
extends JPanel
implements PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    ImageIcon thumbnail = null;
    File file = null;
    private JLabel iconLabel = new JLabel();
    private JLabel textLabel = new JLabel();
    private JButton showDicomInfo = new JButton();
    private DicomHeaderInfoDialog infoDialog;
    private ImagePlus image;
    private String[] dicomFields;
    private DicomHeader dh;
    private JScrollPane textScrollPanel;
    private JPanel content;
    private JCheckBox showPreviewCheckBox;
    public static boolean showPreview = true;
    private static Vector listeners = new Vector();

    public ImagePreviewDicom(JComponent fc, JDialog parent, String[] dicomFields) {
        this.infoDialog = new DicomHeaderInfoDialog(parent);
        this.dicomFields = dicomFields;
        fc.addPropertyChangeListener(this);
        this.setLayout(new BorderLayout());
        this.textLabel.setVerticalAlignment(1);
        this.iconLabel.setBorder(new TitledBorder(Translatrix.getTranslationString((String)"dicom.Preview")));
        this.textScrollPanel = new JScrollPane(this.textLabel);
        this.textScrollPanel.setPreferredSize(new Dimension(220, 230));
        this.textScrollPanel.setBorder(new TitledBorder(Translatrix.getTranslationString((String)"dicom.Informations")));
        this.iconLabel.setPreferredSize(new Dimension(220, 230));
        this.iconLabel.setMaximumSize(new Dimension(220, 230));
        this.iconLabel.setMinimumSize(new Dimension(220, 230));
        this.iconLabel.setVerticalAlignment(0);
        this.iconLabel.setHorizontalAlignment(0);
        this.showDicomInfo.setText(Translatrix.getTranslationString((String)"dicom.ShowInfo"));
        this.showDicomInfo.addActionListener(this);
        this.showDicomInfo.setEnabled(false);
        this.showPreviewCheckBox = new JCheckBox(Translatrix.getTranslationString((String)"dicom.showPreview"), showPreview);
        this.showPreviewCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                showPreview = ImagePreviewDicom.this.showPreviewCheckBox.isSelected();
                for (ImagePreviewDicom element : listeners) {
                    element.firePropertyChange("showPreview", null, null);
                }
            }
        });
        this.add((Component)this.showPreviewCheckBox, "North");
        this.buildContentPanel(showPreview);
        this.add((Component)this.showDicomInfo, "South");
        this.addPropertyChangeListener(this);
        listeners.add(this);
    }

    private void buildContentPanel(boolean showPreview) {
        try {
            this.remove(this.content);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.content = new JPanel(new BorderLayout());
        if (showPreview) {
            this.content.add((Component)this.iconLabel, "North");
        }
        this.content.add((Component)this.textScrollPanel, "Center");
        this.add((Component)this.content, "Center");
        this.updateUI();
        this.validate();
    }

    public void loadImage(File file) {
        System.gc();
        if (file == null || file.isDirectory()) {
            this.thumbnail = null;
            this.iconLabel.setIcon(null);
            this.iconLabel.setText("no Preview available");
            this.textLabel.setText(Translatrix.getTranslationString((String)"dicom.noDICOMImage"));
            this.showDicomInfo.setEnabled(false);
            return;
        }
        try {
            this.dh = new DicomHeader(file);
            String info = "";
            if (this.dh != null) {
                int i = 0;
                while (i < this.dicomFields.length) {
                    info = String.valueOf(info) + this.getDicomHeader(this.dicomFields[i]);
                    ++i;
                }
                info = String.valueOf(info) + "File Size: <font color='#787878'>" + file.length() / 1024L + "</font><br>";
                this.showDicomInfo.setEnabled(true);
            } else {
                info = String.valueOf(info) + "no DICOM Image";
                this.showDicomInfo.setEnabled(false);
            }
            this.textLabel.setText("<html><body>" + info);
            if (showPreview) {
                this.image = DicomOpener.loadImage(file, this.dh, null);
                if (OverlayExtractor.hasOverlayImage(this.dh.getDicomObject())) {
                    this.image = OverlayExtractor.createOverlayImage(this.image, this.dh.getDicomObject());
                }
                if (this.image != null) {
                    int imageHeight;
                    int thumbWidth = 200;
                    int thumbHeight = 200;
                    double thumbRatio = (double)thumbWidth / (double)thumbHeight;
                    Image awtImage = this.image.getImage();
                    int imageWidth = awtImage.getWidth(null);
                    double imageRatio = (double)imageWidth / (double)(imageHeight = awtImage.getHeight(null));
                    if (thumbRatio < imageRatio) {
                        thumbHeight = (int)((double)thumbWidth / imageRatio);
                    } else {
                        thumbWidth = (int)((double)thumbHeight * imageRatio);
                    }
                    BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
                    Graphics2D graphics2D = thumbImage.createGraphics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    graphics2D.drawImage(awtImage, 0, 0, thumbWidth, thumbHeight, null);
                    this.thumbnail = new ImageIcon(thumbImage);
                    this.iconLabel.setIcon(this.thumbnail);
                    this.iconLabel.setText("");
                    awtImage = null;
                    this.image = null;
                } else {
                    this.iconLabel.setIcon(null);
                    this.iconLabel.setText("no Preview available");
                }
            } else {
                this.image = null;
                this.iconLabel.setIcon(null);
                this.iconLabel.setText("Preview disabled");
            }
        }
        catch (Exception e) {
            this.textLabel.setText(Translatrix.getTranslationString((String)"dicom.noDICOMImage"));
            this.iconLabel.setIcon(null);
            this.iconLabel.setText("");
            this.showDicomInfo.setEnabled(false);
        }
        catch (Error e1) {
            this.textLabel.setText(Translatrix.getTranslationString((String)"dicom.noDICOMImage"));
            this.iconLabel.setIcon(null);
            this.iconLabel.setText("");
            this.showDicomInfo.setEnabled(false);
        }
        System.gc();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if (prop.equals("showPreview")) {
            this.showPreviewCheckBox.setSelected(showPreview);
            this.buildContentPanel(showPreview);
        }
        if (showPreview) {
            update = true;
        }
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.loadImage(this.file);
            }
        }
    }

    private String getDicomHeader(String dicomTag) {
        String attrvalue = "";
        if (this.dh != null) {
            try {
                int size;
                String name = DicomHeader.getHeaderName(dicomTag);
                String value = this.dh.getHeaderStringValue(dicomTag);
                if (dicomTag.equals("0008,0021")) {
                    value = String.valueOf(value.substring(6, 8)) + "." + value.substring(4, 6) + "." + value.substring(0, 4);
                } else if (dicomTag.equals("0008,0031")) {
                    value = String.valueOf(value.substring(0, 2)) + ":" + value.substring(2, 4) + ":" + value.substring(4, 6);
                }
                if (value == null || value.equals("")) {
                    value = Translatrix.getTranslationString((String)"dicom.notavailable");
                }
                if ((size = (String.valueOf(name) + value).length()) > 30) {
                    value = "<br>&nbsp;" + value;
                }
                if (name == null || name.equals("")) {
                    name = dicomTag;
                }
                attrvalue = name + ": <font color='#787878'>" + value + "</font><br>";
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return attrvalue;
    }

    public static String formatDicomInfo(String header) {
        return header.replaceAll("\n", "\r\n").replaceAll("\u0000", " ");
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.infoDialog.setInfo(this.dh);
        this.infoDialog.setVisible(true);
    }
}

