/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.dicomdir;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lu.tudor.santec.dicom.gui.DicomFilter;
import lu.tudor.santec.dicom.gui.DicomURLChooser;
import lu.tudor.santec.dicom.gui.ErrorDialog;
import lu.tudor.santec.dicom.gui.ImagePreviewDicom;
import lu.tudor.santec.dicom.gui.TableSorter;
import lu.tudor.santec.dicom.gui.dicomdir.DICOMDIRVIEW;
import lu.tudor.santec.dicom.gui.dicomdir.DicomTableModel;
import lu.tudor.santec.dicom.gui.dicomdir.PatientTableModel;
import lu.tudor.santec.dicom.gui.dicomdir.PictureTableModel;
import lu.tudor.santec.dicom.gui.dicomdir.SeriesTableModel;
import lu.tudor.santec.dicom.gui.dicomdir.StudyTableModel;
import lu.tudor.santec.dicom.gui.filechooser.FILEChooserDicom;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.dicom.gui.utils.DateRenderer;
import lu.tudor.santec.dicom.gui.utils.TimeRenderer;
import lu.tudor.santec.dicom.receiver.DicomDirReader;
import lu.tudor.santec.dicom.sender.DicomSender;
import lu.tudor.santec.i18n.Translatrix;
import org.apache.log4j.Logger;
import org.dcm4che.util.DcmURL;
import org.dcm4che2.data.DicomObject;

public class DICOMDIRSearchPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
MouseListener,
DicomFilter,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final int IMAGE = 0;
    private static final int SERIES = 2;
    private static final int ALL = 3;
    public DicomDirReader ddr;
    private DICOMDIRVIEW parent;
    private JTable patientTable;
    private JTable studyTable;
    private JTable seriesTable;
    private JTable pictureTable;
    private PatientTableModel patientTableModel;
    private StudyTableModel studyTableModel;
    private SeriesTableModel seriesTableModel;
    private PictureTableModel pictureTableModel;
    private ImagePreviewDicom dicomImagePreview;
    private JButton openImageButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton deleteButton = new JButton();
    private JButton sendButton = new JButton();
    private JButton openSeriesButton = new JButton();
    private JButton openAllButton = new JButton();
    private File inFile;
    private ProgressMonitor progressMonitor;
    private boolean create;
    private boolean canSend = false;
    private ButtonBarBuilder bbuilder;
    private TableSorter patientTableSorter;
    private TableSorter studyTableSorter;
    private TableSorter seriesTableSorter;
    private TableSorter pictureTableSorter;
    private DcmURL[] senders;
    private DicomSender dicomSender;
    private Vector filterTags;
    private JLabel filterLabel;
    private ArrayList<File> sendFiles;
    private MouseEvent event;
    private JPopupMenu popup;
    private boolean delete;
    private boolean canDelete;
    private TitledBorder patientTableBorder;
    private TitledBorder studyTableBorder;
    private TitledBorder seriesTableBorder;
    private TitledBorder pictureTableBorder;
    private static Logger logger = Logger.getLogger((String)"lu.tudor.santec.dicom.gui.DicomDirSearchPanel");

    public DICOMDIRSearchPanel(File inFile, DICOMDIRVIEW parent, boolean open, boolean delete, boolean send, boolean create, String[] dicomFields) {
        this.parent = parent;
        this.create = create;
        this.canSend = send;
        this.delete = delete;
        this.addPropertyChangeListener(this);
        CellConstraints cc = new CellConstraints();
        FormLayout fl = new FormLayout("6dlu, 100dlu:grow, 4dlu, 100dlu:grow, 4dlu, pref, 6dlu", "6dlu, pref, 3dlu, fill:80dlu:grow, 4dlu, 80dlu, 4dlu, pref, 6dlu");
        this.setLayout((LayoutManager)fl);
        this.ddr = new DicomDirReader();
        Color bgColor = new JTextField().getBackground();
        this.filterLabel = new JLabel();
        this.filterLabel.setOpaque(true);
        this.add((Component)this.filterLabel, cc.xyw(2, 2, 5));
        this.patientTableModel = new PatientTableModel();
        this.patientTableSorter = new TableSorter(this.patientTableModel);
        this.patientTable = new JTable(this.patientTableSorter){
            private static final long serialVersionUID = 1L;

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                if (row == -1 || column == -1) {
                    return;
                }
                if (this.getSelectedRow() == row) {
                    toggle = true;
                }
                super.changeSelection(row, column, toggle, extend);
            }
        };
        this.patientTableSorter.setTableHeader(this.patientTable.getTableHeader());
        this.patientTable.setRowSelectionAllowed(true);
        this.patientTable.setColumnSelectionAllowed(false);
        this.patientTable.addMouseListener(this);
        this.setTableFocusKey(this.patientTable);
        this.patientTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane jsp0 = new JScrollPane(this.patientTable);
        jsp0.setFocusCycleRoot(false);
        this.patientTableBorder = new TitledBorder(String.valueOf(Translatrix.getTranslationString((String)"dicom.Patients")) + ":");
        jsp0.setBorder(this.patientTableBorder);
        jsp0.getViewport().setBackground(bgColor);
        this.add((Component)jsp0, cc.xyw(2, 4, 1));
        this.patientTable.requestFocus();
        this.studyTableModel = new StudyTableModel();
        this.studyTableSorter = new TableSorter(this.studyTableModel);
        this.studyTable = new JTable(this.studyTableSorter){
            private static final long serialVersionUID = 1L;

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                if (row == -1 || column == -1) {
                    return;
                }
                if (this.getSelectedRow() == row) {
                    toggle = true;
                }
                super.changeSelection(row, column, toggle, extend);
            }
        };
        this.studyTableSorter.setTableHeader(this.studyTable.getTableHeader());
        this.studyTable.setRowSelectionAllowed(true);
        this.studyTable.setColumnSelectionAllowed(false);
        this.studyTable.addMouseListener(this);
        this.studyTable.getColumnModel().getColumn(1).setCellRenderer(new DateRenderer());
        this.studyTable.getColumnModel().getColumn(2).setCellRenderer(new TimeRenderer());
        this.setTableFocusKey(this.studyTable);
        this.studyTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane jsp1 = new JScrollPane(this.studyTable);
        jsp1.setFocusCycleRoot(false);
        this.studyTableBorder = new TitledBorder(String.valueOf(Translatrix.getTranslationString((String)"dicom.Studies")) + ":");
        jsp1.setBorder(this.studyTableBorder);
        jsp1.getViewport().setBackground(bgColor);
        this.add((Component)jsp1, cc.xyw(4, 4, 1));
        this.seriesTableModel = new SeriesTableModel();
        this.seriesTableSorter = new TableSorter(this.seriesTableModel);
        this.seriesTable = new JTable(this.seriesTableSorter){
            private static final long serialVersionUID = 1L;

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                if (row == -1 || column == -1) {
                    return;
                }
                if (this.getSelectedRow() == row) {
                    toggle = true;
                }
                super.changeSelection(row, column, toggle, extend);
            }
        };
        this.seriesTableSorter.setTableHeader(this.seriesTable.getTableHeader());
        this.seriesTable.getColumnModel().getColumn(0).setMaxWidth(60);
        this.seriesTable.getColumnModel().getColumn(2).setMaxWidth(50);
        this.seriesTable.setRowSelectionAllowed(true);
        this.seriesTable.setColumnSelectionAllowed(false);
        this.seriesTable.addMouseListener(this);
        this.setTableFocusKey(this.seriesTable);
        this.seriesTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane jsp2 = new JScrollPane(this.seriesTable);
        this.seriesTableBorder = new TitledBorder(String.valueOf(Translatrix.getTranslationString((String)"dicom.Series")) + ":");
        jsp2.setBorder(this.seriesTableBorder);
        jsp2.getViewport().setBackground(bgColor);
        this.add((Component)jsp2, cc.xy(2, 6));
        this.pictureTableModel = new PictureTableModel();
        this.pictureTableSorter = new TableSorter(this.pictureTableModel);
        this.pictureTable = new JTable(this.pictureTableSorter){
            private static final long serialVersionUID = 1L;

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                if (row == -1 || column == -1) {
                    return;
                }
                if (this.getSelectedRow() == row) {
                    toggle = true;
                }
                super.changeSelection(row, column, toggle, extend);
            }
        };
        this.pictureTableSorter.setTableHeader(this.pictureTable.getTableHeader());
        this.pictureTable.setRowSelectionAllowed(true);
        this.pictureTable.setColumnSelectionAllowed(false);
        this.pictureTable.addMouseListener(this);
        this.pictureTable.getColumnModel().getColumn(0).setMaxWidth(55);
        this.setTableFocusKey(this.pictureTable);
        this.pictureTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane jsp3 = new JScrollPane(this.pictureTable);
        this.pictureTableBorder = new TitledBorder(String.valueOf(Translatrix.getTranslationString((String)"dicom.Pictures")) + ":");
        jsp3.setBorder(this.pictureTableBorder);
        jsp3.getViewport().setBackground(bgColor);
        this.add((Component)jsp3, cc.xy(4, 6));
        this.dicomImagePreview = new ImagePreviewDicom(this.pictureTable, parent.getParentDialog().getCurrentDialog(), dicomFields);
        this.add((Component)this.dicomImagePreview, cc.xywh(6, 4, 1, 3));
        this.bbuilder = new ButtonBarBuilder();
        if (this.delete) {
            this.deleteButton = new JButton(Translatrix.getTranslationString((String)"dicom.Delete"));
            this.deleteButton.setEnabled(false);
            this.deleteButton.addActionListener(this);
            this.bbuilder.addFixed((JComponent)this.deleteButton);
            this.bbuilder.addRelatedGap();
        }
        if (send) {
            this.sendButton = new JButton(Translatrix.getTranslationString((String)"dicom.Send"));
            this.sendButton.setEnabled(false);
            this.sendButton.addActionListener(this);
            this.bbuilder.addFixed((JComponent)this.sendButton);
        }
        this.bbuilder.addGlue();
        if (open) {
            this.bbuilder.addRelatedGap();
            this.openImageButton = new JButton(Translatrix.getTranslationString((String)"dicom.OpenImage"));
            this.openImageButton.setEnabled(false);
            this.openImageButton.addActionListener(this);
            this.bbuilder.addGridded((JComponent)this.openImageButton);
        }
        if (open) {
            this.bbuilder.addRelatedGap();
            this.openSeriesButton = new JButton(Translatrix.getTranslationString((String)"dicom.OpenSeries"));
            this.openSeriesButton.setEnabled(false);
            this.openSeriesButton.addActionListener(this);
            this.bbuilder.addGridded((JComponent)this.openSeriesButton);
        }
        if (open && !create) {
            this.bbuilder.addRelatedGap();
            this.openAllButton = new JButton(Translatrix.getTranslationString((String)"dicom.OpenAll"));
            this.openAllButton.addActionListener(this);
            this.bbuilder.addGridded((JComponent)this.openAllButton);
        }
        this.bbuilder.addRelatedGap();
        this.cancelButton = new JButton(Translatrix.getTranslationString((String)"dicom.Cancel"));
        this.cancelButton.addActionListener(this);
        this.bbuilder.addFixed((JComponent)this.cancelButton);
        this.add((Component)this.bbuilder.getPanel(), cc.xyw(2, 8, 5));
        this.setPath(inFile);
    }

    public void reload(File inFile) {
        this.parent.getParentDialog().setWaitCursor(true);
        try {
            this.inFile = inFile;
            this.canDelete = this.delete;
            if (!inFile.canWrite()) {
                this.canDelete = false;
            }
            this.ddr.loadDicomDirFile(inFile, this.create, this.canDelete);
            this.updateView();
        }
        catch (Throwable e1) {
            logger.warn((Object)"error updating dicom view");
            e1.printStackTrace();
            this.parent.getParentDialog().setWaitCursor(false);
        }
        if (this.canSend) {
            this.sendButton.setEnabled(false);
        }
        this.deleteButton.setEnabled(false);
        this.openImageButton.setEnabled(false);
        this.openSeriesButton.setEnabled(false);
        this.parent.getParentDialog().setWaitCursor(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.parent.getParentDialog().pacsPanel != null) {
            this.parent.getParentDialog().pacsPanel.setServerStatus(3);
        }
        if (e.getSource().equals(this.cancelButton)) {
            this.cancel();
        } else if (e.getSource().equals(this.openImageButton)) {
            this.open(0);
        } else if (e.getSource().equals(this.openSeriesButton)) {
            this.open(2);
        } else if (e.getSource().equals(this.openAllButton)) {
            this.open(3);
        } else if (e.getSource().equals(this.deleteButton)) {
            this.delete(null);
        } else if (e.getSource().equals(this.sendButton)) {
            this.send();
        }
    }

    public void setPath(File f) {
        this.reload(f);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.parent.getParentDialog().pacsPanel != null) {
            this.parent.getParentDialog().pacsPanel.setServerStatus(3);
        }
        this.parent.getParentDialog().setWaitCursor(true);
        if (e.getSource().equals(this.patientTable.getSelectionModel())) {
            this.selectPatient();
        } else if (e.getSource().equals(this.studyTable.getSelectionModel())) {
            this.selectStudy();
        } else if (e.getSource().equals(this.seriesTable.getSelectionModel())) {
            this.selectSeries();
        } else if (e.getSource().equals(this.pictureTable.getSelectionModel())) {
            this.selectImages();
        }
        this.parent.getParentDialog().setWaitCursor(false);
    }

    private void setTableFocusKey(JTable table) {
        Set<AWTKeyStroke> keys = table.getFocusTraversalKeys(0);
        keys = new HashSet<AWTKeyStroke>(keys);
        keys.add(KeyStroke.getKeyStroke("TAB"));
        table.setFocusTraversalKeys(0, keys);
        keys = table.getFocusTraversalKeys(1);
        keys = new HashSet<AWTKeyStroke>(keys);
        keys.add(KeyStroke.getKeyStroke("shift TAB"));
        table.setFocusTraversalKeys(1, keys);
    }

    public void open(int openType) {
        this.parent.getParentDialog().setWaitCursor(true);
        try {
            if (openType == 0 && this.pictureTable.getSelectedRowCount() > 0) {
                if (this.pictureTable.getSelectedRowCount() == 1) {
                    this.parent.getParentDialog().setSingleFileSelected(true);
                    this.parent.getParentDialog().setSelectedFile(this.ddr.getImagePathFromImage(this.pictureTableModel.getRecord(this.pictureTable.getSelectedRow())));
                    this.parent.getParentDialog().setSelectedFiles(this.filesForRowsFromModel(this.seriesTable.getSelectedRows(), this.seriesTableModel));
                } else {
                    this.parent.getParentDialog().setSingleFileSelected(false);
                    this.parent.getParentDialog().setSelectedFile(null);
                    this.parent.getParentDialog().setSelectedFiles(this.filesForRowsFromModel(this.pictureTable.getSelectedRows(), this.pictureTableModel));
                }
            } else if (openType == 2 && this.seriesTable.getSelectedRowCount() > 0) {
                this.parent.getParentDialog().setSingleFileSelected(false);
                this.parent.getParentDialog().setSelectedFile(null);
                this.parent.getParentDialog().setSelectedFiles(this.filesForRowsFromModel(this.seriesTable.getSelectedRows(), this.seriesTableModel));
            } else if (openType == 3) {
                this.parent.getParentDialog().setSingleFileSelected(false);
                this.parent.getParentDialog().setSelectedFile(null);
                File dir = this.inFile;
                if (!dir.isDirectory()) {
                    dir = dir.getParentFile();
                }
                Object[] files = FILEChooserDicom.getFilesRecursive(dir);
                Arrays.sort(files);
                this.parent.getParentDialog().setSelectedFiles((File[])files);
            } else {
                throw new RuntimeException();
            }
            this.parent.getParentDialog().setRetValue(0);
            this.parent.getParentDialog().setVisible(false);
        }
        catch (Exception ee) {
            this.parent.getParentDialog().setSelectedFiles(null);
            this.parent.getParentDialog().setSelectedFile(null);
            this.parent.getParentDialog().setRetValue(1);
            this.parent.getParentDialog().setVisible(false);
        }
        this.parent.getParentDialog().setWaitCursor(false);
    }

    private File[] filesForRowsFromModel(int[] rows, PictureTableModel pictureTableModel) throws Exception {
        File[] files = new File[rows.length];
        int i = 0;
        while (i < rows.length) {
            File file;
            int row = rows[i];
            files[i] = file = this.ddr.getImagePathFromImage(pictureTableModel.getRecord(row));
            ++i;
        }
        return files;
    }

    private File[] filesForRowsFromModel(int[] rows, SeriesTableModel seriesTableModel) throws Exception {
        ArrayList<File> result = new ArrayList<File>();
        int i = 0;
        while (i < rows.length) {
            int row = rows[i];
            File[] files = this.ddr.getImagePathsFromSeries(seriesTableModel.getRecord(row));
            result.addAll(Arrays.asList(files));
            ++i;
        }
        return result.toArray(new File[result.size()]);
    }

    public void send() {
        DcmURL url = DicomURLChooser.showDialog(this.parent.getParentDialog().getCurrentDialog(), this.senders);
        if (url == null) {
            return;
        }
        this.dicomSender = new DicomSender(url);
        this.sendFiles = new ArrayList();
        if (this.pictureTable.getSelectedRow() != -1) {
            try {
                int[] rows = this.pictureTable.getSelectedRows();
                int i = 0;
                while (i < rows.length) {
                    File f = this.ddr.getImagePathFromImage(this.pictureTableModel.getRecord(this.pictureTableSorter.modelIndex(rows[i])));
                    logger.warn((Object)("sending image: " + f));
                    this.sendFiles.add(f);
                    ++i;
                }
            }
            catch (Exception e) {
                logger.warn((Object)"no image found");
                ErrorDialog.showErrorDialog(this.parent.getParentDialog().getCurrentDialog(), "Send Error", "no image found", (Throwable)e);
                this.parent.getParentDialog().setWaitCursor(false);
            }
        } else if (this.seriesTable.getSelectedRow() != -1) {
            int[] rows = this.seriesTable.getSelectedRows();
            int i = 0;
            while (i < rows.length) {
                File[] fArr = this.ddr.getImagePathsFromSeries(this.seriesTableModel.getRecord(this.seriesTableSorter.modelIndex(rows[i])));
                logger.warn((Object)("sending series with " + fArr.length + " images"));
                this.sendFiles.addAll(Arrays.asList(fArr));
                ++i;
            }
        } else if (this.studyTable.getSelectedRow() != -1) {
            int[] rows = this.studyTable.getSelectedRows();
            int i = 0;
            while (i < rows.length) {
                Vector<DicomObject> series = this.ddr.getSeriesFromStudy(this.studyTableModel.getRecord(this.studyTableSorter.modelIndex(rows[i])));
                for (DicomObject serie : series) {
                    this.sendFiles.addAll(Arrays.asList(this.ddr.getImagePathsFromSeries(serie)));
                }
                logger.warn((Object)("sending studies with " + this.sendFiles.size() + " images"));
                ++i;
            }
        } else if (this.patientTable.getSelectedRow() != -1) {
            int[] rows = this.patientTable.getSelectedRows();
            int i = 0;
            while (i < rows.length) {
                Vector<DicomObject> studies = this.ddr.getStudiesFromPatients(this.patientTableModel.getRecord(this.patientTableSorter.modelIndex(rows[i])));
                for (DicomObject study : studies) {
                    Vector<DicomObject> series = this.ddr.getSeriesFromStudy(study);
                    for (DicomObject serie : series) {
                        this.sendFiles.addAll(Arrays.asList(this.ddr.getImagePathsFromSeries(serie)));
                    }
                }
                ++i;
            }
            logger.warn((Object)("sending patient with " + this.sendFiles.size() + " images"));
        }
        if (this.sendFiles.size() == 0) {
            return;
        }
        this.progressMonitor = new ProgressMonitor(this, String.valueOf(Translatrix.getTranslationString((String)"dicom.SendingFilesTo")) + " \r\n" + this.dicomSender.getUrl(), "", 0, this.sendFiles.size());
        new Thread(){

            @Override
            public void run() {
                DICOMDIRSearchPanel.this.parent.getParentDialog().setWaitCursor(true);
                try {
                    int i = 0;
                    while (i < DICOMDIRSearchPanel.this.sendFiles.size()) {
                        File element = (File)DICOMDIRSearchPanel.this.sendFiles.get(i);
                        if (!DICOMDIRSearchPanel.this.progressMonitor.isCanceled()) {
                            DICOMDIRSearchPanel.this.progressMonitor.setNote("img " + element.getName() + " ( " + (i + 1) + " of " + (DICOMDIRSearchPanel.this.sendFiles.size() + 1) + " )");
                            DICOMDIRSearchPanel.this.progressMonitor.setProgress(i);
                            DICOMDIRSearchPanel.this.dicomSender.send(element);
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (UnknownHostException e1) {
                    ErrorDialog.showErrorDialog(DICOMDIRSearchPanel.this.parent.getParentDialog().getCurrentDialog(), "Send Error", "Dicom Reciever at Host: " + e1.getLocalizedMessage() + " does not exist!", (Throwable)e1);
                    DICOMDIRSearchPanel.this.parent.getParentDialog().setWaitCursor(false);
                }
                catch (Exception e1) {
                    ErrorDialog.showErrorDialog(DICOMDIRSearchPanel.this.parent.getParentDialog().getCurrentDialog(), "Send Error", String.valueOf(e1.getClass().getName()) + " " + e1.getLocalizedMessage(), (Throwable)e1);
                    DICOMDIRSearchPanel.this.parent.getParentDialog().setWaitCursor(false);
                }
                DICOMDIRSearchPanel.this.progressMonitor.close();
                DICOMDIRSearchPanel.this.parent.getParentDialog().setWaitCursor(false);
            }
        }.start();
    }

    public void delete(JTable table) {
        int patient = -2;
        int picture = -2;
        int series = -2;
        int study = -2;
        if (table == null) {
            if (this.pictureTable.getSelectedRow() != -1) {
                picture = this.pictureTable.getSelectedRow() - 1;
                series = this.seriesTable.getSelectedRow();
                study = this.studyTable.getSelectedRow();
                int[] rows = this.pictureTable.getSelectedRows();
                int i = 0;
                while (i < rows.length) {
                    this.ddr.deleteRecord(this.pictureTableModel.getRecord(rows[i]));
                    ++i;
                }
            } else if (this.seriesTable.getSelectedRow() != -1) {
                series = this.seriesTable.getSelectedRow() - 1;
                study = this.studyTable.getSelectedRow();
                int[] rows = this.seriesTable.getSelectedRows();
                int i = 0;
                while (i < rows.length) {
                    this.ddr.deleteRecord(this.seriesTableModel.getRecord(rows[i]));
                    ++i;
                }
            } else if (this.studyTable.getSelectedRow() != -1) {
                study = this.studyTable.getSelectedRow() - 1;
                int[] rows = this.studyTable.getSelectedRows();
                int i = 0;
                while (i < rows.length) {
                    this.ddr.deleteRecord(this.studyTableModel.getRecord(rows[i]));
                    ++i;
                }
            } else if (this.patientTable.getSelectedRow() != -1) {
                study = this.patientTable.getSelectedRow() - 1;
                int[] rows = this.patientTable.getSelectedRows();
                int i = 0;
                while (i < rows.length) {
                    this.ddr.deleteRecord(this.patientTableModel.getRecord(rows[i]));
                    ++i;
                }
            }
        } else {
            DicomTableModel model = (DicomTableModel)((Object)((TableSorter)table.getModel()).getTableModel());
            int[] rows = table.getSelectedRows();
            int i = 0;
            while (i < rows.length) {
                this.ddr.deleteRecord(model.getRecord(rows[i]));
                ++i;
            }
        }
        this.parent.setPath(this.inFile);
        if (patient == -1) {
            patient = 0;
        }
        if (series == -1) {
            series = 0;
        }
        if (study == -1) {
            study = 0;
        }
        if (picture == -1) {
            picture = 0;
        }
        this.selectEntry(patient, study, series, picture);
        this.parent.getParentDialog().setWaitCursor(false);
    }

    public void selectEntry(int patient, int study, int series, int picture) {
        try {
            this.patientTable.setRowSelectionInterval(patient, patient);
            this.studyTable.setRowSelectionInterval(study, study);
            this.seriesTable.setRowSelectionInterval(series, series);
            this.pictureTable.setRowSelectionInterval(picture, picture);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cancel() {
        this.parent.getParentDialog().setRetValue(1);
        this.parent.getParentDialog().setVisible(false);
        this.parent.getParentDialog().setWaitCursor(false);
    }

    public void enableSend(boolean enable) {
        this.sendButton.setEnabled(enable);
        this.canSend = enable;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() && this.canDelete) {
            this.showMenu(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() && this.canDelete) {
            this.showMenu(e);
        }
    }

    private void showMenu(MouseEvent e) {
        JTable table;
        int row;
        this.event = e;
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.popup.add(new AbstractAction(Translatrix.getTranslationString((String)"dicom.Delete")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int row;
                    JTable table = (JTable)DICOMDIRSearchPanel.this.event.getSource();
                    if (!table.isRowSelected(row = table.rowAtPoint(DICOMDIRSearchPanel.this.event.getPoint()))) {
                        table.setRowSelectionInterval(row, row);
                    }
                    try {
                        DICOMDIRSearchPanel.this.delete(table);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        if ((row = (table = (JTable)this.event.getSource()).rowAtPoint(this.event.getPoint())) < 0) {
            return;
        }
        if (!table.isRowSelected(row)) {
            table.setRowSelectionInterval(row, row);
        }
        this.popup.show(e.getComponent(), e.getX(), e.getY());
    }

    private void selectPatient() {
        try {
            if (this.canSend) {
                this.sendButton.setEnabled(true);
            }
            this.deleteButton.setEnabled(this.canDelete);
            this.openImageButton.setEnabled(false);
            this.openSeriesButton.setEnabled(false);
            int row = this.patientTable.getSelectedRow();
            if (row >= 0) {
                this.studyTableModel.setStudies(this.ddr.getStudiesFromPatients(this.patientTableModel.getRecord(this.patientTableSorter.modelIndex(row))));
                this.studyTableBorder.setTitle(String.valueOf(Translatrix.getTranslationString((String)"dicom.Studies")) + ": [" + this.studyTableModel.getRowCount() + "]");
                try {
                    this.studyTable.setRowSelectionInterval(0, 0);
                }
                catch (Exception exception) {}
            } else {
                this.studyTableModel.setStudies(new Vector<DicomObject>());
                this.studyTableBorder.setTitle(Translatrix.getTranslationString((String)"dicom.Studies"));
                this.studyTable.clearSelection();
                if (this.canSend) {
                    this.sendButton.setEnabled(false);
                }
                this.deleteButton.setEnabled(false);
                this.openImageButton.setEnabled(false);
                this.openSeriesButton.setEnabled(false);
            }
        }
        catch (Exception e1) {
            logger.debug((Object)"error updating dicom view");
            this.parent.getParentDialog().setWaitCursor(false);
        }
    }

    private void selectStudy() {
        try {
            if (this.canSend) {
                this.sendButton.setEnabled(true);
            }
            this.deleteButton.setEnabled(this.canDelete);
            this.openImageButton.setEnabled(false);
            this.openSeriesButton.setEnabled(false);
            int row = this.studyTable.getSelectedRow();
            if (row >= 0) {
                Vector<DicomObject> series = this.ddr.getSeriesFromStudy(this.studyTableModel.getRecord(this.studyTableSorter.modelIndex(row)));
                if (this.filterTags != null) {
                    for (HeaderTag ht : this.filterTags) {
                        if (!"0008,0060".equals(ht.tagNr)) continue;
                        Vector<DicomObject> removedSeries = new Vector<DicomObject>();
                        for (DicomObject dr : series) {
                            if (dr.getString(524384).equals(ht.tagValue)) continue;
                            removedSeries.add(dr);
                        }
                        series.removeAll(removedSeries);
                    }
                }
                this.seriesTableModel.setSeries(series);
                this.seriesTableBorder.setTitle(String.valueOf(Translatrix.getTranslationString((String)"dicom.Series")) + ": [" + this.seriesTableModel.getRowCount() + "]");
                try {
                    this.seriesTable.setRowSelectionInterval(0, 0);
                }
                catch (Exception exception) {}
            } else {
                this.seriesTableModel.setSeries(new Vector<DicomObject>());
                this.seriesTableBorder.setTitle(Translatrix.getTranslationString((String)"dicom.Series"));
                this.seriesTable.clearSelection();
            }
        }
        catch (Exception e1) {
            logger.info((Object)"error updating dicom view");
            this.parent.getParentDialog().setWaitCursor(false);
        }
    }

    private void selectSeries() {
        try {
            int row = this.seriesTable.getSelectedRow();
            boolean hasSelection = row >= 0;
            this.openImageButton.setEnabled(hasSelection);
            this.openSeriesButton.setEnabled(hasSelection);
            if (row >= 0) {
                this.pictureTableModel.setPictures(this.ddr.getImagesFromSeries(this.seriesTableModel.getRecord(this.seriesTableSorter.modelIndex(row))));
                this.dicomImagePreview.loadImage(null);
                this.pictureTableBorder.setTitle(String.valueOf(Translatrix.getTranslationString((String)"dicom.Pictures")) + ": [" + this.pictureTableModel.getRowCount() + "]");
                try {
                    this.pictureTable.setRowSelectionInterval(0, 0);
                }
                catch (Exception exception) {}
            } else {
                this.pictureTableModel.setPictures(new Vector<DicomObject>());
                this.pictureTableBorder.setTitle(Translatrix.getTranslationString((String)"dicom.Pictures"));
                this.pictureTable.clearSelection();
            }
        }
        catch (Exception e1) {
            logger.info((Object)"error updating dicom view");
            this.parent.getParentDialog().setWaitCursor(false);
        }
    }

    private void selectImages() {
        try {
            int row = this.pictureTable.getSelectedRow();
            boolean hasSelection = row >= 0 || this.seriesTable.getSelectedRow() >= 0;
            this.openImageButton.setEnabled(hasSelection);
            if (row >= 0) {
                File img = this.ddr.getImagePathFromImage(this.pictureTableModel.getRecord(this.pictureTableSorter.modelIndex(row)));
                this.dicomImagePreview.loadImage(img);
            } else {
                this.dicomImagePreview.loadImage(null);
            }
        }
        catch (Exception e1) {
            logger.info((Object)"no image found");
            this.parent.getParentDialog().setWaitCursor(false);
        }
    }

    public void setDicomSenders(DcmURL[] senders) {
        this.senders = senders;
    }

    @Override
    public void setDicomFilterTags(Vector headerTags) {
        this.filterTags = headerTags;
        if (this.filterTags != null && this.filterTags.size() > 0) {
            String text = "Filter: ";
            for (HeaderTag ht : headerTags) {
                text = String.valueOf(text) + ht.tagName + "=" + ht.tagValue + " ";
            }
            this.filterLabel.setText(text);
            this.filterLabel.setBackground(Color.YELLOW);
        } else {
            this.filterLabel.setText("");
            this.filterLabel.setBackground(new JLabel().getBackground());
        }
    }

    public void reIndex() {
        if (!this.create) {
            logger.warn((Object)"not reIndexing DICOMDIR, not writeable");
        }
        try {
            File dir = this.inFile.getParentFile();
            this.inFile.delete();
            final File[] files = DICOMDIRSearchPanel.getFilesRecursive(dir);
            this.ddr = new DicomDirReader();
            this.ddr.loadDicomDirFile(this.inFile, true, true);
            if (files.length == 0) {
                return;
            }
            final ProgressMonitor progressMonitor = new ProgressMonitor(this, Translatrix.getTranslationString((String)"dicom.reindexing"), "", 0, files.length - 1);
            new Thread(){

                @Override
                public void run() {
                    logger.info((Object)"Starting reIndexing of DICOMDIR");
                    int i = 0;
                    while (i < files.length) {
                        if (!files[i].isDirectory()) {
                            try {
                                progressMonitor.setNote(" ( " + (i + 1) + " of " + (files.length + 1) + " )");
                                progressMonitor.setProgress(i);
                                DICOMDIRSearchPanel.this.ddr.append(files[i]);
                            }
                            catch (Exception e) {
                                logger.warn((Object)"Error reIndexing DICOMDIR", (Throwable)e);
                            }
                        }
                        ++i;
                    }
                    progressMonitor.close();
                    logger.info((Object)"reIndexing of DICOMDIR finished");
                    DICOMDIRSearchPanel.this.updateView();
                }
            }.start();
        }
        catch (Exception e1) {
            logger.warn((Object)"error reindexing dicom view");
            e1.printStackTrace();
        }
    }

    private static File[] getFilesRecursive(File dir) {
        ArrayList<File> al = new ArrayList<File>();
        DICOMDIRSearchPanel.visitAllFiles(dir, al);
        File[] files = new File[al.size()];
        int i = 0;
        Iterator<File> iter = al.iterator();
        while (iter.hasNext()) {
            File element;
            files[i] = element = iter.next();
            ++i;
        }
        return files;
    }

    private static void visitAllFiles(File dir, ArrayList<File> al) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                DICOMDIRSearchPanel.visitAllFiles(new File(dir, children[i]), al);
                ++i;
            }
        } else {
            al.add(dir);
        }
    }

    public DicomDirReader getDicomDirReader() {
        return this.ddr;
    }

    public void updateView() {
        Vector<Object> patients = null;
        if (this.ddr.isOK()) {
            try {
                patients = this.ddr.getPatients();
            }
            catch (Exception e) {
                logger.error((Object)"Error updating view", (Throwable)e);
            }
        }
        if (patients == null) {
            patients = new Vector();
        }
        this.patientTableModel.setPatients(patients);
        this.patientTableBorder.setTitle(String.valueOf(Translatrix.getTranslationString((String)"dicom.Patients")) + ": [" + this.patientTableModel.getRowCount() + "]");
        this.studyTableModel.setStudies(new Vector<DicomObject>());
        this.seriesTableModel.setSeries(new Vector<DicomObject>());
        this.pictureTableModel.setPictures(new Vector<DicomObject>());
        this.dicomImagePreview.loadImage(null);
    }

    public void open() {
        if (this.ddr != null && !this.ddr.isWriteable()) {
            logger.info((Object)"Reloading dicomdir");
            this.reload(this.inFile);
        }
    }

    public void close() {
        if (this.ddr != null && !this.ddr.isWriteable()) {
            logger.info((Object)"Closing dicomdir");
            this.ddr.close();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ancestor".equals(evt.getPropertyName())) {
            if (evt.getNewValue() != null) {
                this.open();
            } else {
                this.close();
            }
        }
    }
}

