/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header;

import ij.ImagePlus;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Time;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lu.tudor.santec.dicom.gui.header.DicomHeaderParseException;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.DicomObjectToStringParam;
import org.dcm4che2.data.ElementDictionary;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.util.StringUtils;

public class DicomHeader {
    private static ElementDictionary dict = ElementDictionary.getDictionary();
    private static Logger logger = Logger.getLogger((String)DicomHeader.class.getName());
    private static final Pattern tagParser = Pattern.compile("(\\w{4},\\w{4})(\\[(.*?)\\])?");
    private static final Pattern timeParser = Pattern.compile("(\\d{2}):?(\\d{2}):?(\\d{2})(\\.\\d*)?");
    private DicomObject dicomObj;
    private boolean hasPixelData = false;
    private File file;

    public DicomHeader() {
    }

    public DicomHeader(File f) {
        if (!(f.exists() && f.canRead() && f.isFile())) {
            return;
        }
        this.file = f;
        this.readHeaderDCM4CHE(f);
    }

    public DicomHeader(byte[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        this.readHeaderDCM4CHE(data);
    }

    public DicomHeader(DicomObject dicomObj) {
        this.dicomObj = dicomObj;
        this.hasPixelData = dicomObj.contains(2145386512);
    }

    public DicomHeader(ImagePlus ipl, int sliceNumber) throws DicomHeaderParseException {
        File file = DicomHeader.getFile(ipl, sliceNumber);
        if (file != null && file.canRead() && file.isFile()) {
            this.readHeaderDCM4CHE(file);
        } else if (ipl.getProperty(DicomHeader.class.getSimpleName()) != null) {
            DicomHeader dh = (DicomHeader)ipl.getProperty(DicomHeader.class.getSimpleName());
            this.dicomObj = dh.dicomObj;
            this.hasPixelData = dh.hasPixelData;
        }
    }

    public DicomHeader(ImagePlus ipl) throws DicomHeaderParseException {
        this(ipl, ipl.getCurrentSlice());
    }

    public static File getFile(ImagePlus ipl, int sliceNumber) throws DicomHeaderParseException {
        File file = null;
        String path = null;
        String name = null;
        try {
            path = ipl.getOriginalFileInfo().directory;
            if (path == null || path.length() == 0) {
                path = ipl.getFileInfo().directory;
            }
            if (ipl.getStackSize() == 1) {
                name = ipl.getOriginalFileInfo().fileName;
                if (name == null || name.length() == 0) {
                    name = ipl.getFileInfo().fileName;
                }
                file = new File(path, name);
            } else {
                name = ipl.getStack().getSliceLabel(sliceNumber).split("(\r|\n|\r\n)")[0];
            }
            file = new File(path, name);
            if (!file.exists() && file.canRead()) {
                logger.warn((Object)("Error original filepath \"" + file.getAbsolutePath() + "\" for ImagePlus " + ipl.getTitle() + " does not exist"));
                DicomHeaderParseException ee = new DicomHeaderParseException("Error original filepath \"" + file.getAbsolutePath() + "\" for ImagePlus " + ipl.getTitle() + " does not exist");
                ee.printStackTrace();
                throw ee;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Error getting original filepath for ImagePlus " + ipl.getTitle()));
            DicomHeaderParseException ee = new DicomHeaderParseException("Error getting original filepath for ImagePlus " + ipl.getTitle());
            ee.printStackTrace();
            throw ee;
        }
        if (file != null) {
            logger.info((Object)("FILE:        " + file.getAbsolutePath()));
        }
        return file;
    }

    public DicomObject getDicomObject() {
        return this.dicomObj;
    }

    public void setDicomObject(DicomObject dicomObject) {
        this.dicomObj = dicomObject;
    }

    public boolean hasPixelData() {
        return this.hasPixelData;
    }

    private void readHeaderDCM4CHE(File f) {
        DicomInputStream in = null;
        try {
            try {
                in = new DicomInputStream(f);
                PixelDataFoundHandler handler = new PixelDataFoundHandler();
                in.setHandler((DicomInputHandler)handler);
                DicomObject dcmobj = in.readDicomObject();
                in.close();
                if (handler.stopTagFound()) {
                    this.hasPixelData = true;
                    dcmobj.putBytes(2145386512, VR.OB, null);
                } else {
                    this.hasPixelData = false;
                }
                this.dicomObj = dcmobj;
            }
            catch (Throwable e) {
                logger.info((Object)("File " + f.getAbsolutePath() + " has no DICOM Header !!!"));
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void readHeaderDCM4CHE(byte[] data) {
        try {
            DicomInputStream in = new DicomInputStream((InputStream)new ByteArrayInputStream(data));
            PixelDataFoundHandler handler = new PixelDataFoundHandler();
            in.setHandler((DicomInputHandler)handler);
            DicomObject dcmobj = in.readDicomObject();
            in.close();
            if (handler.stopTagFound()) {
                this.hasPixelData = true;
                dcmobj.putBytes(2145386512, VR.OB, null);
            } else {
                this.hasPixelData = false;
            }
            this.dicomObj = dcmobj;
        }
        catch (Throwable e) {
            logger.info((Object)"given data has no DICOM Header !!!");
        }
    }

    public double getHeaderDoubleValue(int tagNr) {
        try {
            return this.dicomObj.getDouble(tagNr);
        }
        catch (UnsupportedOperationException e) {
            try {
                logger.warn((Object)"Tag is not of type double, trying to parse.....");
                return Double.parseDouble(this.getHeaderStringValue(tagNr));
            }
            catch (Exception e2) {
                logger.warn((Object)("error getting tag " + DicomHeader.toTagString(tagNr)));
                return -1.0;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("error getting tag " + DicomHeader.toTagString(tagNr)));
            return -1.0;
        }
    }

    public double getHeaderDoubleValue(String tagNr) throws DicomHeaderParseException {
        return this.getHeaderDoubleValue(DicomHeader.toTagInt(tagNr));
    }

    public int getHeaderIntegerValue(int tagNr) {
        try {
            return this.dicomObj.getInt(tagNr);
        }
        catch (Exception e) {
            logger.warn((Object)("error getting tag " + DicomHeader.toTagString(tagNr)));
            return -1;
        }
    }

    public int getHeaderIntegerValue(String tagNr) throws DicomHeaderParseException {
        return this.getHeaderIntegerValue(DicomHeader.toTagInt(tagNr));
    }

    public String getHeaderStringValue(int tagNr) {
        StringBuffer sb = new StringBuffer();
        try {
            String[] val;
            DicomElement elem = this.dicomObj.get(tagNr);
            String[] stringArray = val = elem.getStrings(this.dicomObj.getSpecificCharacterSet(), false);
            int n = val.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                sb.append(string);
                sb.append("/");
                ++n2;
            }
            sb.deleteCharAt(sb.length() - 1);
            if (elem.countItems() > 0 && sb.length() == 0) {
                sb.append("[" + elem.countItems() + " Subitems]");
            }
            return sb.toString();
        }
        catch (Exception e) {
            DicomElement elem = this.dicomObj.get(tagNr);
            try {
                String val = elem.getValueAsString(this.dicomObj.getSpecificCharacterSet(), 1024);
                if (val == null) {
                    val = "";
                }
                if (elem.countItems() > 0 && val.length() == 0) {
                    val = String.valueOf(val) + "[" + elem.countItems() + " Subitems]";
                }
                return val;
            }
            catch (Exception ee) {
                if (elem != null && elem.countItems() > 0) {
                    return "[" + elem.countItems() + " Subitems]";
                }
                return "";
            }
        }
    }

    public String[] getHeaderStringValues(int tagNr) {
        try {
            DicomElement elem = this.dicomObj.get(tagNr);
            String[] val = elem.getStrings(this.dicomObj.getSpecificCharacterSet(), false);
            return val;
        }
        catch (Exception e) {
            try {
                DicomElement elem = this.dicomObj.get(tagNr);
                String str = elem.getString(this.dicomObj.getSpecificCharacterSet(), false);
                return new String[]{str};
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public String getHeaderStringValue(DicomElement dcmelement) {
        try {
            String val = dcmelement.getString(this.dicomObj.getSpecificCharacterSet(), false);
            if (val == null) {
                val = "";
            }
            return val;
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getHeaderStringValue(String headerNr) throws DicomHeaderParseException {
        if ((headerNr = headerNr.replaceAll("x", "0").replaceAll("X", "0")).indexOf("#") > 0) {
            try {
                return "" + this.getHeaderValueInsideTag(headerNr.split("#"));
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
        }
        return this.getHeaderStringValue(DicomHeader.toTagInt(headerNr));
    }

    @Deprecated
    public Time getHeaderTimeValue(String tagNr) throws DicomHeaderParseException {
        return this.getHeaderTimeValue(DicomHeader.toTagInt(tagNr));
    }

    @Deprecated
    public Time getHeaderTimeValue(int tagNr) {
        String time = this.getHeaderStringValue(tagNr);
        if (time.length() != 6) {
            return null;
        }
        try {
            int hour = Integer.parseInt(time.substring(0, 2));
            int min = Integer.parseInt(time.substring(2, 4));
            int sec = Integer.parseInt(time.substring(4, 6));
            return new Time(hour, min, sec);
        }
        catch (Exception e) {
            logger.warn((Object)("error parsing time: " + time));
            return null;
        }
    }

    public Date getHeaderDateValue(String tagNr) throws DicomHeaderParseException {
        return this.getHeaderDateValue(DicomHeader.toTagInt(tagNr));
    }

    public Date getHeaderDateValue(int tagNr) {
        return this.dicomObj.getDate(tagNr);
    }

    public HeaderTag getHeaderTag(String tagNr) throws DicomHeaderParseException {
        return this.getHeaderTag(DicomHeader.toTagInt(tagNr));
    }

    private HeaderTag getHeaderTag(int tagInt) {
        return new HeaderTag(this.dicomObj.get(tagInt), this.dicomObj);
    }

    public boolean containsHeaderTag(String tagNr) throws DicomHeaderParseException {
        if (!tagNr.contains("#")) {
            return this.containsHeaderTag(DicomHeader.toTagInt(tagNr));
        }
        return this.containsHeaderValueInsideTag(tagNr.split("#"));
    }

    private boolean containsHeaderValueInsideTag(String[] tagHierarchy) {
        try {
            DicomObject obj = this.dicomObj;
            DicomElement elem = null;
            int i = 0;
            while (i < tagHierarchy.length - 1) {
                String tag = tagHierarchy[i];
                elem = obj.get(DicomHeader.toTagInt(tag.replaceAll("x", "0").replaceAll("X", "0")));
                obj = elem.getDicomObject();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean containsHeaderTag(int tagNr) {
        try {
            return this.dicomObj.contains(tagNr);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Comparable getHeaderValueInsideTag(int[] tagHierarchy) {
        try {
            obj = this.dicomObj;
            i = 0;
            while (i < tagHierarchy.length - 1) {
                obj = obj.get(tagHierarchy[i]).getDicomObject();
                ++i;
            }
            elem = obj.get(tagHierarchy[tagHierarchy.length - 1]);
            return this.getHeaderValue(elem);
        }
        catch (Exception e) {
            tags = "";
            i = 0;
            ** while (i < tagHierarchy.length)
        }
lbl-1000:
        // 1 sources

        {
            tags = String.valueOf(tags) + DicomHeader.toTagString(tagHierarchy[i]) + " ";
            ++i;
            continue;
        }
lbl17:
        // 1 sources

        DicomHeader.logger.debug((Object)("DICOM Tag: " + tags + " not found"));
        return "";
    }

    public Comparable getHeaderValue(String tagNr) {
        if (tagNr.indexOf("#") > 0) {
            try {
                return this.getHeaderValueInsideTag(tagNr.split("#"));
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
        }
        try {
            int tag = DicomHeader.toTagInt(tagNr);
            return this.getHeaderValue(tag);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Comparable getHeaderValue(int tagNr) {
        if (this.isEmpty()) {
            return null;
        }
        try {
            DicomElement element = this.dicomObj.get(tagNr);
            return this.getHeaderValue(element);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Comparable getHeaderValue(DicomElement element) {
        block19: {
            block18: {
                if (!this.isEmpty()) break block18;
                return null;
            }
            if (element != null) break block19;
            return null;
        }
        try {
            String vr = element.vr().toString();
            int tagNr = element.tag();
            if (vr.equals("US") || vr.equals("UL") || vr.equals("SS") || vr.equals("SL") || vr.equals("IS")) {
                int[] ints = element.getInts(false);
                if (ints.length == 1) {
                    return Integer.valueOf(ints[0]);
                }
                return String.valueOf(this.getHeaderStringValuesAsString(element));
            }
            if (vr.equals("DS") || vr.equals("FL") || vr.equals("FD") || vr.equals("OF")) {
                double[] doubles = element.getDoubles(false);
                if (doubles.length == 1) {
                    return Double.valueOf(doubles[0]);
                }
                return String.valueOf(this.getHeaderStringValuesAsString(element));
            }
            if (vr.equals("DA")) {
                return element.getDate(false);
            }
            if (vr.equals("DT")) {
                return element.getDate(false);
            }
            if (vr.equals("TM")) {
                String timeString = element.getString(this.dicomObj.getSpecificCharacterSet(), false);
                try {
                    Matcher matcher = timeParser.matcher(timeString);
                    if (matcher.matches()) {
                        timeString = String.valueOf(matcher.group(1)) + ":" + matcher.group(2) + ":" + matcher.group(3);
                        String muSec = ".000";
                        if (matcher.groupCount() == 4 && matcher.group(4) != null) {
                            muSec = matcher.group(4);
                            if (muSec.length() < 4) {
                                while (muSec.length() < 4) {
                                    muSec = String.valueOf(muSec) + "0";
                                }
                            } else {
                                muSec = muSec.substring(0, 4);
                            }
                        }
                        timeString = String.valueOf(timeString) + muSec;
                    }
                }
                catch (Exception e) {
                    logger.info((Object)"Error parsing Time");
                }
                return timeString;
            }
            return this.getHeaderStringValuesAsString(element);
        }
        catch (Throwable e) {
            logger.log((Priority)Level.WARN, (Object)("Error reading Tag from : " + element), e);
            return null;
        }
    }

    private String getHeaderStringValuesAsString(DicomElement element) {
        try {
            StringBuffer sb = new StringBuffer();
            String[] values = element.getStrings(this.dicomObj.getSpecificCharacterSet(), false);
            if (values != null && values.length > 0) {
                sb.append(values[0]);
                int i = 1;
                while (i < values.length) {
                    sb.append("/").append(values[i]);
                    ++i;
                }
            }
            if (element.countItems() > 0 && sb.length() == 0) {
                sb.append("[" + element.countItems() + " Subitems]");
            }
            return sb.toString();
        }
        catch (UnsupportedOperationException e) {
            try {
                return element.getString(this.dicomObj.getSpecificCharacterSet(), false);
            }
            catch (Exception e2) {
                return element.toString();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public Comparable getHeaderValueInsideTag(String[] tagHierarchy) throws DicomHeaderParseException {
        try {
            obj = this.dicomObj;
            elem = null;
            i = 0;
            while (i < tagHierarchy.length - 1) {
                tag = tagHierarchy[i];
                elem = obj.get(DicomHeader.toTagInt(tag.replaceAll("x", "0").replaceAll("X", "0")));
                obj = elem.getDicomObject();
                ++i;
            }
            tag = tagHierarchy[tagHierarchy.length - 1];
            elems = this.getElement(elem, tag);
            if (elems.length == 1) {
                return this.getHeaderValue(elems[0]);
            }
            sb = new StringBuffer();
            sb.append(this.getHeaderStringValue(elems[0]));
            i = 1;
            while (i < elems.length) {
                sb.append("#").append(this.getHeaderStringValue(elems[i]));
                ++i;
            }
            return sb.toString();
        }
        catch (Exception e) {
            tags = "";
            i = 0;
            ** while (i < tagHierarchy.length)
        }
lbl-1000:
        // 1 sources

        {
            tags = String.valueOf(tags) + tagHierarchy[i] + "#";
            ++i;
            continue;
        }
lbl32:
        // 1 sources

        DicomHeader.logger.log((Priority)Level.DEBUG, (Object)("DICOM Tag: " + tags + " not found"));
        return "";
    }

    private DicomElement[] getElement(DicomElement elem, String tagString) throws DicomHeaderParseException {
        Matcher matcher = tagParser.matcher(tagString);
        matcher.matches();
        tagString = matcher.group(1);
        String nr = matcher.group(3);
        if (nr != null) {
            if (nr.equals("*")) {
                DicomElement[] arr = new DicomElement[elem.countItems()];
                int i = 0;
                while (i < arr.length) {
                    arr[i] = elem.getDicomObject(i).get(DicomHeader.toTagInt(matcher.group(1).replaceAll("x", "0").replaceAll("X", "0")));
                    ++i;
                }
                return arr;
            }
            try {
                return new DicomElement[]{elem.getDicomObject(Integer.parseInt(nr) - 1).get(DicomHeader.toTagInt(matcher.group(1).replaceAll("x", "0").replaceAll("X", "0")))};
            }
            catch (NumberFormatException e) {
                throw new DicomHeaderParseException(tagString);
            }
        }
        return new DicomElement[]{elem.getDicomObject().get(DicomHeader.toTagInt(tagString.replaceAll("x", "0").replaceAll("X", "0")))};
    }

    public static String getHeaderName(int tagNr) {
        return dict.nameOf(tagNr);
    }

    public static String getHeaderName(String tagNr) {
        try {
            return DicomHeader.getHeaderName(DicomHeader.toTagInt(tagNr));
        }
        catch (Exception e) {
            logger.debug((Object)("DICOM Tag: " + tagNr + " not found in Dict"));
            return "";
        }
    }

    public static String getHeaderFieldType(int tagNr) {
        return DicomHeader.getHeaderFieldType(DicomHeader.toTagString(tagNr));
    }

    public static String getHeaderFieldType(String tagNr) {
        try {
            BasicDicomObject de = new BasicDicomObject();
            String val = "" + de.vrOf(DicomHeader.toTagInt(tagNr));
            return val;
        }
        catch (Exception e) {
            logger.debug((Object)("DICOM Tag: " + tagNr + " not found in Dict"));
            return "";
        }
    }

    public static VR getHeaderFieldTypeAsVR(String vrName) {
        if (vrName.equalsIgnoreCase("AE")) {
            return VR.AE;
        }
        if (vrName.equalsIgnoreCase("AS")) {
            return VR.AS;
        }
        if (vrName.equalsIgnoreCase("AT")) {
            return VR.AT;
        }
        if (vrName.equalsIgnoreCase("CS")) {
            return VR.CS;
        }
        if (vrName.equalsIgnoreCase("DA")) {
            return VR.DA;
        }
        if (vrName.equalsIgnoreCase("DS")) {
            return VR.DS;
        }
        if (vrName.equalsIgnoreCase("DT")) {
            return VR.DT;
        }
        if (vrName.equalsIgnoreCase("FD")) {
            return VR.FD;
        }
        if (vrName.equalsIgnoreCase("FL")) {
            return VR.FL;
        }
        if (vrName.equalsIgnoreCase("IS")) {
            return VR.IS;
        }
        if (vrName.equalsIgnoreCase("LO")) {
            return VR.LO;
        }
        if (vrName.equalsIgnoreCase("LT")) {
            return VR.LT;
        }
        if (vrName.equalsIgnoreCase("OB")) {
            return VR.OB;
        }
        if (vrName.equalsIgnoreCase("OF")) {
            return VR.OF;
        }
        if (vrName.equalsIgnoreCase("OW")) {
            return VR.OW;
        }
        if (vrName.equalsIgnoreCase("PN")) {
            return VR.PN;
        }
        if (vrName.equalsIgnoreCase("SH")) {
            return VR.SH;
        }
        if (vrName.equalsIgnoreCase("SL")) {
            return VR.SL;
        }
        if (vrName.equalsIgnoreCase("SQ")) {
            return VR.SQ;
        }
        if (vrName.equalsIgnoreCase("SS")) {
            return VR.SS;
        }
        if (vrName.equalsIgnoreCase("ST")) {
            return VR.ST;
        }
        if (vrName.equalsIgnoreCase("TM")) {
            return VR.TM;
        }
        if (vrName.equalsIgnoreCase("UI")) {
            return VR.UI;
        }
        if (vrName.equalsIgnoreCase("UL")) {
            return VR.UL;
        }
        if (vrName.equalsIgnoreCase("UN")) {
            return VR.UN;
        }
        if (vrName.equalsIgnoreCase("US")) {
            return VR.US;
        }
        if (vrName.equalsIgnoreCase("UT")) {
            return VR.UT;
        }
        return null;
    }

    public String getHeader(int tagNr) {
        try {
            DicomElement dcmele = this.dicomObj.get(tagNr);
            return this.toElementString(dcmele);
        }
        catch (Exception e) {
            logger.debug((Object)("DICOM Tag: " + DicomHeader.toTagString(tagNr) + " not found"));
            return "";
        }
    }

    private String toElementString(DicomElement dcmele) {
        StringBuffer sb = new StringBuffer();
        sb.append(DicomHeader.toTagString(dcmele.tag())).append(" [").append(dcmele.vr()).append("] ").append(dict.nameOf(dcmele.tag())).append(": ").append(this.getValue(dcmele));
        return sb.toString();
    }

    private Object getValue(DicomElement elem) {
        StringBuffer sb = new StringBuffer();
        try {
            String[] values = elem.getStrings(this.dicomObj.getSpecificCharacterSet(), false);
            sb.append(values[0]);
            int i = 1;
            while (i < values.length) {
                sb.append("/").append(values[i]);
                ++i;
            }
        }
        catch (Exception e) {
            try {
                sb.append(elem.getString(this.dicomObj.getSpecificCharacterSet(), false));
            }
            catch (Exception e2) {
                return "";
            }
        }
        return sb.toString();
    }

    public String getHeader(String tagNr) throws DicomHeaderParseException {
        return this.getHeader(DicomHeader.toTagInt(tagNr));
    }

    public String toString() {
        DicomObjectToStringParam param = new DicomObjectToStringParam(true, 64, 100, 100, Integer.MAX_VALUE, "", System.getProperty("line.separator", "\n"));
        StringBuffer sb = new StringBuffer();
        if (this.dicomObj == null) {
            return "";
        }
        this.toStringBuffer(this.dicomObj, sb, param);
        return sb.toString();
    }

    public int toStringBuffer(DicomObject obj, StringBuffer sb, DicomObjectToStringParam param) {
        if (sb == null) {
            throw new NullPointerException();
        }
        if (param == null) {
            param = DicomObjectToStringParam.getDefaultParam();
        }
        int lines = 0;
        Iterator it = obj.iterator();
        while (lines < param.numLines && it.hasNext()) {
            DicomElement e = (DicomElement)it.next();
            sb.append(param.indent);
            sb.append(this.toElementString(e));
            sb.append(param.lineSeparator);
            if (e.countItems() <= 0) continue;
            DicomObjectToStringParam param1 = new DicomObjectToStringParam(param.name, param.valueLength, param.numItems, param.lineLength, param.numLines - lines, String.valueOf(param.indent) + "   ", param.lineSeparator);
            if (e.hasDicomObjects()) {
                lines += this.itemsToStringBuffer(e, sb, param1);
                continue;
            }
            lines += DicomHeader.fragsToStringBuffer(e, sb, param1);
        }
        return lines;
    }

    private int itemsToStringBuffer(DicomElement e, StringBuffer sb, DicomObjectToStringParam param) {
        int lines = 0;
        int i = 0;
        int n = e.countItems();
        while (i < n && lines < param.numLines) {
            if (++lines == param.numLines) {
                sb.append("...").append(param.lineSeparator);
                break;
            }
            DicomObject item = e.getDicomObject(i);
            sb.append(param.indent);
            sb.append("ITEM #");
            sb.append(i + 1);
            if (i >= param.numItems) {
                sb.append("...").append(param.lineSeparator);
                break;
            }
            sb.append(":");
            sb.append(param.lineSeparator);
            DicomObjectToStringParam param1 = new DicomObjectToStringParam(param.name, param.valueLength, param.numItems, param.lineLength, param.numLines - lines, String.valueOf(param.indent) + "   ", param.lineSeparator);
            lines += this.toStringBuffer(item, sb, param1);
            ++i;
        }
        return lines;
    }

    private static int fragsToStringBuffer(DicomElement e, StringBuffer sb, DicomObjectToStringParam param) {
        System.out.println("print a fragment.");
        int lines = 0;
        int i = 0;
        int n = e.countItems();
        while (i < n) {
            if (++lines >= param.numLines) {
                sb.append("...").append(param.lineSeparator);
                break;
            }
            sb.append(param.indent);
            sb.append("ITEM #");
            sb.append(i + 1);
            if (i >= param.numItems) {
                sb.append("...").append(param.lineSeparator);
                break;
            }
            sb.append(" [");
            sb.append(e.getFragment(i).length + 1 & 0xFFFFFFFE);
            sb.append(" bytes]");
            sb.append(param.lineSeparator);
            ++i;
        }
        return lines;
    }

    public boolean isEmpty() {
        return this.dicomObj == null || this.dicomObj.size() == 0;
    }

    public DicomHeader clone() {
        DicomHeader dh = new DicomHeader();
        this.dicomObj.copyTo(dh.dicomObj);
        dh.hasPixelData = this.hasPixelData;
        return dh;
    }

    public static int toTagInt(String headerNr) throws DicomHeaderParseException {
        try {
            headerNr = headerNr.replaceAll(",", "");
            long tag = Long.parseLong(headerNr, 16);
            if (tag > Integer.MAX_VALUE) {
                return (int)((tag - Integer.MAX_VALUE) * -1L);
            }
            return (int)tag;
        }
        catch (Exception e) {
            throw new DicomHeaderParseException("Unable to parse Tag " + headerNr + " to int");
        }
    }

    public static String toTagString(int tagNr) {
        return String.valueOf(StringUtils.shortToHex((int)(tagNr >> 16))) + ',' + StringUtils.shortToHex((int)tagNr);
    }

    public Vector<HeaderTag> getAsHeaderTags() {
        Vector<HeaderTag> tags = new Vector<HeaderTag>();
        for (DicomElement element : this.dicomObj) {
            HeaderTag ht = new HeaderTag(element, this.dicomObj);
            tags.add(ht);
        }
        return tags;
    }

    public Vector<HeaderTag> getHeaderTagsAsFlatList() {
        Vector<HeaderTag> tags = new Vector<HeaderTag>();
        this.addTags(this.dicomObj, tags, "", "");
        return tags;
    }

    private void addTags(DicomObject dicomObj, Vector<HeaderTag> tags, String prefix, String parent) {
        for (DicomElement element : dicomObj) {
            HeaderTag ht = new HeaderTag(element, dicomObj);
            if (prefix.length() > 0) {
                ht.tagNr = String.valueOf(parent) + ht.tagNr;
                ht.tagName = String.valueOf(prefix) + ht.tagName;
            }
            tags.add(ht);
            if (!element.hasDicomObjects()) continue;
            int i = 0;
            while (i < element.countItems()) {
                this.addTags(element.getDicomObject(i), tags, String.valueOf(ht.tagName) + "#", String.valueOf(ht.tagNr) + "#");
                ++i;
            }
        }
    }

    public static DicomHeader getHeader(ImagePlus image) {
        try {
            return new DicomHeader(image);
        }
        catch (DicomHeaderParseException e) {
            logger.log((Priority)Level.WARN, (Object)e.getMessage());
            return new DicomHeader();
        }
    }

    public static String getHeaderValue(ImagePlus image, String tag) {
        try {
            return new DicomHeader(image).getHeaderStringValue(tag);
        }
        catch (DicomHeaderParseException e) {
            logger.log((Priority)Level.WARN, (Object)e.getMessage());
            return null;
        }
    }

    public static void main(String[] argsv) {
        DicomHeader dh = new DicomHeader(new File("/home/hermenj/clemens_CD/DICOM/00007D6E/AAAB2384/AA35EB06/0000FBF3/EE3C10B9"));
        System.out.println(dh.toString());
        try {
            System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            String tags = "0040,030E#0018,9345[*]";
            System.out.println(dh.getHeaderValueInsideTag(tags.split("#")));
        }
        catch (DicomHeaderParseException e) {
            e.printStackTrace();
        }
    }

    public static int tagForName(String tagName) {
        return dict.tagForName(tagName);
    }

    public File getFile() {
        return this.file;
    }

    public boolean isCompressedImage() {
        String transferSyntax = this.getHeaderStringValue(131088);
        return transferSyntax.indexOf("1.2.4") > -1 || transferSyntax.indexOf("1.2.5") > -1;
    }

    private class PixelDataFoundHandler
    implements DicomInputHandler {
        private boolean tagFound = false;

        private PixelDataFoundHandler() {
        }

        public boolean readValue(DicomInputStream in) throws IOException {
            if (in.tag() == 2145386512) {
                this.tagFound = true;
            }
            if (((long)in.tag() & 0xFFFFFFFFL) >= 2145386512L && in.level() == 0) {
                return false;
            }
            return in.readValue(in);
        }

        public boolean stopTagFound() {
            return this.tagFound;
        }
    }
}

