/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header;

import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import lu.tudor.santec.dicom.gui.DicomFileDialog;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.DicomHeaderInfoPanel;
import lu.tudor.santec.dicom.gui.header.Diff;

public class DicomHeaderDiffDialog
extends JFrame
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private DicomHeaderInfoPanel dicomHeaderInfoPanel;
    private Vector<JPanel> panels = new Vector();
    private MyAdjustmentListener adjustmentListener;
    private DicomFileDialog dicomFileDialog;
    private JPanel mainPanel;
    private JPanel filePanel;

    public DicomHeaderDiffDialog(DicomFileDialog dialog) {
        this.dicomFileDialog = dialog;
        this.setTitle("DICOM Header Diff");
        this.buildPanel(2);
    }

    private void buildPanel(int files) {
        this.setLayout(new BorderLayout());
        this.filePanel = new JPanel(new GridLayout(1, 0));
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridLayout(1, 0));
        this.setTitle("DICOM Diff");
        this.adjustmentListener = new MyAdjustmentListener();
        int i = 0;
        while (i < files) {
            this.dicomHeaderInfoPanel = new DicomHeaderInfoPanel(null);
            this.dicomHeaderInfoPanel.addAdjustmentListener(this.adjustmentListener);
            this.dicomHeaderInfoPanel.addPropertyChangeListener(this);
            this.panels.add(this.dicomHeaderInfoPanel);
            this.mainPanel.add(this.dicomHeaderInfoPanel);
            JButton jb = new JButton("select file");
            jb.setActionCommand(String.valueOf(i));
            jb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DicomHeaderDiffDialog.this.dicomFileDialog.showNewDialog(DicomHeaderDiffDialog.this) == 0) {
                        DicomHeader dh = new DicomHeader(DicomHeaderDiffDialog.this.dicomFileDialog.getSelectedFile());
                        ((DicomHeaderInfoPanel)DicomHeaderDiffDialog.this.panels.get(Integer.parseInt(e.getActionCommand()))).setInfo(dh);
                    }
                }
            });
            this.filePanel.add(jb);
            ++i;
        }
        this.add((Component)this.filePanel, "North");
        this.add((Component)this.mainPanel, "Center");
        this.setSize(800, 800);
        this.setVisible(true);
        this.setExtendedState(6);
    }

    public void setInfo(File f) {
        DicomHeader dh = new DicomHeader(f);
        this.dicomHeaderInfoPanel.setInfo(dh);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FILE_CHANGED")) {
            DicomHeaderInfoPanel p1 = (DicomHeaderInfoPanel)this.panels.get(0);
            DicomHeaderInfoPanel p2 = (DicomHeaderInfoPanel)this.panels.get(1);
            if (p1.getText() == null || p1.getText().length() < 2 || p2.getText() == null || p2.getText().length() < 2) {
                return;
            }
            Diff diff = new Diff();
            p1.showDiff(diff.diff(p1.getText(), p2.getText()));
            p2.showDiff(diff.diff(p2.getText(), p1.getText()));
            try {
                this.setTitle("Dicom Diff: " + p1.getFile().getName() + " vs " + p2.getFile().getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class MyAdjustmentListener
    implements AdjustmentListener {
        MyAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent evt) {
            Adjustable source = evt.getAdjustable();
            if (evt.getValueIsAdjusting()) {
                return;
            }
            int orient = source.getOrientation();
            int type = evt.getAdjustmentType();
            switch (type) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
                case 3: {
                    break;
                }
            }
            int value = evt.getValue();
            for (DicomHeaderInfoPanel element : DicomHeaderDiffDialog.this.panels) {
                element.setAdjustment(value);
            }
        }
    }
}

