/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.nio.CharBuffer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.utils.DICOMHexDump;

public class DicomHexInfoPanel
extends JPanel
implements ActionListener,
CaretListener {
    private static final long serialVersionUID = 1L;
    protected static final String FILE_CHANGED = "FILE_CHANGED";
    private static final int BYTES = 16000;
    private static final int LINEBREAK = 20;
    JTextArea linesField;
    JTextArea hexField;
    JTextArea textField;
    Font font = new Font("Courier", 0, 12);
    private JTextField searchField;
    private JButton searchButton;
    private JScrollPane jsp;
    Highlighter.HighlightPainter infoHighlightPainter = new MyHighlightPainter(new Color(255, 255, 0));
    Highlighter.HighlightPainter diffHighlightPainter = new MyHighlightPainter(new Color(255, 0, 0, 40));
    Highlighter.HighlightPainter selectionHighlightPainter = new MyHighlightPainter(new Color(184, 207, 229));
    private AdjustmentListener listener;
    protected File f;

    public DicomHexInfoPanel() {
        this.setLayout(new BorderLayout());
        this.buildPanel();
    }

    private void buildPanel() {
        JPanel textPanel = new JPanel(new BorderLayout(3, 3));
        textPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.linesField = new JTextArea(800, 8){
            private static final long serialVersionUID = 1L;

            @Override
            public void replaceSelection(String content) {
                try {
                    content = content.replaceAll("file:/", "");
                    DicomHexInfoPanel.this.f = new File(content);
                    DicomHexInfoPanel.this.setFile(DicomHexInfoPanel.this.f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.linesField.setLineWrap(true);
        this.linesField.setFont(this.font);
        textPanel.add((Component)this.linesField, "West");
        this.hexField = new JTextArea(800, 60){
            private static final long serialVersionUID = 1L;

            @Override
            public void replaceSelection(String content) {
                try {
                    content = content.replaceAll("file:/", "");
                    DicomHexInfoPanel.this.f = new File(content);
                    DicomHexInfoPanel.this.setFile(DicomHexInfoPanel.this.f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.hexField.addCaretListener(this);
        this.hexField.setFont(this.font);
        this.hexField.setLineWrap(true);
        textPanel.add((Component)this.hexField, "Center");
        this.textField = new JTextArea(800, 20){
            private static final long serialVersionUID = 1L;

            @Override
            public void replaceSelection(String content) {
                try {
                    content = content.replaceAll("file:/", "");
                    DicomHexInfoPanel.this.f = new File(content);
                    DicomHexInfoPanel.this.setFile(DicomHexInfoPanel.this.f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.textField.addCaretListener(this);
        this.textField.setFont(this.font);
        this.textField.setLineWrap(true);
        textPanel.add((Component)this.textField, "East");
        JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)new JLabel("search:"), "West");
        this.searchField = new JTextField();
        jp.add((Component)this.searchField, "Center");
        this.searchButton = new JButton(DicomIcons.getIcon16("icon_search.png"));
        jp.add((Component)this.searchButton, "East");
        this.searchButton.addActionListener(this);
        this.searchField.addActionListener(this);
        this.add((Component)jp, "North");
        this.jsp = new JScrollPane(textPanel);
        this.add((Component)this.jsp, "Center");
        this.setSize(700, 700);
    }

    public void setFile(File f) {
        this.f = f;
        String[] hexArr = DICOMHexDump.dump2HEX(f, 16000L, 20);
        this.linesField.setText(hexArr[0]);
        this.linesField.setCaretPosition(0);
        this.hexField.setText(hexArr[1]);
        this.hexField.setCaretPosition(0);
        this.textField.setText(hexArr[2]);
        this.textField.setCaretPosition(0);
        this.firePropertyChange(FILE_CHANGED, null, f);
    }

    private void search() {
        this.highlight(this.searchField.getText());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.search();
    }

    public void highlight(String pattern) {
        this.removeHighlights(this.linesField, this.infoHighlightPainter);
        this.removeHighlights(this.hexField, this.infoHighlightPainter);
        this.removeHighlights(this.textField, this.infoHighlightPainter);
        if (pattern == null || pattern.equals("")) {
            return;
        }
        if (pattern.matches("[\\p{XDigit}]{4,4},[\\p{XDigit}]{4,4}")) {
            pattern = String.valueOf(pattern.substring(2, 4)) + "[\\n\\s]" + pattern.substring(0, 2) + "[\\n\\s]" + pattern.substring(7, 9) + "[\\n\\s]" + pattern.substring(5, 7);
            System.out.println(pattern);
            try {
                Highlighter hexHilite = this.hexField.getHighlighter();
                Highlighter textHilite = this.textField.getHighlighter();
                Document doc = this.hexField.getDocument();
                String text = doc.getText(0, doc.getLength()).toLowerCase();
                Pattern p = Pattern.compile(pattern.toLowerCase(), 8);
                Matcher m = p.matcher(CharBuffer.wrap(text.toCharArray()));
                while (m.find()) {
                    hexHilite.addHighlight(m.start(), m.end(), this.infoHighlightPainter);
                    int start = m.start() / 3;
                    int end = m.end() / 3;
                    textHilite.addHighlight(start + start / 20, end + end / 20 + 1, this.infoHighlightPainter);
                }
            }
            catch (BadLocationException hexHilite) {}
        } else {
            try {
                Highlighter hexHilite = this.hexField.getHighlighter();
                Highlighter textHilite = this.textField.getHighlighter();
                Document doc = this.textField.getDocument();
                String text = doc.getText(0, doc.getLength()).toLowerCase();
                Pattern p = Pattern.compile(pattern.toLowerCase(), 8);
                Matcher m = p.matcher(CharBuffer.wrap(text.toCharArray()));
                while (m.find()) {
                    textHilite.addHighlight(m.start(), m.end(), this.infoHighlightPainter);
                    int start = m.start();
                    int line = start / 21;
                    int end = m.end() - line;
                    hexHilite.addHighlight((start -= line) * 3, end * 3 - 1, this.infoHighlightPainter);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void diff(JTextComponent textComp, String pattern) {
        try {
            Highlighter hilite = textComp.getHighlighter();
            Document doc = textComp.getDocument();
            String text = doc.getText(0, doc.getLength());
            if (pattern.startsWith("---------")) {
                return;
            }
            int fromIndex = 0;
            int start = text.indexOf(pattern);
            while (start != -1) {
                fromIndex = start + pattern.length();
                hilite.addHighlight(start, fromIndex, this.diffHighlightPainter);
                start = text.indexOf(pattern, fromIndex);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeHighlights(JTextComponent textComp, Highlighter.HighlightPainter highlighter) {
        Highlighter hilite = textComp.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        int i = 0;
        while (i < hilites.length) {
            if (hilites[i].getPainter().equals(highlighter)) {
                hilite.removeHighlight(hilites[i]);
            }
            ++i;
        }
    }

    public void addAdjustmentListener(AdjustmentListener listener) {
        this.listener = listener;
        this.jsp.getVerticalScrollBar().addAdjustmentListener(listener);
    }

    public void setAdjustment(int value) {
        this.jsp.getVerticalScrollBar().removeAdjustmentListener(this.listener);
        this.jsp.getVerticalScrollBar().setValue(value);
        this.jsp.getVerticalScrollBar().addAdjustmentListener(this.listener);
    }

    public void showDiff(Vector<String> diff) {
        this.removeHighlights(this.linesField, this.diffHighlightPainter);
        for (String element : diff) {
            this.diff(this.linesField, element);
        }
    }

    public String getText() {
        return this.linesField.getText();
    }

    public File getFile() {
        return this.f;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.removeHighlights(this.textField, this.selectionHighlightPainter);
        this.removeHighlights(this.hexField, this.selectionHighlightPainter);
        int pos1 = e.getDot();
        int pos2 = e.getMark();
        int start = Math.min(pos1, pos2);
        int end = Math.max(pos1, pos2);
        if (start == end) {
            return;
        }
        if (e.getSource().equals(this.hexField)) {
            start /= 3;
            end /= 3;
            Highlighter textHilite = this.textField.getHighlighter();
            try {
                textHilite.addHighlight(start + start / 20, end + end / 20 + 1, this.selectionHighlightPainter);
            }
            catch (BadLocationException badLocationException) {}
        } else if (e.getSource().equals(this.textField)) {
            this.removeHighlights(this.hexField, this.selectionHighlightPainter);
            int line = start / 21;
            start -= line;
            end -= line;
            Highlighter hexHilite = this.hexField.getHighlighter();
            try {
                hexHilite.addHighlight(start * 3, end * 3 - 1, this.selectionHighlightPainter);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public MyHighlightPainter(Color color) {
            super(color);
        }
    }
}

