/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.DicomHeaderParseException;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.Tag;
import org.dcm4che2.util.StringUtils;

public class HeaderTag
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Vector<HeaderTag> allTags;
    public String tagType = "";
    public String tagNr = null;
    public String tagName = null;
    public String tagValue = null;
    private int length;
    private int location;
    private DicomElement dicomElement;

    public DicomElement getDicomElement() {
        return this.dicomElement;
    }

    public void setDicomElement(DicomElement dicomElement) {
        this.dicomElement = dicomElement;
    }

    public HeaderTag() {
    }

    public HeaderTag(String headerLine) {
        if (headerLine != null && headerLine.length() > 9) {
            try {
                int idx1 = headerLine.indexOf(" ");
                int idx2 = headerLine.indexOf(": ", idx1);
                this.tagNr = headerLine.substring(0, idx1);
                this.tagName = headerLine.substring(idx1 + 2, idx2).trim();
                this.tagValue = headerLine.substring(idx2 + 2, headerLine.length()).trim();
            }
            catch (Exception e) {
                this.tagValue = headerLine;
            }
        } else {
            this.tagValue = headerLine;
        }
    }

    public HeaderTag(int tagNr) {
        this.tagNr = DicomHeader.toTagString(tagNr);
        this.tagName = DicomHeader.getHeaderName(tagNr);
        this.tagType = DicomHeader.getHeaderFieldType(tagNr);
    }

    public HeaderTag(int tagNr, String tagValue) {
        this.tagNr = DicomHeader.toTagString(tagNr);
        this.tagName = DicomHeader.getHeaderName(tagNr);
        this.tagValue = tagValue;
        this.tagType = DicomHeader.getHeaderFieldType(tagNr);
    }

    public HeaderTag(String tagNr, String tagName, String tagValue) {
        this.tagNr = tagNr;
        this.tagName = tagName;
        if (tagName == null || tagName.equals("")) {
            this.tagName = DicomHeader.getHeaderName(tagNr);
        }
        if (this.tagName == null || this.tagName.equals("")) {
            this.tagName = this.tagNr;
        }
        this.tagValue = tagValue;
        this.tagType = DicomHeader.getHeaderFieldType(tagNr);
    }

    public HeaderTag(String tagNr, String tagName, String tagValue, String tagType) {
        this.tagNr = tagNr;
        this.tagName = tagName;
        if (tagName == null || tagName.equals("")) {
            this.tagName = DicomHeader.getHeaderName(tagNr);
        }
        this.tagValue = tagValue;
        this.tagType = tagType;
        if (tagType == null || tagType.equals("")) {
            this.tagType = DicomHeader.getHeaderFieldType(tagNr);
        }
    }

    public HeaderTag(String tagNr, String tagType, String tagName, String tagValue, int location, int length) {
        this.tagType = tagType;
        if (tagType == null || tagType.equals("")) {
            this.tagType = DicomHeader.getHeaderFieldType(tagNr);
        }
        this.tagNr = tagNr;
        this.tagName = tagName;
        if (tagName == null || tagName.equals("")) {
            this.tagName = DicomHeader.getHeaderName(tagNr);
        }
        if (tagValue != null) {
            this.tagValue = tagValue.replace('\u0000', ' ');
        }
        this.location = location;
        this.length = length;
    }

    public HeaderTag(DicomElement element, DicomObject dObj) {
        this.dicomElement = element;
        int tag = element.tag();
        this.tagNr = String.valueOf(StringUtils.shortToHex((int)(tag >> 16))) + ',' + StringUtils.shortToHex((int)tag);
        this.tagType = element.vr().toString();
        try {
            if (element.hasDicomObjects()) {
                int elemAnz = element.countItems();
                int i = 0;
                while (i < elemAnz) {
                    ++i;
                }
                this.tagValue = "";
            } else {
                this.tagValue = element.getString(dObj.getSpecificCharacterSet(), false);
                if (this.tagValue == null) {
                    this.tagValue = "";
                }
            }
            if (element.countItems() > 0 && this.tagValue.length() == 0) {
                this.tagValue = "[SEQUENCE with " + element.countItems() + " Subitems]";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tagName = DicomHeader.getHeaderName(this.tagNr);
    }

    public String toString() {
        return String.valueOf(this.tagNr) + " " + (this.tagType != "" ? "[" + this.tagType + "] " : "") + this.tagName + (this.tagValue != null ? ": " + this.tagValue : "");
    }

    public int getLength() {
        return this.length;
    }

    public int getLocation() {
        return this.location;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getTagNr() {
        return this.tagNr;
    }

    public void setTagNr(String tagNr) {
        this.tagNr = tagNr;
    }

    public String getTagVR() {
        return this.tagType;
    }

    public void setTagType(String tagType) {
        this.tagType = tagType;
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public void setTagValue(String tagValue) {
        this.tagValue = tagValue;
    }

    public int getTagInt() throws DicomHeaderParseException {
        return DicomHeader.toTagInt(this.tagNr);
    }

    public static Vector<HeaderTag> getAllTags() {
        if (allTags == null) {
            allTags = new Vector();
            Field[] fields = Tag.class.getFields();
            BasicDicomObject de = new BasicDicomObject();
            int i = 0;
            while (i < fields.length) {
                String name = fields[i].getName();
                int tag = Tag.forName((String)name);
                String tagNr = DicomHeader.toTagString(tag);
                try {
                    allTags.add(new HeaderTag(tagNr, name, null, "" + de.vrOf(tag)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        return allTags;
    }

    public static Vector<HeaderTag> loadTags(String fileName) {
        return HeaderTag.loadTags(new File(fileName));
    }

    public static Vector<HeaderTag> loadTags(File file) {
        try {
            return HeaderTag.loadTags(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            System.err.println("unable to load tags from file: " + file);
            return new Vector<HeaderTag>();
        }
    }

    public static Vector<HeaderTag> loadTags(InputStream in) {
        Properties tags = new Properties();
        try {
            tags.load(in);
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
        Vector<HeaderTag> headerTags = new Vector<HeaderTag>();
        TreeSet<Object> set = new TreeSet<Object>(tags.keySet());
        for (String string : set) {
            headerTags.add(new HeaderTag(string, null, (String)tags.get(string)));
        }
        return headerTags;
    }

    public static void saveTags(String fileName, Vector<HeaderTag> headerTags) {
        HeaderTag.saveTags(new File(fileName), headerTags);
    }

    public static void saveTags(File file, Vector<HeaderTag> headerTags) {
        try {
            HeaderTag.saveTags(new FileOutputStream(file), headerTags);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void saveTags(OutputStream out, Vector<HeaderTag> headerTags) {
        try {
            Properties pStore = new Properties();
            for (HeaderTag element : headerTags) {
                if (element.getTagValue() == null) {
                    pStore.put(element.getTagNr(), "");
                    continue;
                }
                pStore.put(element.getTagNr(), element.getTagValue());
            }
            pStore.store(out, "");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int tagValuetoInt(String tag) {
        String[] tags = tag.split(",");
        String intString = "0x" + tags[0] + tags[1];
        return Integer.parseInt(intString, 16);
    }

    public static void main(String[] args) {
        Field[] fields = Tag.class.getFields();
        BasicDicomObject de = new BasicDicomObject();
        int i = 0;
        while (i < fields.length) {
            String name = fields[i].getName();
            int tag = Tag.forName((String)name);
            String tagNr = DicomHeader.toTagString(tag);
            de.vrOf(tag);
            System.out.println(String.valueOf(tagNr) + "; " + de.vrOf(tag) + "; " + name);
            ++i;
        }
    }
}

