/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.StructuredReportTreeBrowser;
import com.pixelmed.dicom.XMLRepresentationOfStructuredReportObjectFactory;
import com.pixelmed.dose.CTDose;
import ij.plugin.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.i18n.Translatrix;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class SRDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)SRDialog.class.getName());
    private JTabbedPane tabbedPane;
    private JButton closeButton;
    private Vector<AttributeList> lists = new Vector();
    private JButton viewDoseHTMLButton;
    private Component owner;
    private JButton viewXMLButton;

    public SRDialog() {
        this.buildDialog();
    }

    public SRDialog(JFrame owner) {
        super(owner);
        this.owner = owner;
        this.buildDialog();
    }

    public SRDialog(JDialog owner) {
        super(owner);
        this.owner = owner;
        this.buildDialog();
    }

    private void buildDialog() {
        this.setTitle("DICOM SR Viewer");
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof JTabbedPane) {
                    JTabbedPane pane = (JTabbedPane)e.getSource();
                    int index = SRDialog.this.tabbedPane.getSelectedIndex();
                    SRDialog.this.tabSelected(index);
                }
            }
        });
        ButtonBarBuilder bb = new ButtonBarBuilder();
        this.viewXMLButton = new JButton("View as XML");
        this.viewXMLButton.addActionListener(this);
        bb.addGridded((JComponent)this.viewXMLButton);
        bb.addRelatedGap();
        this.viewDoseHTMLButton = new JButton("DoseSR as HTML");
        this.viewDoseHTMLButton.addActionListener(this);
        bb.addGridded((JComponent)this.viewDoseHTMLButton);
        bb.addGlue();
        this.closeButton = new JButton(Translatrix.getTranslationString((String)"dicom.close"));
        this.closeButton.addActionListener(this);
        bb.addGridded((JComponent)this.closeButton);
        this.add((Component)bb.getPanel(), "South");
        this.setSize(800, 700);
        if (this.owner != null) {
            this.setLocationRelativeTo(this.owner);
        }
    }

    protected void tabSelected(int index) {
        try {
            AttributeList list = this.lists.get(index);
            CTDose ctDose = new CTDose(list);
            this.viewDoseHTMLButton.setEnabled(true);
        }
        catch (Exception e2) {
            this.viewDoseHTMLButton.setEnabled(false);
        }
    }

    public void showReports(File[] sRs) {
        this.tabbedPane.removeAll();
        this.lists.clear();
        if (sRs == null || sRs.length == 0) {
            return;
        }
        File[] fileArray = sRs;
        int n = sRs.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            AttributeList list = this.readSR(file);
            if (list != null) {
                try {
                    DicomHeader dh = new DicomHeader(file);
                    String title = "<html>" + dh.getHeaderStringValue(0x100010) + "<br>" + dh.getHeaderStringValue(524296) + "<br>" + dh.getHeaderDateValue(524321) + " /" + dh.getHeaderStringValue(2097171);
                    JScrollPane scrollPane = new JScrollPane();
                    new StructuredReportTreeBrowser(list, scrollPane);
                    this.tabbedPane.add(title, scrollPane);
                    this.lists.add(list);
                }
                catch (Exception e) {
                    logger.error((Object)"Error showing SR", (Throwable)e);
                }
            }
            ++n2;
        }
        this.tabbedPane.setSelectedIndex(0);
        this.tabSelected(0);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block12: {
            if (e.getSource().equals(this.closeButton)) {
                this.tabbedPane.removeAll();
                this.lists.clear();
                this.setVisible(false);
            } else if (e.getSource().equals(this.viewDoseHTMLButton)) {
                try {
                    int index = this.tabbedPane.getSelectedIndex();
                    if (index < 0) break block12;
                    AttributeList list = this.lists.get(index);
                    CTDose ctDose = new CTDose(list);
                    String doseHTML = "<html>" + ctDose.getHTMLTableRow(true);
                    JDialog dialog = new JDialog((Dialog)this, "HTML Dose-SR View");
                    JEditorPane editorPane = new JEditorPane();
                    editorPane.setEditable(false);
                    editorPane.setContentType("text/html");
                    editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                    editorPane.setText(doseHTML);
                    JScrollPane editorScrollPane = new JScrollPane(editorPane);
                    dialog.getContentPane().add(editorScrollPane);
                    dialog.setDefaultCloseOperation(2);
                    double width = 800.0;
                    try {
                        width = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    dialog.setSize((int)width, 400);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    logger.error((Object)"Error showing SR as HTML", (Throwable)e2);
                }
            } else if (e.getSource().equals(this.viewXMLButton)) {
                try {
                    int index = this.tabbedPane.getSelectedIndex();
                    if (index >= 0) {
                        AttributeList list = this.lists.get(index);
                        StructuredReport sr = new StructuredReport(list);
                        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(sr, list);
                        File f = File.createTempFile("dicom_sr_", ".xml");
                        f.deleteOnExit();
                        FileOutputStream fout = new FileOutputStream(f);
                        SRDialog.write(fout, document);
                        BrowserLauncher.openURL((String)f.getAbsolutePath());
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    logger.error((Object)"Error showing SR as HTML", (Throwable)e2);
                }
            }
        }
    }

    private AttributeList readSR(File file) {
        try {
            AttributeList list = new AttributeList();
            list.read(file);
            return list;
        }
        catch (Exception e) {
            logger.error((Object)"Error parsing SR", (Throwable)e);
            return null;
        }
    }

    public static void write(OutputStream out, Document document) throws IOException, TransformerConfigurationException, TransformerException {
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(out);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        Properties outputProperties = new Properties();
        outputProperties.setProperty("method", "html");
        outputProperties.setProperty("indent", "yes");
        outputProperties.setProperty("encoding", "UTF-8");
        transformer.setOutputProperties(outputProperties);
        transformer.transform(source, result);
    }

    public static void main(String[] args) {
        File[] sRs = new File[]{new File("/media/daten/DICOM/DICOM_Images/Zitha DoseSR/dicom/13022015/08290000/03867043"), new File("/media/daten/DICOM/DICOM_Images/Zitha DoseSR/dicom/13022015/08290000/03864904"), new File("/media/daten/DICOM/DICOM_Images/SR/srdoc103/report03.dcm")};
        new SRDialog(new JFrame()).showReports(sRs);
    }
}

