/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.header.filter;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import lu.tudor.santec.dicom.gui.DicomFileDialog;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.dicom.gui.header.TagListener;
import lu.tudor.santec.dicom.gui.header.TagSearchPanel;
import lu.tudor.santec.dicom.gui.header.filter.TagFilterPanel;
import lu.tudor.santec.i18n.SwingLocalizer;
import lu.tudor.santec.i18n.Translatrix;

public class TagFilterDialog
extends JDialog
implements ActionListener,
TagListener {
    private static final long serialVersionUID = 1L;
    private JPanel mainPanel;
    private TagFilterPanel filterTagPanel;
    private JButton closeButton;
    private JButton saveButton;
    private Component parent;
    private JButton saveAndAddButton;
    private boolean addNext;
    private TagSearchPanel tagSearchPanel;
    private HeaderTag ht;
    private DicomFileDialog dicomChooser;

    public TagFilterDialog(JFrame parent) {
        super((Frame)parent, true);
        this.parent = parent;
        this.initDialog();
        this.setLocationRelativeTo(parent);
    }

    public TagFilterDialog(JDialog parent, DicomFileDialog dicomChooser) {
        super((Dialog)parent, true);
        this.parent = parent;
        this.dicomChooser = dicomChooser;
        this.initDialog();
        this.setLocationRelativeTo(parent);
    }

    public TagFilterDialog() {
        this.initDialog();
    }

    private void initDialog() {
        this.setTitle(Translatrix.getTranslationString((String)"FilterTagDialog.title"));
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel((LayoutManager)new FormLayout("fill:200dlu, 5dlu, pref:grow, 5dlu", "pref, 3dlu, top:200dlu:grow"));
        CellConstraints cc = new CellConstraints();
        this.tagSearchPanel = new TagSearchPanel(this, this.dicomChooser);
        this.tagSearchPanel.addTagListener(this);
        this.mainPanel.add((Component)this.tagSearchPanel, cc.xy(1, 3));
        this.filterTagPanel = new TagFilterPanel();
        this.mainPanel.add((Component)this.filterTagPanel, cc.xy(3, 3));
        this.add((Component)this.mainPanel, "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        this.closeButton = new JButton(Translatrix.getTranslationString((String)"dicom.Cancel"));
        this.closeButton.addActionListener(this);
        bb.addGridded((JComponent)this.closeButton);
        bb.addRelatedGap();
        this.saveButton = new JButton(Translatrix.getTranslationString((String)"dicom.Save"));
        this.saveButton.addActionListener(this);
        bb.addGridded((JComponent)this.saveButton);
        this.saveAndAddButton = new JButton(Translatrix.getTranslationString((String)"dicom.SaveAndAdd"));
        this.saveAndAddButton.addActionListener(this);
        bb.addFixed((JComponent)this.saveAndAddButton);
        this.add((Component)bb.getPanel(), "South");
        this.pack();
    }

    public HeaderTag selectTag(HeaderTag ht) {
        this.tagSearchPanel.setTag(ht);
        this.filterTagPanel.setHeaderTag(ht);
        if (this.parent != null) {
            this.setLocationRelativeTo(this.parent);
        }
        this.addNext = false;
        this.setVisible(true);
        return this.ht;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.saveButton)) {
            this.ht = this.filterTagPanel.getTag();
        } else if (e.getSource().equals(this.saveAndAddButton)) {
            this.ht = this.filterTagPanel.getTag();
            this.addNext = true;
        }
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            Translatrix.addBundle((String)"lu.tudor.santec.settings.resources.WidgetResources");
            Translatrix.addBundle((String)"lu.tudor.santec.dicom.gui.resources.WidgetResources");
            Translatrix.addBundle((String)SwingLocalizer.getBundle());
            Translatrix.setDefaultWhenMissing((boolean)true);
            SwingLocalizer.localizeJFileChooser();
            SwingLocalizer.localizeJOptionPane();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new TagFilterDialog().selectTag(null);
    }

    public boolean isAddNext() {
        return this.addNext;
    }

    @Override
    public void tagChanged(HeaderTag tag) {
        this.ht = tag;
        System.out.println("tagchanged: " + tag);
        this.filterTagPanel.setHeaderTag(tag);
    }
}

