/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.query;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.header.DicomHeaderParseException;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.dicom.gui.query.FilterPanel;
import org.apache.log4j.Logger;

public class FilterField
extends JPanel
implements ItemListener,
ActionListener,
PropertyChangeListener {
    private static Logger logger = Logger.getLogger((String)FilterField.class.getName());
    private static final long serialVersionUID = 1L;
    public static final LinkedHashSet<String> OPERATORS = new LinkedHashSet();
    public static final String DEFAULT = "DEFAULT";
    public static final String DELIM = "#";
    private JComboBox columnChooser;
    private JLabel operator1;
    private JTextField value1;
    private JLabel groupOperator;
    private JButton addButton;
    private JButton deleteButton;
    private FilterPanel panel;
    private static FormLayout layout;
    private static CellConstraints cc;

    static {
        OPERATORS.add("=");
        cc = new CellConstraints();
    }

    public FilterField(FilterPanel panel, boolean isFirst) {
        this.panel = panel;
        if (layout == null) {
            layout = new FormLayout("25dlu, 2dlu, pref, 2dlu, pref, 2dlu, fill:pref:grow, 2dlu, pref, 2dlu", "fill:pref");
        }
        this.setLayout((LayoutManager)layout);
        try {
            if (!isFirst) {
                this.groupOperator = new JLabel("AND");
                this.add((Component)this.groupOperator, cc.xy(1, 1));
            } else {
                this.add((Component)new JLabel("WHERE"), cc.xy(1, 1));
            }
            this.columnChooser = new JComboBox();
            this.columnChooser.addItemListener(this);
            this.add((Component)this.columnChooser, cc.xy(3, 1));
            this.operator1 = new JLabel("=");
            this.add((Component)this.operator1, cc.xy(5, 1));
            this.value1 = new JTextField();
            this.value1.addPropertyChangeListener(this);
            this.add((Component)this.value1, cc.xy(7, 1));
            if (isFirst) {
                this.addButton = new JButton(DicomIcons.getIcon16("filter_add.png"));
                this.addButton.addActionListener(this);
                this.add((Component)this.addButton, cc.xy(9, 1));
            } else {
                this.deleteButton = new JButton(DicomIcons.getIcon16("filter_remove.png"));
                this.deleteButton.addActionListener(this);
                this.add((Component)this.deleteButton, cc.xy(9, 1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setKeys(List<HeaderTag> keys) {
        this.columnChooser.removeAllItems();
        if (keys != null) {
            for (HeaderTag col : keys) {
                this.columnChooser.addItem(col);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.columnChooser)) {
            HeaderTag column = (HeaderTag)this.columnChooser.getSelectedItem();
            try {
                this.remove(this.value1);
                this.value1 = new JTextField();
                this.value1.addPropertyChangeListener(this);
                this.add((Component)this.value1, cc.xy(7, 1));
                this.validate();
                this.repaint();
            }
            catch (Exception e2) {
                logger.error((Object)("Error creating fields for " + column));
            }
        }
    }

    public String getFilter() {
        StringBuffer sb = new StringBuffer();
        if (this.groupOperator != null) {
            sb.append(this.groupOperator.getText());
        } else {
            sb.append("WHERE");
        }
        sb.append(DELIM);
        sb.append(this.columnChooser.getSelectedItem());
        sb.append(DELIM);
        sb.append(this.operator1.getText());
        sb.append(DELIM);
        try {
            sb.append(this.value1.getText());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public HeaderTag getFilterTag() throws DicomHeaderParseException {
        return new HeaderTag(((HeaderTag)this.columnChooser.getSelectedItem()).getTagInt(), String.valueOf(this.value1.getText()) + "*");
    }

    public void setFilter(String filter) {
        String[] strings = filter.split(DELIM);
        if (strings.length == 6) {
            if (this.groupOperator != null) {
                this.groupOperator.setText(strings[0]);
            }
            this.columnChooser.setSelectedItem(strings[1]);
            try {
                this.value1.setText(strings[3]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String printFilter() {
        return FilterField.printFilter(this.getFilter());
    }

    public static String printFilter(String filter) {
        StringBuffer sb = new StringBuffer();
        String[] strings = filter.split(DELIM);
        if (strings.length == 6) {
            if (strings[0] != null) {
                sb.append(strings[0]);
            } else {
                sb.append("WHERE");
            }
            sb.append(" (");
            if (strings[3] != null && strings[3].length() > 0 && !"null".equals(strings[3])) {
                sb.append(strings[1]).append(strings[2]).append(strings[3]);
            }
            if (strings[5] != null && strings[5].length() > 0 && !"null".equals(strings[5])) {
                sb.append(" AND ");
                sb.append(strings[1]).append(strings[4]).append(strings[5]);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.addButton) && this.panel != null) {
            this.panel.addItem(this);
        } else if (e.getSource().equals(this.deleteButton) && this.panel != null) {
            this.panel.removeItem(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

