/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.query;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import lu.tudor.santec.i18n.Translatrix;
import org.dcm4che2.data.DicomObject;

public class QueryPatientTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private DateFormat df = new SimpleDateFormat("yyyy.MM.dd");
    private String[] columns = new String[]{Translatrix.getTranslationString((String)"dicom.PatientName"), Translatrix.getTranslationString((String)"dicom.PatientID"), Translatrix.getTranslationString((String)"dicom.PatientBirthdate"), Translatrix.getTranslationString((String)"dicom.PatientSex")};
    private Vector patients = new Vector();

    @Override
    public int getRowCount() {
        return this.patients.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DicomObject dr = (DicomObject)this.patients.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                try {
                    return dr.getString(0x100010).replaceAll("\\^", ",");
                }
                catch (Exception e) {
                    return "";
                }
            }
            case 1: {
                return dr.getString(0x100020);
            }
            case 2: {
                try {
                    return this.df.format(dr.getDate(0x100030));
                }
                catch (Exception e) {
                    return dr.getString(0x100030);
                }
            }
            case 3: {
                return dr.getString(0x100040);
            }
        }
        return null;
    }

    public void setPatients(Vector patients) {
        this.patients = patients;
        this.fireTableDataChanged();
    }

    public DicomObject getDimse(int line) {
        try {
            return (DicomObject)this.patients.get(line);
        }
        catch (Exception e) {
            return null;
        }
    }
}

