/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.query;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lu.tudor.santec.dicom.gui.DICOMSettingsPlugin;
import lu.tudor.santec.dicom.gui.DicomURLChooser;
import lu.tudor.santec.dicom.gui.ErrorDialog;
import lu.tudor.santec.dicom.gui.TableSorter;
import lu.tudor.santec.dicom.gui.dicomdir.DICOMDIRVIEW;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.dicom.gui.query.QueryPatientTableModel;
import lu.tudor.santec.dicom.gui.query.QuerySeriesTableModel;
import lu.tudor.santec.dicom.gui.query.QueryStudyTableModel;
import lu.tudor.santec.dicom.query.DcmQR;
import lu.tudor.santec.dicom.query.DicomQuery;
import lu.tudor.santec.i18n.Translatrix;
import org.apache.log4j.Logger;
import org.dcm4che.util.DcmURL;
import org.dcm4che2.data.DicomObject;

public class QuerySearchPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    public DicomQuery dq;
    private DICOMDIRVIEW parent;
    private JTable patientTable;
    private JTable studyTable;
    private JTable seriesTable;
    private QueryPatientTableModel patientTableModel;
    private QueryStudyTableModel studyTableModel;
    private QuerySeriesTableModel seriesTableModel;
    private JButton cancelButton = new JButton();
    private ButtonBarBuilder bbuilder;
    private DcmURL url;
    private DcmURL[] senders;
    private TableSorter patientTableSorter;
    private TableSorter studyTableSorter;
    private TableSorter seriesTableSorter;
    private String moveAET;
    private JButton movelocalButton;
    private DcmURL localDest;
    private String wantedModality;
    private DcmURL moveUrl;
    private TitledBorder patientTableBorder;
    private TitledBorder studyTableBorder;
    private TitledBorder seriesTableBorder;
    private JCheckBox openButton;
    private boolean firstrun = true;
    public static final String[] MODALITIES = new String[]{"", "CR", "DR", "MG", "CT", "MR", "NM", "PT", "RF", "SR", "EPS", "US", "DX", "ECG", "ES", "XC", "GM", "HD", "IO", "IVUS", "PX", "RG", "RTIMAGE", "SM", "XA"};
    private static Logger logger = Logger.getLogger((String)"lu.tudor.santec.dicom.gui.DicomDirSearchPanel");

    public QuerySearchPanel(DICOMDIRVIEW parent, DcmURL url, boolean openOnReceive) {
        this.parent = parent;
        this.url = url;
        CellConstraints cc = new CellConstraints();
        FormLayout fl = new FormLayout("6dlu, fill:100dlu:grow, 6dlu", "6dlu, fill:80dlu:grow, 4dlu, 80dlu, 4dlu, 80dlu, 4dlu, pref, 6dlu");
        this.setLayout((LayoutManager)fl);
        this.dq = new DicomQuery(url);
        Color bgColor = new JTextField().getBackground();
        this.patientTableModel = new QueryPatientTableModel();
        this.patientTableSorter = new TableSorter(this.patientTableModel);
        this.patientTable = new JTable(this.patientTableSorter){
            private static final long serialVersionUID = 1L;

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                if (row == -1 || column == -1) {
                    return;
                }
                if (this.getSelectedRow() == row) {
                    toggle = true;
                }
                super.changeSelection(row, column, toggle, extend);
            }
        };
        this.patientTableSorter.setTableHeader(this.patientTable.getTableHeader());
        this.patientTable.setRowSelectionAllowed(true);
        this.patientTable.setColumnSelectionAllowed(false);
        this.patientTable.addMouseListener(this);
        this.setTableFocusKey(this.patientTable);
        this.patientTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane jsp0 = new JScrollPane(this.patientTable);
        jsp0.setFocusCycleRoot(false);
        this.patientTableBorder = new TitledBorder(String.valueOf(Translatrix.getTranslationString((String)"dicom.Patients")) + ":");
        jsp0.setBorder(this.patientTableBorder);
        jsp0.getViewport().setBackground(bgColor);
        this.patientTable.getColumnModel().getColumn(3).setMaxWidth(30);
        this.patientTable.getColumnModel().getColumn(2).setMaxWidth(100);
        this.patientTable.requestFocus();
        this.add((Component)jsp0, cc.xyw(2, 2, 1));
        this.studyTableModel = new QueryStudyTableModel();
        this.studyTableSorter = new TableSorter(this.studyTableModel);
        this.studyTable = new JTable(this.studyTableSorter){
            private static final long serialVersionUID = 1L;

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                if (row == -1 || column == -1) {
                    return;
                }
                if (this.getSelectedRow() == row) {
                    toggle = true;
                }
                super.changeSelection(row, column, toggle, extend);
            }
        };
        this.studyTableSorter.setTableHeader(this.studyTable.getTableHeader());
        this.studyTable.setRowSelectionAllowed(true);
        this.studyTable.setColumnSelectionAllowed(false);
        this.studyTable.addMouseListener(this);
        this.setTableFocusKey(this.studyTable);
        this.studyTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane jsp1 = new JScrollPane(this.studyTable);
        jsp1.setFocusCycleRoot(false);
        this.studyTableBorder = new TitledBorder(String.valueOf(Translatrix.getTranslationString((String)"dicom.Studies")) + ":");
        jsp1.setBorder(this.studyTableBorder);
        jsp1.getViewport().setBackground(bgColor);
        this.add((Component)jsp1, cc.xyw(2, 4, 1));
        this.studyTable.getColumnModel().getColumn(3).setMaxWidth(100);
        this.studyTable.getColumnModel().getColumn(4).setMaxWidth(90);
        this.seriesTableModel = new QuerySeriesTableModel();
        this.seriesTableSorter = new TableSorter(this.seriesTableModel);
        this.seriesTable = new JTable(this.seriesTableSorter){
            private static final long serialVersionUID = 1L;

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                if (row == -1 || column == -1) {
                    return;
                }
                if (this.getSelectedRow() == row) {
                    toggle = true;
                }
                super.changeSelection(row, column, toggle, extend);
            }
        };
        this.seriesTableSorter.setTableHeader(this.seriesTable.getTableHeader());
        this.seriesTable.getColumnModel().getColumn(0).setMaxWidth(40);
        this.seriesTable.getColumnModel().getColumn(1).setMaxWidth(60);
        this.seriesTable.getColumnModel().getColumn(4).setMaxWidth(40);
        this.seriesTable.setRowSelectionAllowed(true);
        this.seriesTable.setColumnSelectionAllowed(false);
        this.seriesTable.addMouseListener(this);
        this.setTableFocusKey(this.seriesTable);
        this.seriesTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane jsp2 = new JScrollPane(this.seriesTable);
        this.seriesTableBorder = new TitledBorder(String.valueOf(Translatrix.getTranslationString((String)"dicom.Series")) + ":");
        jsp2.setBorder(this.seriesTableBorder);
        jsp2.getViewport().setBackground(bgColor);
        this.add((Component)jsp2, cc.xyw(2, 6, 1));
        this.bbuilder = new ButtonBarBuilder();
        this.openButton = new JCheckBox(Translatrix.getTranslationString((String)"dicom.OpenOnReceive"));
        this.openButton.setSelected(openOnReceive);
        this.openButton.addActionListener(this);
        this.bbuilder.addFixed((JComponent)this.openButton);
        this.bbuilder.addGlue();
        this.bbuilder.addRelatedGap();
        this.movelocalButton = new JButton(Translatrix.getTranslationString((String)"dicom.MoveLocal"));
        this.movelocalButton.setEnabled(false);
        this.movelocalButton.addActionListener(this);
        this.bbuilder.addGridded((JComponent)this.movelocalButton);
        this.bbuilder.addRelatedGap();
        this.cancelButton = new JButton(Translatrix.getTranslationString((String)"dicom.Cancel"));
        this.cancelButton.addActionListener(this);
        this.bbuilder.addGridded((JComponent)this.cancelButton);
        this.add((Component)this.bbuilder.getPanel(), cc.xyw(2, 8, 1));
    }

    public void query(Vector<HeaderTag> filters, DcmQR.QueryRetrieveLevel level) {
        this.parent.getParentDialog().setWaitCursor(true);
        try {
            String retVal;
            if (this.firstrun && (retVal = DICOMSettingsPlugin.testPACS("PACS", this, this.url)) != null) {
                logger.warn((Object)("Error connecting to PACS " + retVal));
                this.parent.getParentDialog().setWaitCursor(false);
                return;
            }
            this.firstrun = false;
            this.dq = new DicomQuery(this.url);
            logger.info((Object)("Query for " + (Object)((Object)level) + " with keys:\n" + filters));
            if (level.equals((Object)DcmQR.QueryRetrieveLevel.PATIENT)) {
                this.patientTableModel.setPatients(this.dq.query(filters, level));
                this.studyTableModel.setStudies(new Vector<DicomObject>());
            } else if (level.equals((Object)DcmQR.QueryRetrieveLevel.STUDY)) {
                this.patientTableModel.setPatients(new Vector());
                this.studyTableModel.setStudies(this.dq.query(filters, level));
            }
            this.seriesTableModel.setSeries(new Vector());
            this.patientTableBorder.setTitle(String.valueOf(Translatrix.getTranslationString((String)"dicom.Patients")) + ": [" + this.patientTableModel.getRowCount() + "]");
            this.studyTableBorder.setTitle(String.valueOf(Translatrix.getTranslationString((String)"dicom.Studies")) + ": [" + this.studyTableModel.getRowCount() + "]");
            this.seriesTableBorder.setTitle(String.valueOf(Translatrix.getTranslationString((String)"dicom.Series")) + ": [" + this.seriesTableModel.getRowCount() + "]");
        }
        catch (Exception e1) {
            ErrorDialog.showErrorDialog((JDialog)this.parent.getParentDialog(), "Error running DICOM QUERY", String.valueOf(e1.getLocalizedMessage()), (Throwable)e1);
            logger.warn((Object)"error updating dicom view");
            this.parent.getParentDialog().setWaitCursor(false);
        }
        this.movelocalButton.setEnabled(false);
        this.parent.getParentDialog().setWaitCursor(false);
    }

    public static List<DcmQR.QueryRetrieveLevel> getQueryLevels() {
        ArrayList<DcmQR.QueryRetrieveLevel> keys = new ArrayList<DcmQR.QueryRetrieveLevel>();
        keys.add(DcmQR.QueryRetrieveLevel.PATIENT);
        keys.add(DcmQR.QueryRetrieveLevel.STUDY);
        return keys;
    }

    public static List<HeaderTag> getQueryFields(DcmQR.QueryRetrieveLevel level) {
        ArrayList<HeaderTag> keys;
        block3: {
            block2: {
                keys = new ArrayList<HeaderTag>();
                if (!level.equals((Object)DcmQR.QueryRetrieveLevel.PATIENT)) break block2;
                int[] nArray = DcmQR.PATIENT_MATCHING_KEYS;
                int n = DcmQR.PATIENT_MATCHING_KEYS.length;
                int n2 = 0;
                while (n2 < n) {
                    int matchKey = nArray[n2];
                    keys.add(new HeaderTag(matchKey));
                    ++n2;
                }
                break block3;
            }
            if (!level.equals((Object)DcmQR.QueryRetrieveLevel.STUDY)) break block3;
            int[] nArray = DcmQR.PATIENT_STUDY_MATCHING_KEYS;
            int n = DcmQR.PATIENT_STUDY_MATCHING_KEYS.length;
            int n3 = 0;
            while (n3 < n) {
                int matchKey = nArray[n3];
                keys.add(new HeaderTag(matchKey));
                ++n3;
            }
        }
        return keys;
    }

    public void query(int searchTag, String searchString, String wantedModality) {
        this.wantedModality = wantedModality;
        this.parent.getParentDialog().setWaitCursor(true);
        try {
            this.dq = new DicomQuery(this.url);
            this.patientTableModel.setPatients(this.dq.queryPatients(searchTag, searchString));
            this.studyTableModel.setStudies(new Vector<DicomObject>());
            this.seriesTableModel.setSeries(new Vector());
            this.patientTableBorder.setTitle(String.valueOf(Translatrix.getTranslationString((String)"dicom.Patients")) + ": [" + this.patientTableModel.getRowCount() + "]");
            this.studyTableBorder.setTitle(String.valueOf(Translatrix.getTranslationString((String)"dicom.Studies")) + ": [" + this.studyTableModel.getRowCount() + "]");
            this.seriesTableBorder.setTitle(String.valueOf(Translatrix.getTranslationString((String)"dicom.Series")) + ": [" + this.seriesTableModel.getRowCount() + "]");
        }
        catch (Exception e1) {
            ErrorDialog.showErrorDialog((JDialog)this.parent.getParentDialog(), "Error running DICOM QUERY", String.valueOf(e1.getLocalizedMessage()), (Throwable)e1);
            logger.warn((Object)"error updating dicom view");
            this.parent.getParentDialog().setWaitCursor(false);
        }
        this.movelocalButton.setEnabled(false);
        this.parent.getParentDialog().setWaitCursor(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.parent.getParentDialog().pacsPanel != null) {
            this.parent.getParentDialog().pacsPanel.setServerStatus(3);
        }
        if (e.getSource().equals(this.cancelButton)) {
            this.cancel();
        } else if (e.getSource().equals(this.movelocalButton)) {
            if (this.parent.getParentDialog().pacsPanel == null) {
                JOptionPane.showMessageDialog(this, "Local DICOM Store is not activated", "MOVE Error", 0);
                logger.warn((Object)"Local DICOM Store is not activated");
                return;
            }
            DcmURL url = new DcmURL("dicom://" + this.parent.getParentDialog().pacsPanel.AET + "@" + DICOMSettingsPlugin.getIP() + ":" + this.parent.getParentDialog().pacsPanel.port);
            String retVal = DICOMSettingsPlugin.testPACS("LOCAL DICOM STORE", this, url);
            if (retVal != null) {
                logger.warn((Object)retVal);
                return;
            }
            this.moveTo(this.localDest);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.parent.getParentDialog().pacsPanel != null) {
            this.parent.getParentDialog().pacsPanel.setServerStatus(3);
        }
        this.parent.getParentDialog().setWaitCursor(true);
        if (e.getSource().equals(this.patientTable.getSelectionModel())) {
            this.selectPatient();
        } else if (e.getSource().equals(this.studyTable.getSelectionModel())) {
            this.selectStudy();
        } else if (e.getSource().equals(this.seriesTable.getSelectionModel())) {
            this.selectSeries();
        }
        this.parent.getParentDialog().setWaitCursor(false);
    }

    private void setTableFocusKey(JTable table) {
        Set<AWTKeyStroke> keys = table.getFocusTraversalKeys(0);
        keys = new HashSet<AWTKeyStroke>(keys);
        keys.add(KeyStroke.getKeyStroke("TAB"));
        table.setFocusTraversalKeys(0, keys);
        keys = table.getFocusTraversalKeys(1);
        keys = new HashSet<AWTKeyStroke>(keys);
        keys.add(KeyStroke.getKeyStroke("shift TAB"));
        table.setFocusTraversalKeys(1, keys);
    }

    public void moveTo(DcmURL p_url) {
        this.moveUrl = p_url;
        if (this.moveUrl == null) {
            this.moveUrl = DicomURLChooser.showDialog(this.parent.getParentDialog(), this.senders);
        }
        if (this.moveUrl == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                QuerySearchPanel.this.moveAET = QuerySearchPanel.this.moveUrl.getCalledAET();
                QuerySearchPanel.this.parent.getParentDialog().setWaitCursor(true);
                if (QuerySearchPanel.this.seriesTable.getSelectedRow() != -1) {
                    try {
                        QuerySearchPanel.this.dq = new DicomQuery(QuerySearchPanel.this.url);
                        int[] rows = QuerySearchPanel.this.seriesTable.getSelectedRows();
                        int i = 0;
                        while (i < rows.length) {
                            DicomObject series = QuerySearchPanel.this.seriesTableModel.getDimse(QuerySearchPanel.this.seriesTableSorter.modelIndex(rows[i]));
                            QuerySearchPanel.this.dq.moveSeries(QuerySearchPanel.this, QuerySearchPanel.this.moveAET, series);
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        ErrorDialog.showErrorDialog((JDialog)QuerySearchPanel.this.parent.getParentDialog(), "Error on DICOM MOVE", e.getLocalizedMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                } else if (QuerySearchPanel.this.studyTable.getSelectedRow() != -1) {
                    try {
                        QuerySearchPanel.this.dq = new DicomQuery(QuerySearchPanel.this.url);
                        int[] rows = QuerySearchPanel.this.studyTable.getSelectedRows();
                        int i = 0;
                        while (i < rows.length) {
                            DicomObject series = QuerySearchPanel.this.studyTableModel.getDimse(QuerySearchPanel.this.studyTableSorter.modelIndex(rows[i]));
                            QuerySearchPanel.this.dq.moveStudies(QuerySearchPanel.this, QuerySearchPanel.this.moveAET, series);
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        ErrorDialog.showErrorDialog((JDialog)QuerySearchPanel.this.parent.getParentDialog(), "Error on DICOM MOVE", e.getLocalizedMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                }
                QuerySearchPanel.this.parent.getParentDialog().setWaitCursor(false);
            }
        }.start();
    }

    public void cancel() {
        try {
            this.dq.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.parent.getParentDialog().setRetValue(1);
        this.parent.getParentDialog().setVisible(false);
        this.parent.getParentDialog().setWaitCursor(false);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        if (this.parent.getParentDialog().pacsPanel != null) {
            this.parent.getParentDialog().pacsPanel.setServerStatus(3);
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    private void selectPatient() {
        try {
            this.dq = new DicomQuery(this.url);
            if (this.patientTable.getSelectedRow() == -1) {
                return;
            }
            this.movelocalButton.setEnabled(false);
            this.studyTableModel.setStudies(this.dq.queryStudiesByPatient(this.patientTableModel.getDimse(this.patientTableSorter.modelIndex(this.patientTable.getSelectedRow()))));
            this.seriesTableModel.setSeries(new Vector());
            this.studyTableBorder.setTitle(String.valueOf(Translatrix.getTranslationString((String)"dicom.Studies")) + ": [" + this.studyTableModel.getRowCount() + "]");
            this.seriesTableBorder.setTitle(String.valueOf(Translatrix.getTranslationString((String)"dicom.Series")) + ": [" + this.seriesTableModel.getRowCount() + "]");
        }
        catch (Exception e1) {
            ErrorDialog.showErrorDialog((JDialog)this.parent.getParentDialog(), "Error on DICOM QUERY", String.valueOf(e1.getLocalizedMessage()), (Throwable)e1);
            logger.warn((Object)"error updating dicom view");
            this.parent.getParentDialog().setWaitCursor(false);
        }
    }

    private void selectStudy() {
        try {
            this.dq = new DicomQuery(this.url);
            if (this.studyTable.getSelectedRow() == -1) {
                return;
            }
            this.movelocalButton.setEnabled(true);
            this.seriesTableModel.setSeries(this.dq.querySeriesByStudy(this.studyTableModel.getDimse(this.studyTableSorter.modelIndex(this.studyTable.getSelectedRow())), this.wantedModality));
            this.seriesTableBorder.setTitle(String.valueOf(Translatrix.getTranslationString((String)"dicom.Series")) + ": [" + this.seriesTableModel.getRowCount() + "]");
        }
        catch (Exception e1) {
            ErrorDialog.showErrorDialog((JDialog)this.parent.getParentDialog(), "Error on DICOM QUERY", String.valueOf(e1.getLocalizedMessage()), (Throwable)e1);
            logger.warn((Object)"error updating dicom view");
            this.parent.getParentDialog().setWaitCursor(false);
        }
    }

    private void selectSeries() {
        try {
            this.dq = new DicomQuery(this.url);
            if (this.seriesTable.getSelectedRow() == -1) {
                return;
            }
            this.movelocalButton.setEnabled(true);
        }
        catch (Exception e1) {
            ErrorDialog.showErrorDialog((JDialog)this.parent.getParentDialog(), "Error on DICOM QUERY", String.valueOf(e1.getLocalizedMessage()), (Throwable)e1);
            logger.warn((Object)"error updating dicom view");
            this.parent.getParentDialog().setWaitCursor(false);
        }
    }

    public static void main(String[] args) {
        String url = "dicom://dicomserver";
        url = String.valueOf(url) + "@" + "localhost" + ":" + "5104";
        DcmURL dcmUrl = new DcmURL(url);
        JFrame frame = new JFrame();
        QuerySearchPanel qsPanel = new QuerySearchPanel(null, dcmUrl, true);
        frame.getContentPane().add(qsPanel);
        frame.setSize(600, 500);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public void setDicomSenders(DcmURL[] senders) {
        this.senders = senders;
    }

    public void setLocalDest(DcmURL localDest) {
        this.localDest = localDest;
    }

    public boolean isOpenOnReceive() {
        return this.openButton.isSelected();
    }
}

