/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.query;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import lu.tudor.santec.i18n.Translatrix;
import org.dcm4che2.data.DicomObject;

public class QueryStudyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private DateFormat df = new SimpleDateFormat("yyyy.MM.dd");
    private DateFormat tf = new SimpleDateFormat("HH:mm:ss");
    private String[] columns = new String[]{Translatrix.getTranslationString((String)"dicom.StudyDesc"), Translatrix.getTranslationString((String)"dicom.StudyID"), Translatrix.getTranslationString((String)"dicom.AccessionNumber"), Translatrix.getTranslationString((String)"dicom.Date"), Translatrix.getTranslationString((String)"dicom.Time")};
    private Vector studies = new Vector();

    @Override
    public int getRowCount() {
        return this.studies.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DicomObject ds;
        try {
            ds = (DicomObject)this.studies.get(rowIndex);
        }
        catch (Exception e) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                if (ds.getString(528432) != null) {
                    return ds.getString(528432);
                }
                return ds.getString(3293184);
            }
            case 1: {
                return ds.getString(0x200010);
            }
            case 2: {
                return ds.getString(524368);
            }
            case 3: {
                try {
                    return this.df.format(ds.getDate(524320));
                }
                catch (Exception e) {
                    return ds.getString(524320);
                }
            }
            case 4: {
                try {
                    return this.tf.format(ds.getDate(524336));
                }
                catch (Exception e) {
                    return ds.getString(524336);
                }
            }
        }
        return null;
    }

    public void setStudies(Vector<DicomObject> studies) {
        this.studies = studies;
        Collections.sort(this.studies, new Comparer());
        this.fireTableDataChanged();
    }

    public DicomObject getDimse(int line) {
        try {
            return (DicomObject)this.studies.get(line);
        }
        catch (Exception e) {
            return null;
        }
    }

    class Comparer
    implements Comparator {
        Comparer() {
        }

        public int compare(Object obj1, Object obj2) {
            DicomObject ds2;
            DicomObject ds1;
            block6: {
                block5: {
                    try {
                        ds1 = (DicomObject)obj1;
                        ds2 = (DicomObject)obj2;
                        if (!ds1.getDate(524320).before(ds2.getDate(524320))) break block5;
                        return 1;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return 0;
                    }
                }
                if (!ds1.getDate(524320).after(ds2.getDate(524320))) break block6;
                return -1;
            }
            if (ds1.getDate(524336).before(ds2.getDate(524336))) {
                return 1;
            }
            return -1;
        }
    }
}

