/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.selector;

import java.awt.Component;
import java.lang.reflect.Field;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import lu.tudor.santec.dicom.gui.AutoCompletion;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.Tag;

public class DicomTagCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    JComboBox cb = new JComboBox();

    public DicomTagCellEditor() {
        Field[] fields = Tag.class.getFields();
        BasicDicomObject de = new BasicDicomObject();
        int i = 0;
        while (i < fields.length) {
            String name = fields[i].getName();
            int tag = Tag.forName((String)name);
            String tagNr = DicomHeader.toTagString(tag);
            this.cb.addItem(tagNr);
            ++i;
        }
        this.cb.setEditable(true);
        AutoCompletion.enableWithFreeText(this.cb);
        this.cb.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String tagName = DicomHeader.getHeaderName((String)value);
                String text = "<html>" + value + "<br><span style=\"font-size:7px\">" + tagName + "</span>";
                JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
                c.setToolTipText(tagName);
                return c;
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this.cb.getSelectedItem();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.cb.setSelectedItem(value);
        return this.cb;
    }
}

