/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.selector;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import lu.tudor.santec.dicom.gui.DicomURLChooser;
import lu.tudor.santec.dicom.gui.ErrorDialog;
import lu.tudor.santec.dicom.gui.ImagePreviewDicom;
import lu.tudor.santec.dicom.gui.TableSorter;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.dicom.gui.selector.DicomFile;
import lu.tudor.santec.dicom.gui.selector.DicomMatcher;
import lu.tudor.santec.dicom.gui.selector.DicomTagCellEditor;
import lu.tudor.santec.dicom.gui.selector.DicomTagTableModel;
import lu.tudor.santec.dicom.gui.selector.FoundFilesTableModel;
import lu.tudor.santec.dicom.gui.selector.SelectorPanel;
import lu.tudor.santec.dicom.sender.DicomSender;
import lu.tudor.santec.i18n.Translatrix;
import org.dcm4che.util.DcmURL;

public class MatcherPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private JTable tagTable;
    private JTable resultTable;
    private SelectorPanel parent;
    private ImagePreviewDicom dicomImagePreview;
    private ButtonBarBuilder bbuilder;
    private JButton sendButton;
    private JButton movelocalButton;
    private JButton cancelButton;
    private FoundFilesTableModel resultTableModel;
    private DicomTagTableModel headerTableModel;
    private DicomMatcher dicomMatcher;
    private TableSorter resultTableSorter;
    private TableSorter tagTableSorter;
    private DcmURL[] senders;
    private DicomSender dicomSender;
    private ProgressMonitor progressMonitor;
    private DcmURL localDest;
    private JButton openButton;
    private JPopupMenu popup;
    private AbstractAction actionAddtag;
    private AbstractAction actionDeleteTag;

    public MatcherPanel(SelectorPanel panel, String[] dicomFields) {
        this.parent = panel;
        this.setLayout(new BorderLayout());
        this.dicomMatcher = new DicomMatcher(this);
        this.headerTableModel = new DicomTagTableModel();
        this.tagTableSorter = new TableSorter(this.headerTableModel);
        this.tagTable = new JTable(this.tagTableSorter);
        this.tagTable.addMouseListener(this);
        this.tagTableSorter.setTableHeader(this.tagTable.getTableHeader());
        this.tagTable.setRowHeight(30);
        this.tagTable.getColumnModel().getColumn(0).setMaxWidth(120);
        this.tagTable.getColumnModel().getColumn(0).setCellEditor(new DicomTagCellEditor());
        this.tagTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String tagName = DicomHeader.getHeaderName((String)value);
                String text = "<html>" + value + "<br><span style=\"font-size:7px\">" + tagName + "</span>";
                JLabel c = (JLabel)super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
                c.setToolTipText(tagName);
                return c;
            }
        });
        this.tagTable.getColumnModel().getColumn(1).setMaxWidth(120);
        JScrollPane jsp1 = new JScrollPane(this.tagTable);
        jsp1.addMouseListener(this);
        jsp1.setPreferredSize(new Dimension(240, 30));
        jsp1.setBorder(new TitledBorder(Translatrix.getTranslationString((String)"dicom.FilterTags")));
        this.add((Component)jsp1, "West");
        this.resultTableModel = new FoundFilesTableModel();
        this.resultTableSorter = new TableSorter(this.resultTableModel);
        this.resultTable = new JTable(this.resultTableSorter);
        this.resultTableSorter.setTableHeader(this.resultTable.getTableHeader());
        this.resultTable.setRowSelectionAllowed(true);
        this.resultTable.setColumnSelectionAllowed(false);
        this.resultTable.getSelectionModel().addListSelectionListener(this);
        this.resultTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.resultTable.getColumnModel().getColumn(2).setMaxWidth(100);
        this.resultTable.getColumnModel().getColumn(3).setMaxWidth(100);
        this.resultTable.getColumnModel().getColumn(4).setMaxWidth(50);
        this.resultTable.getColumnModel().getColumn(5).setMaxWidth(50);
        JScrollPane jsp2 = new JScrollPane(this.resultTable);
        jsp2.setBorder(new TitledBorder(Translatrix.getTranslationString((String)"dicom.MatchingFiles")));
        this.add((Component)jsp2, "Center");
        this.dicomImagePreview = new ImagePreviewDicom(this, this.parent.getParentDialog(), dicomFields);
        this.add((Component)this.dicomImagePreview, "East");
        this.bbuilder = new ButtonBarBuilder();
        this.bbuilder.addGlue();
        this.sendButton = new JButton(Translatrix.getTranslationString((String)"dicom.Send"));
        this.sendButton.setEnabled(false);
        this.sendButton.addActionListener(this);
        this.bbuilder.addGridded((JComponent)this.sendButton);
        this.bbuilder.addRelatedGap();
        this.movelocalButton = new JButton(Translatrix.getTranslationString((String)"dicom.MoveLocal"));
        this.movelocalButton.setEnabled(false);
        this.movelocalButton.addActionListener(this);
        this.bbuilder.addGridded((JComponent)this.movelocalButton);
        this.bbuilder.addRelatedGap();
        this.openButton = new JButton(Translatrix.getTranslationString((String)"dicom.Open"));
        this.openButton.setEnabled(false);
        this.openButton.addActionListener(this);
        this.bbuilder.addGridded((JComponent)this.openButton);
        this.bbuilder.addRelatedGap();
        this.cancelButton = new JButton(Translatrix.getTranslationString((String)"dicom.Cancel"));
        this.cancelButton.addActionListener(this);
        this.bbuilder.addGridded((JComponent)this.cancelButton);
        JPanel bPanel = this.bbuilder.getPanel();
        bPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)bPanel, "South");
        this.actionAddtag = new AbstractAction("add Tag"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MatcherPanel.this.headerTableModel.addTag(new HeaderTag());
            }
        };
        this.actionDeleteTag = new AbstractAction("delete Tag"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int row = MatcherPanel.this.tagTableSorter.modelIndex(MatcherPanel.this.tagTable.getSelectedRow());
                    MatcherPanel.this.headerTableModel.removeTag(row);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        };
    }

    public void setPath(final File dir) {
        new Thread(){

            @Override
            public void run() {
                MatcherPanel.this.dicomMatcher.setHeaderTags(MatcherPanel.this.headerTableModel.getTags());
                Vector dFiles = MatcherPanel.this.dicomMatcher.findMachingFiles(dir);
                MatcherPanel.this.resultTableModel.setFiles(dFiles);
                MatcherPanel.this.dicomImagePreview.loadImage(null);
            }
        }.start();
    }

    public void setDicomSenders(DcmURL[] senders) {
        this.senders = senders;
    }

    public void setLocalDest(DcmURL localDest) {
        this.localDest = localDest;
    }

    public void setDicomFilterTags(Vector headerTags) {
        for (HeaderTag tag : headerTags) {
            this.headerTableModel.addTag(tag);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.cancelButton)) {
            this.cancel();
        } else if (e.getSource().equals(this.movelocalButton)) {
            this.send(true);
        } else if (e.getSource().equals(this.sendButton)) {
            this.send(false);
        } else if (e.getSource().equals(this.openButton)) {
            this.open();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        try {
            DicomFile img = this.resultTableModel.getFile(this.resultTableSorter.modelIndex(this.resultTable.getSelectedRow()));
            this.dicomImagePreview.loadImage(img.getFile());
            this.sendButton.setEnabled(true);
            this.movelocalButton.setEnabled(true);
            this.openButton.setEnabled(true);
        }
        catch (Exception ee) {
            this.sendButton.setEnabled(false);
            this.movelocalButton.setEnabled(false);
            this.openButton.setEnabled(false);
        }
    }

    private void send(boolean local) {
        if (!local) {
            DcmURL url = DicomURLChooser.showDialog(this.parent.getParentDialog(), this.senders);
            if (url == null) {
                return;
            }
            this.dicomSender = new DicomSender(url);
        } else {
            this.dicomSender = new DicomSender(this.localDest);
        }
        if (this.dicomSender == null) {
            return;
        }
        final int[] selectedRows = this.resultTable.getSelectedRows();
        this.progressMonitor = new ProgressMonitor(this.parent.getParentDialog(), String.valueOf(Translatrix.getTranslationString((String)"dicom.SendingFilesTo")) + " \r\n" + this.dicomSender.getUrl(), "", 0, selectedRows.length);
        new Thread(){

            @Override
            public void run() {
                MatcherPanel.this.parent.getParentDialog().setWaitCursor(true);
                try {
                    int i = 0;
                    while (i < selectedRows.length) {
                        File element = MatcherPanel.this.resultTableModel.getFile(MatcherPanel.this.resultTableSorter.modelIndex(selectedRows[i])).getFile();
                        if (!MatcherPanel.this.progressMonitor.isCanceled()) {
                            MatcherPanel.this.progressMonitor.setNote("img " + element.getName() + " ( " + (i + 1) + " of " + (selectedRows.length + 1) + " )");
                            MatcherPanel.this.progressMonitor.setProgress(i);
                            MatcherPanel.this.dicomSender.send(element);
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (UnknownHostException e1) {
                    ErrorDialog.showErrorDialog((JDialog)MatcherPanel.this.parent.getParentDialog(), "Send Error", "Dicom Reciever at Host: " + e1.getLocalizedMessage() + " does not exist!", (Throwable)e1);
                    MatcherPanel.this.parent.getParentDialog().setWaitCursor(false);
                }
                catch (Exception e1) {
                    ErrorDialog.showErrorDialog((JDialog)MatcherPanel.this.parent.getParentDialog(), "Send Error", String.valueOf(e1.getClass().getName()) + " " + e1.getLocalizedMessage(), (Throwable)e1);
                    MatcherPanel.this.parent.getParentDialog().setWaitCursor(false);
                }
                MatcherPanel.this.progressMonitor.close();
                MatcherPanel.this.parent.getParentDialog().setWaitCursor(false);
            }
        }.start();
    }

    private void open() {
        this.parent.getParentDialog().setWaitCursor(true);
        try {
            int[] selectedRows = this.resultTable.getSelectedRows();
            File[] files = new File[selectedRows.length];
            int i = 0;
            while (i < selectedRows.length) {
                File element;
                files[i] = element = this.resultTableModel.getFile(this.resultTableSorter.modelIndex(selectedRows[i])).getFile();
                ++i;
            }
            try {
                this.parent.getParentDialog().setSelectedFile(files[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.parent.getParentDialog().setSelectedFiles(files);
            this.parent.getParentDialog().setRetValue(0);
            this.parent.getParentDialog().setVisible(false);
        }
        catch (Exception ee) {
            this.parent.getParentDialog().setSelectedFiles(null);
            this.parent.getParentDialog().setSelectedFile(null);
            this.parent.getParentDialog().setRetValue(1);
            this.parent.getParentDialog().setVisible(false);
        }
        this.parent.getParentDialog().setWaitCursor(false);
    }

    private void cancel() {
        this.parent.getParentDialog().setRetValue(1);
        this.parent.getParentDialog().setVisible(false);
        this.parent.getParentDialog().setWaitCursor(false);
    }

    private void showPopup(Component c, int x, int y) {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.popup.add(this.actionAddtag);
            this.popup.add(this.actionDeleteTag);
        }
        this.popup.show(c, x, y);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e.getComponent(), e.getX(), e.getY());
        }
    }

    public Vector getDicomFilterTags() {
        return this.headerTableModel.getTagsVector();
    }
}

