/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.utils;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ComponentTitledPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected ComponentBorder border;
    protected JComponent component;
    protected JComponent contentComponent;

    public ComponentTitledPanel(JComponent component, JComponent contentComponent) {
        this.component = component;
        this.border = new ComponentBorder(component);
        this.setBorder(this.border);
        this.setOpaque(false);
        this.contentComponent = contentComponent;
        this.setLayout(null);
        this.add(component);
        this.add(contentComponent);
    }

    public ComponentTitledPanel(Border b, JComponent component, JComponent contentComponent) {
        this.component = component;
        this.border = new ComponentBorder(b, component);
        this.setBorder(this.border);
        this.setOpaque(false);
        this.contentComponent = contentComponent;
        this.setLayout(null);
        this.add(component);
        this.add(contentComponent);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.border.getBorderInsets(this.contentComponent);
        int height = this.contentComponent.getPreferredSize().height + insets.top + insets.bottom;
        int width = this.contentComponent.getPreferredSize().width + insets.left + insets.right;
        Dimension s = new Dimension(width, height);
        return s;
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        jf.setLayout((LayoutManager)new FormLayout("fill:pref", "fill:pref"));
        CellConstraints cc = new CellConstraints();
        JCheckBox hallowelt = new JCheckBox("hallo welt");
        hallowelt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        ComponentTitledPanel cp = new ComponentTitledPanel(hallowelt, new JLabel("content"));
        JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)cp, "Center");
        jf.add((Component)jp, cc.xy(1, 1));
        jf.setDefaultCloseOperation(3);
        jf.pack();
        jf.setVisible(true);
    }

    public JComponent getTitleComponent() {
        return this.component;
    }

    public void setTitleComponent(JComponent newComponent) {
        this.remove(this.component);
        this.add(newComponent);
        this.border.setTitleComponent(newComponent);
        this.component = newComponent;
    }

    public JComponent getContentPane() {
        return this.contentComponent;
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        Rectangle rect = this.getBounds();
        rect.x = 0;
        rect.y = 0;
        Rectangle compR = this.border.getComponentRect(rect, insets);
        this.component.setBounds(compR);
        rect.x += insets.left;
        rect.y += insets.top;
        rect.width -= insets.left + insets.right;
        rect.height -= insets.top + insets.bottom;
        this.contentComponent.setBounds(rect);
    }

    public class ComponentBorder
    extends TitledBorder {
        private static final long serialVersionUID = -2758720393831156600L;
        protected JComponent component;

        public ComponentBorder(JComponent component) {
            this(null, component, 1, 2);
        }

        public ComponentBorder(Border border) {
            this(border, null, 1, 2);
        }

        public ComponentBorder(Border border, JComponent component) {
            this(border, component, 1, 2);
        }

        public ComponentBorder(Border border, JComponent component, int titleJustification, int titlePosition) {
            super(border, null, titleJustification, titlePosition, null, null);
            this.component = component;
            if (border == null) {
                this.border = super.getBorder();
            }
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Rectangle borderR = new Rectangle(x + 2, y + 2, width - 4, height - 4);
            Insets borderInsets = this.border != null ? this.border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
            Rectangle rect = new Rectangle(x, y, width, height);
            Insets insets = this.getBorderInsets(c);
            Rectangle compR = this.getComponentRect(rect, insets);
            switch (this.titlePosition) {
                case 1: {
                    int diff = compR.height + 2;
                    borderR.y += diff;
                    borderR.height -= diff;
                    break;
                }
                case 0: 
                case 2: {
                    int diff = insets.top / 2 - borderInsets.top - 2;
                    borderR.y += diff;
                    borderR.height -= diff;
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    int diff = insets.bottom / 2 - borderInsets.bottom - 2;
                    borderR.height -= diff;
                    break;
                }
                case 6: {
                    int diff = compR.height + 2;
                    borderR.height -= diff;
                }
            }
            super.paintBorder(c, g, borderR.x, borderR.y, borderR.width, borderR.height);
            Color col = g.getColor();
            g.setColor(c.getBackground());
            g.fillRect(compR.x, compR.y, compR.width, compR.height);
            g.setColor(col);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets borderInsets = this.border != null ? this.border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
            insets.top = 4 + borderInsets.top;
            insets.right = 4 + borderInsets.right;
            insets.bottom = 4 + borderInsets.bottom;
            insets.left = 4 + borderInsets.left;
            if (c == null || this.component == null) {
                return insets;
            }
            int compHeight = 0;
            if (this.component != null) {
                compHeight = this.component.getPreferredSize().height;
            }
            switch (this.titlePosition) {
                case 1: {
                    insets.top += compHeight + 2;
                    break;
                }
                case 0: 
                case 2: {
                    insets.top += Math.max(compHeight, borderInsets.top) - borderInsets.top;
                    break;
                }
                case 3: {
                    insets.top += compHeight + 2;
                    break;
                }
                case 4: {
                    insets.bottom += compHeight + 2;
                    break;
                }
                case 5: {
                    insets.bottom += Math.max(compHeight, borderInsets.bottom) - borderInsets.bottom;
                    break;
                }
                case 6: {
                    insets.bottom += compHeight + 2;
                }
            }
            return insets;
        }

        public JComponent getTitleComponent() {
            return this.component;
        }

        public void setTitleComponent(JComponent component) {
            this.component = component;
        }

        public Rectangle getComponentRect(Rectangle rect, Insets borderInsets) {
            Dimension compD = this.component.getPreferredSize();
            Rectangle compR = new Rectangle(0, 0, compD.width, compD.height);
            switch (this.titlePosition) {
                case 1: {
                    compR.y = 2;
                    break;
                }
                case 0: 
                case 2: {
                    compR.y = 2 + (borderInsets.top - 2 - 2 - compD.height) / 2;
                    break;
                }
                case 3: {
                    compR.y = borderInsets.top - compD.height - 2;
                    break;
                }
                case 4: {
                    compR.y = rect.height - borderInsets.bottom + 2;
                    break;
                }
                case 5: {
                    compR.y = rect.height - borderInsets.bottom + 2 + (borderInsets.bottom - 2 - 2 - compD.height) / 2;
                    break;
                }
                case 6: {
                    compR.y = rect.height - compD.height - 2;
                }
            }
            switch (this.titleJustification) {
                case 0: 
                case 1: {
                    compR.x = 5 + borderInsets.left;
                    break;
                }
                case 3: {
                    compR.x = rect.width - borderInsets.right - 5 - compR.width;
                    break;
                }
                case 2: {
                    compR.x = (rect.width - compR.width) / 2;
                }
            }
            return compR;
        }
    }
}

