/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.utils;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import lu.tudor.santec.dicom.gui.utils.TableFilter;

public abstract class FilterTableModel
extends AbstractTableModel {
    protected Vector<?> m_TableData;
    private TableFilter[] m_Filters = new TableFilter[this.getColumnCount()];
    private int[] m_FilteringColumns = new int[this.getColumnCount()];
    private int m_FilteringColumnCount;
    private int[] m_FilteredIndexes;
    private int m_FilteredCount;
    private static final long serialVersionUID = 1L;
    private static final int c_NoColumn = -1;

    public FilterTableModel() {
        this.disableAllFilters();
    }

    public int filteredToModel(int p_FilteredRow) {
        if (this.m_FilteredIndexes != null && p_FilteredRow >= 0 && p_FilteredRow < this.m_FilteredCount) {
            return this.m_FilteredIndexes[p_FilteredRow];
        }
        return p_FilteredRow;
    }

    private int findFilteringColumn(int p_Column) {
        int l_Index = 0;
        boolean l_Found = false;
        while (l_Index < this.m_FilteringColumnCount && !l_Found) {
            if (this.m_FilteringColumns[l_Index] == p_Column) {
                l_Found = true;
                continue;
            }
            ++l_Index;
        }
        if (l_Found) {
            return l_Index;
        }
        return -1;
    }

    private void reorganizeFilteringColumns() {
        int l_NextFreeSlot = -1;
        int l_Index = 0;
        while (l_Index < this.m_FilteringColumns.length) {
            if (this.m_FilteringColumns[l_Index] != -1) {
                if (l_NextFreeSlot >= 0 && l_Index - l_NextFreeSlot > 0) {
                    this.m_FilteringColumns[l_NextFreeSlot] = this.m_FilteringColumns[l_Index];
                    this.m_FilteringColumns[l_Index] = -1;
                    l_NextFreeSlot = l_Index;
                }
            } else {
                l_NextFreeSlot = l_Index;
            }
            ++l_Index;
        }
    }

    private void compileActiveFilters() {
        int l_Index = 0;
        while (l_Index < this.m_FilteringColumnCount) {
            int l_Column = this.m_FilteringColumns[l_Index];
            TableFilter l_Filter = this.m_Filters[l_Column];
            if (l_Filter.isFiltering()) {
                l_Filter.compile();
            }
            ++l_Index;
        }
    }

    private void applyFilter() {
        this.compileActiveFilters();
        int l_TotalRows = this.m_TableData != null ? this.m_TableData.size() : 0;
        if (l_TotalRows > 0) {
            this.m_FilteredIndexes = new int[l_TotalRows];
            this.m_FilteredCount = 0;
            int l_Row = 0;
            while (l_Row < l_TotalRows) {
                int l_FilteringColumn = 0;
                boolean l_Accepted = true;
                while (l_FilteringColumn < this.m_FilteringColumnCount && l_Accepted) {
                    int l_Column = this.m_FilteringColumns[l_FilteringColumn];
                    TableFilter l_Filter = this.m_Filters[l_Column];
                    Object l_Value = this.getValueAt(l_Row, l_Column);
                    l_Accepted &= l_Filter.accept(l_Value);
                    ++l_FilteringColumn;
                }
                if (l_Accepted) {
                    this.m_FilteredIndexes[this.m_FilteredCount++] = l_Row;
                }
                ++l_Row;
            }
        }
    }

    private void enableFilter(int p_Column) {
        int l_FilteringColumn;
        TableFilter l_Filter;
        if (p_Column >= 0 && p_Column < this.m_Filters.length && (l_Filter = this.m_Filters[p_Column]) != null && (l_FilteringColumn = this.findFilteringColumn(p_Column)) == -1) {
            this.m_FilteringColumns[this.m_FilteringColumnCount++] = p_Column;
        }
    }

    private void disableFilter(int p_Column) {
        int l_FilteringColumn;
        if (this.m_FilteringColumnCount == 0) {
            return;
        }
        if (p_Column >= 0 && p_Column < this.m_Filters.length && (l_FilteringColumn = this.findFilteringColumn(p_Column)) != -1) {
            this.m_FilteringColumns[l_FilteringColumn] = -1;
            this.reorganizeFilteringColumns();
            --this.m_FilteringColumnCount;
        }
    }

    private void disableAllFilters() {
        this.m_FilteringColumnCount = 0;
        int l_Index = 0;
        while (l_Index < this.m_FilteringColumns.length) {
            this.m_FilteringColumns[l_Index] = -1;
            ++l_Index;
        }
        this.m_FilteredIndexes = null;
        this.m_FilteredCount = 0;
    }

    protected void setTableData(Vector<?> p_TableData) {
        this.m_TableData = p_TableData;
        this.update();
    }

    protected int getFilteredRowCount() {
        if (this.isFiltering()) {
            return this.m_FilteredCount;
        }
        if (this.m_TableData != null) {
            return this.m_TableData.size();
        }
        return 0;
    }

    public void installFilter(TableFilter p_Filter, int p_Column) {
        if (p_Filter == null) {
            return;
        }
        if (p_Column >= 0 && p_Column < this.m_Filters.length) {
            this.m_Filters[p_Column] = p_Filter;
        }
    }

    public TableFilter getFilter(int p_Column) {
        if (p_Column >= 0 && p_Column < this.m_Filters.length) {
            return this.m_Filters[p_Column];
        }
        return null;
    }

    public void clearFilters() {
        this.disableAllFilters();
        int l_Column = 0;
        while (l_Column < this.m_Filters.length) {
            this.m_Filters[l_Column] = null;
            ++l_Column;
        }
    }

    public void setFilteringEnabled(boolean p_EnableIt, int p_Column) {
        if (p_EnableIt) {
            this.enableFilter(p_Column);
        } else {
            this.disableFilter(p_Column);
        }
        this.update();
    }

    public void resetFiltering() {
        this.disableAllFilters();
    }

    public boolean isFiltering() {
        return this.m_FilteringColumnCount > 0;
    }

    public void update() {
        if (this.isFiltering()) {
            this.applyFilter();
        }
    }
}

