/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected TableModel tableModel;
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    public static final Comparator COMPARABLE_COMAPRATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    private Row[] viewToModel;
    private int[] modelToView;
    private JTableHeader tableHeader;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    private Map columnComparators = new HashMap();
    private List sortingColumns = new ArrayList();

    public TableSorter() {
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public TableSorter(TableModel tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    public TableSorter(TableModel tableModel, JTableHeader tableHeader) {
        this();
        this.setTableHeader(tableHeader);
        this.setTableModel(tableModel);
    }

    private void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer defaultRenderer = this.tableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)defaultRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = tableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    private Directive getDirective(int column) {
        int i = 0;
        while (i < this.sortingColumns.size()) {
            Directive directive = (Directive)this.sortingColumns.get(i);
            if (directive.column == column) {
                return directive;
            }
            ++i;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getSortingStatus(int column) {
        return this.getDirective(column).direction;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    public void setSortingStatus(int column, int status) {
        Directive directive = this.getDirective(column);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortingColumns.remove(directive);
        }
        if (status != 0) {
            this.sortingColumns.add(new Directive(column, status));
        }
        this.sortingStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int column, int size) {
        Directive directive = this.getDirective(column);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        if (directive.direction == -1) {
            return new DescendingIcon();
        }
        return new AscendingIcon();
    }

    private void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class type, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(type);
        } else {
            this.columnComparators.put(type, comparator);
        }
    }

    protected Comparator getComparator(int column) {
        Class<?> columnType = this.tableModel.getColumnClass(column);
        Comparator comparator = (Comparator)this.columnComparators.get(columnType);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(columnType)) {
            return COMPARABLE_COMAPRATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    private Row[] getViewToModel() {
        if (this.viewToModel == null) {
            int tableModelRowCount = this.tableModel.getRowCount();
            this.viewToModel = new Row[tableModelRowCount];
            int row = 0;
            while (row < tableModelRowCount) {
                this.viewToModel[row] = new Row(row);
                ++row;
            }
            if (this.isSorting()) {
                Arrays.sort(this.viewToModel);
            }
        }
        return this.viewToModel;
    }

    public int modelIndex(int viewIndex) {
        try {
            return this.getViewToModel()[viewIndex].modelIndex;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int viewIndex(int modelIndex) {
        try {
            return this.getModelToView()[modelIndex];
        }
        catch (Exception e) {
            return -1;
        }
    }

    private int[] getModelToView() {
        if (this.modelToView == null) {
            int n = this.getViewToModel().length;
            this.modelToView = new int[n];
            int i = 0;
            while (i < n) {
                this.modelToView[this.modelIndex((int)i)] = i;
                ++i;
            }
        }
        return this.modelToView;
    }

    @Override
    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.tableModel.getColumnClass(column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.tableModel.isCellEditable(this.modelIndex(row), column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.tableModel.getValueAt(this.modelIndex(row), column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        this.tableModel.setValueAt(aValue, this.modelIndex(row), column);
    }

    private float invertAsNeed(float pBright, boolean pNeed) {
        return pNeed ? 1.0f - pBright : pBright;
    }

    public class AscendingIcon
    extends NullIcon {
        @Override
        public void paintIcon(Component pComponent, Graphics pGraphics, int pX, int pY) {
            int[] xx = new int[]{pX, pX + 3, pX + 6};
            int[] yy = new int[]{pY + 6, pY, pY + 6};
            Color initialColor = pGraphics.getColor();
            float[] initial = Color.RGBtoHSB(initialColor.getRed(), initialColor.getGreen(), initialColor.getBlue(), null);
            boolean need = initial[2] < 0.5f;
            initial[2] = TableSorter.this.invertAsNeed(initial[2], need);
            Color line = Color.getHSBColor(initial[0], initial[1], TableSorter.this.invertAsNeed(initial[2] * 0.7f, need));
            Color fill = Color.getHSBColor(initial[0], initial[1], TableSorter.this.invertAsNeed(initial[2] * 0.35f, need));
            pGraphics.setColor(fill);
            pGraphics.fillPolygon(xx, yy, 3);
            pGraphics.setColor(line);
            pGraphics.drawPolygon(xx, yy, 3);
        }
    }

    public class DescendingIcon
    extends NullIcon {
        @Override
        public void paintIcon(Component pComponent, Graphics pGraphics, int pX, int pY) {
            int[] xx = new int[]{pX, pX + 3, pX + 6};
            int[] yy = new int[]{pY, pY + 6, pY + 0};
            Color initialColor = pGraphics.getColor();
            float[] initial = Color.RGBtoHSB(initialColor.getRed(), initialColor.getGreen(), initialColor.getBlue(), null);
            boolean need = initial[2] < 0.5f;
            initial[2] = TableSorter.this.invertAsNeed(initial[2], need);
            Color line = Color.getHSBColor(initial[0], initial[1], TableSorter.this.invertAsNeed(initial[2] * 0.7f, need));
            Color fill = Color.getHSBColor(initial[0], initial[1], TableSorter.this.invertAsNeed(initial[2] * 0.35f, need));
            pGraphics.setColor(fill);
            pGraphics.fillPolygon(xx, yy, 3);
            pGraphics.setColor(line);
            pGraphics.drawPolygon(xx, yy, 3);
        }
    }

    private static class Directive {
        private int column;
        private int direction;

        public Directive(int column, int direction) {
            this.column = column;
            this.direction = direction;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader h;
            TableColumnModel columnModel;
            int column;
            if (e.getButton() == 1 && (column = (columnModel = (h = (JTableHeader)e.getSource()).getColumnModel()).getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex()) != -1) {
                int status = TableSorter.this.getSortingStatus(column);
                if (!e.isControlDown()) {
                    TableSorter.this.cancelSorting();
                }
                status += e.isShiftDown() ? -1 : 1;
                status = (status + 4) % 3 - 1;
                TableSorter.this.setSortingStatus(column, status);
            }
        }
    }

    public class NullIcon
    implements Icon {
        @Override
        public int getIconHeight() {
            return 6;
        }

        @Override
        public int getIconWidth() {
            return 6;
        }

        @Override
        public void paintIcon(Component pComponent, Graphics pGraphics, int pX, int pY) {
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int index) {
            this.modelIndex = index;
        }

        public int compareTo(Object o) {
            int row1 = this.modelIndex;
            int row2 = ((Row)o).modelIndex;
            for (Directive directive : TableSorter.this.sortingColumns) {
                int column = directive.column;
                Object o1 = TableSorter.this.tableModel.getValueAt(row1, column);
                Object o2 = TableSorter.this.tableModel.getValueAt(row2, column);
                int comparison = 0;
                comparison = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : TableSorter.this.getComparator(column).compare(o1, o2)));
                if (comparison == 0) continue;
                return directive.direction == -1 ? -comparison : comparison;
            }
            return 0;
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setHorizontalTextPosition(2);
                int modelColumn = table.convertColumnIndexToModel(column);
                l.setIcon(TableSorter.this.getHeaderRendererIcon(modelColumn, l.getFont().getSize()));
            }
            return c;
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (!TableSorter.this.isSorting()) {
                TableSorter.this.clearSortingState();
                TableSorter.this.fireTableChanged(e);
                return;
            }
            if (e.getFirstRow() == -1) {
                TableSorter.this.cancelSorting();
                TableSorter.this.fireTableChanged(e);
                return;
            }
            int column = e.getColumn();
            if (e.getFirstRow() == e.getLastRow() && column != -1 && TableSorter.this.getSortingStatus(column) == 0 && TableSorter.this.modelToView != null) {
                int viewIndex = TableSorter.this.getModelToView()[e.getFirstRow()];
                TableSorter.this.fireTableChanged(new TableModelEvent(TableSorter.this, viewIndex, viewIndex, column, e.getType()));
                return;
            }
            TableSorter.this.clearSortingState();
            TableSorter.this.fireTableDataChanged();
        }
    }
}

