/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.utils;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableUtils {
    private static int columnHeaderWidth(JTable l_Table, TableColumn col) {
        TableCellRenderer renderer = l_Table.getTableHeader().getDefaultRenderer();
        Component comp = renderer.getTableCellRendererComponent(l_Table, col.getHeaderValue(), false, false, 0, 0);
        return comp.getPreferredSize().width;
    }

    private static int widestCellInColumn(JTable l_Table, TableColumn col) {
        int c = col.getModelIndex();
        int width = 0;
        int maxw = 0;
        int r = 0;
        while (r < l_Table.getRowCount()) {
            TableCellRenderer renderer = l_Table.getCellRenderer(r, c);
            Component comp = renderer.getTableCellRendererComponent(l_Table, l_Table.getValueAt(r, c), false, false, r, c);
            width = comp.getPreferredSize().width;
            maxw = width > maxw ? width : maxw;
            ++r;
        }
        return maxw;
    }

    private static int getPreferredWidthForColumn(JTable l_Table, TableColumn col) {
        int cw;
        int hw = TableUtils.columnHeaderWidth(l_Table, col);
        return hw > (cw = TableUtils.widestCellInColumn(l_Table, col)) ? hw : cw;
    }

    public static void adjustColWidth(JTable l_Table) {
        int i = 0;
        while (i < l_Table.getColumnCount()) {
            TableColumn l_Col = l_Table.getColumn(l_Table.getColumnName(i));
            int width = TableUtils.getPreferredWidthForColumn(l_Table, l_Col) + 20;
            l_Col.setMinWidth(width);
            l_Col.setMaxWidth(width);
            ++i;
        }
    }

    public static void adjustColWidth(JTable l_Table, JTable slaveTable) {
        int i = 0;
        while (i < l_Table.getColumnCount()) {
            TableColumn l_Col = l_Table.getColumn(l_Table.getColumnName(i));
            int width = TableUtils.getPreferredWidthForColumn(l_Table, l_Col) + 20;
            l_Col.setMinWidth(width);
            l_Col.setMaxWidth(width);
            TableColumn slaveColumn = slaveTable.getColumn(l_Table.getColumnName(i));
            slaveColumn.setMinWidth(width);
            slaveColumn.setMaxWidth(width);
            ++i;
        }
    }

    public static void adjustColWidthByHeader(JTable l_Table) {
        int i = 0;
        while (i < l_Table.getColumnCount()) {
            TableColumn l_Col = l_Table.getColumn(l_Table.getColumnName(i));
            int width = TableUtils.columnHeaderWidth(l_Table, l_Col) + 6;
            l_Col.setMinWidth(width);
            l_Col.setMaxWidth(width);
            ++i;
        }
    }
}

