/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.viewer;

import ij.ImagePlus;
import ij.gui.Roi;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JToggleButton;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.viewer.DicomImagePanel;
import lu.tudor.santec.dicom.gui.viewer.ImageListener;
import lu.tudor.santec.dicom.gui.viewer.RoiBuilder;

public class DicomImageCornerSelector {
    private DicomImagePanel dicomImagePanel;
    private int size;
    private Point[] points = new Point[4];
    Vector<Roi> v = new Vector();
    private JToggleButton button;

    public DicomImageCornerSelector(DicomImagePanel dip) {
        this(dip, 100);
    }

    public DicomImageCornerSelector(DicomImagePanel dip, int sizePixels) {
        this.dicomImagePanel = dip;
        this.size = sizePixels;
        this.button = this.dicomImagePanel.addModeButton(DicomIcons.getScreenDependentIcon("action_corners.png"), "Select Corners", new ImageListener(){
            int i = 0;

            @Override
            public void pixelClicked(ImagePlus ip, int x, int y) {
                int corner = 1;
                if (x > ip.getWidth() / 2) {
                    if (y > ip.getHeight() / 2) {
                        corner = 4;
                        this.i = corner - 1;
                    } else {
                        corner = 2;
                        this.i = corner - 1;
                    }
                } else if (y > ip.getHeight() / 2) {
                    corner = 3;
                    this.i = corner - 1;
                } else {
                    corner = 1;
                    this.i = corner - 1;
                }
                ((DicomImageCornerSelector)DicomImageCornerSelector.this).points[this.i] = new Point(x, y);
                DicomImageCornerSelector.this.v.removeAllElements();
                int c = 0;
                while (c < DicomImageCornerSelector.this.points.length) {
                    if (DicomImageCornerSelector.this.points[c] != null) {
                        corner = c + 1;
                        RoiBuilder.createCornerRoi(DicomImageCornerSelector.this.v, ((DicomImageCornerSelector)DicomImageCornerSelector.this).points[c].x, ((DicomImageCornerSelector)DicomImageCornerSelector.this).points[c].y, DicomImageCornerSelector.this.size, corner, Color.YELLOW);
                    }
                    ++c;
                }
                DicomImageCornerSelector.this.dicomImagePanel.setDefaultRois(DicomImageCornerSelector.this.v);
            }

            @Override
            public void mouseMoved(int x, int y, MouseEvent e) {
            }

            @Override
            public void optionSelected(boolean selected) {
                if (!selected) {
                    DicomImageCornerSelector.this.v.removeAllElements();
                } else {
                    int c = 0;
                    while (c < DicomImageCornerSelector.this.points.length) {
                        if (DicomImageCornerSelector.this.points[c] != null) {
                            int corner = c + 1;
                            RoiBuilder.createCornerRoi(DicomImageCornerSelector.this.v, ((DicomImageCornerSelector)DicomImageCornerSelector.this).points[c].x, ((DicomImageCornerSelector)DicomImageCornerSelector.this).points[c].y, DicomImageCornerSelector.this.size, corner, Color.YELLOW);
                        }
                        ++c;
                    }
                    DicomImageCornerSelector.this.dicomImagePanel.setDefaultRois(DicomImageCornerSelector.this.v);
                }
            }

            @Override
            public void imageChanged(ImagePlus image) {
            }
        });
    }

    public Point[] getCorners() {
        return this.points;
    }

    public void resetCorners() {
        this.points = new Point[4];
        this.v.removeAllElements();
        this.dicomImagePanel.setDefaultRois(this.v);
    }

    public void setVisible(boolean visible) {
        this.button.setVisible(visible);
        this.resetCorners();
    }
}

