/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.viewer;

import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Vector;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.viewer.DicomImagePanel;
import lu.tudor.santec.dicom.gui.viewer.ImageListener;
import lu.tudor.santec.dicom.gui.viewer.OSDText;
import lu.tudor.santec.i18n.Translatrix;

public class DicomImageMeasurement {
    DicomImagePanel dicomImagePanel;

    public DicomImageMeasurement(DicomImagePanel dip) {
        this.dicomImagePanel = dip;
        this.dicomImagePanel.addModeButton(DicomIcons.getScreenDependentIcon("action_measure.png"), Translatrix.getTranslationString((String)"dicom.dicomImagePanel.measureImage"), new ImageListener(){
            Vector<Roi> v = new Vector();
            Vector<OSDText> vText = new Vector();
            int x1;
            int x2;
            int y1;
            int y2;
            int count = 1;
            private Line l;
            private NumberFormat nf = NumberFormat.getInstance();

            @Override
            public void pixelClicked(ImagePlus ip, int x, int y) {
                if (this.count == 1) {
                    this.v.removeAllElements();
                    this.vText.removeAllElements();
                    this.x1 = x;
                    this.y1 = y;
                    ++this.count;
                    OvalRoi or = new OvalRoi(x - 5, y - 5, 10, 10);
                    or.setName("0,255,0");
                    this.v.add((Roi)or);
                } else if (this.count == 2) {
                    String unit = "mm";
                    this.x2 = x;
                    this.y2 = y;
                    ++this.count;
                    OvalRoi or = new OvalRoi(x - 5, y - 5, 10, 10);
                    or.setName("0,255,0");
                    this.v.add((Roi)or);
                    this.v.remove(this.l);
                    this.l = new Line(this.x1, this.y1, this.x2, this.y2);
                    this.l.setName("0,255,0");
                    this.v.add((Roi)this.l);
                    double xdiff = Math.abs(this.x1 - this.x2);
                    double ydiff = Math.abs(this.y1 - this.y2);
                    if (DicomImageMeasurement.this.dicomImagePanel.getPixelSizeX() == 0.0 || DicomImageMeasurement.this.dicomImagePanel.getPixelSizeY() == 0.0) {
                        unit = "px";
                    } else {
                        xdiff *= DicomImageMeasurement.this.dicomImagePanel.getPixelSizeX();
                        ydiff *= DicomImageMeasurement.this.dicomImagePanel.getPixelSizeY();
                    }
                    double length = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    this.vText.add(new OSDText("Length is: " + this.nf.format(length) + " " + unit, this.x1, this.y1 - 10, Color.GREEN));
                    this.count = 1;
                }
                DicomImageMeasurement.this.dicomImagePanel.setDefaultRois(this.v);
                DicomImageMeasurement.this.dicomImagePanel.setDefaultOSDTexts(this.vText);
            }

            @Override
            public void optionSelected(boolean selected) {
                if (!selected) {
                    this.v.removeAllElements();
                    DicomImageMeasurement.this.dicomImagePanel.setDefaultRois(this.v);
                    this.vText.removeAllElements();
                    DicomImageMeasurement.this.dicomImagePanel.setDefaultOSDTexts(this.vText);
                }
            }

            @Override
            public void mouseMoved(int x, int y, MouseEvent e) {
                if (this.count == 2) {
                    this.x2 = x;
                    this.y2 = y;
                    this.v.remove(this.l);
                    this.l = new Line(this.x1, this.y1, this.x2, this.y2);
                    this.l.setName("0,255,0");
                    this.v.add((Roi)this.l);
                    DicomImageMeasurement.this.dicomImagePanel.setDefaultRois(this.v);
                }
            }

            @Override
            public void imageChanged(ImagePlus image) {
            }
        });
    }
}

