/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.viewer;

import ij.ImagePlus;
import ij.gui.Roi;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.viewer.DicomImagePanel;
import lu.tudor.santec.dicom.gui.viewer.ImageListener;
import lu.tudor.santec.i18n.Translatrix;

public class DicomImageROI {
    private DicomImagePanel dicomImagePanel;
    private ImageIcon icon = DicomIcons.getScreenDependentIcon("action_roi.png");
    private String tooltip = Translatrix.getTranslationString((String)"dicom.dicomImagePanel.roi");
    private Roi roi;

    public DicomImageROI(DicomImagePanel dip) {
        this.dicomImagePanel = dip;
        this.dicomImagePanel.addModeButton(this.icon, this.tooltip, new ImageListener(){
            Vector<Roi> v = new Vector();
            int count = 0;
            int x1;
            int x2;
            int y1;
            int y2 = 0;

            @Override
            public void mouseMoved(int x, int y, MouseEvent e) {
                if (this.count == 1) {
                    this.v.removeAllElements();
                    this.x2 = x;
                    this.y2 = y;
                    DicomImageROI.this.roi = new Roi(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
                    this.v.add(DicomImageROI.this.roi);
                }
                DicomImageROI.this.dicomImagePanel.setRois(this.v);
            }

            @Override
            public void optionSelected(boolean selected) {
            }

            @Override
            public void pixelClicked(ImagePlus ip, int x, int y) {
                if (this.count == 0) {
                    this.v.removeAllElements();
                    ++this.count;
                    this.x1 = x;
                    this.y1 = y;
                } else if (this.count == 1) {
                    this.v.removeAllElements();
                    this.x2 = x;
                    this.y2 = y;
                    ++this.count;
                    DicomImageROI.this.roi = new Roi(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
                    this.v.add(DicomImageROI.this.roi);
                    this.count = 2;
                } else if (this.count == 2) {
                    this.v.removeAllElements();
                    this.count = 0;
                }
                DicomImageROI.this.dicomImagePanel.setRois(this.v);
            }

            @Override
            public void imageChanged(ImagePlus image) {
            }
        });
    }
}

