/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.viewer;

import ij.gui.Line;
import ij.gui.Roi;
import java.awt.Color;
import java.util.Vector;

public class RoiBuilder {
    public static final int CORNER_TOP_LEFT = 1;
    public static final int CORNER_TOP_RIGHT = 2;
    public static final int CORNER_BOTTOM_LEFT = 3;
    public static final int CORNER_BOTTOM_RIGHT = 4;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;

    public static void createCornerRoi(Vector<Roi> roiVector, int xPos, int yPos, int size, int corner, Color color) {
        String colorStr = String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue();
        int halfSize = size / 3 * 2;
        switch (corner) {
            case 1: {
                Line roi = new Line(xPos, yPos, xPos + size, yPos);
                roi.setName(colorStr);
                roiVector.add((Roi)roi);
                roi = new Line(xPos, yPos, xPos, yPos + size);
                roi.setName(colorStr);
                roiVector.add((Roi)roi);
                roi = new Line(xPos + halfSize, yPos, xPos, yPos + halfSize);
                roi.setName(colorStr);
                roiVector.add((Roi)roi);
                break;
            }
            case 2: {
                Line roi = new Line(xPos, yPos, xPos - size, yPos);
                roi.setName(colorStr);
                roiVector.add((Roi)roi);
                roi = new Line(xPos, yPos, xPos, yPos + size);
                roi.setName(colorStr);
                roiVector.add((Roi)roi);
                roi = new Line(xPos - halfSize, yPos, xPos, yPos + halfSize);
                roi.setName(colorStr);
                roiVector.add((Roi)roi);
                break;
            }
            case 3: {
                Line roi = new Line(xPos, yPos, xPos, yPos - size);
                roi.setName(colorStr);
                roiVector.add((Roi)roi);
                roi = new Line(xPos, yPos, xPos + size, yPos);
                roi.setName(colorStr);
                roiVector.add((Roi)roi);
                roi = new Line(xPos + halfSize, yPos, xPos, yPos - halfSize);
                roi.setName(colorStr);
                roiVector.add((Roi)roi);
                break;
            }
            case 4: {
                Line roi = new Line(xPos, yPos, xPos, yPos - size);
                roi.setName(colorStr);
                roiVector.add((Roi)roi);
                roi = new Line(xPos, yPos, xPos - size, yPos);
                roi.setName(colorStr);
                roiVector.add((Roi)roi);
                roi = new Line(xPos - halfSize, yPos, xPos, yPos - halfSize);
                roi.setName(colorStr);
                roiVector.add((Roi)roi);
                break;
            }
        }
    }

    public static void createDistanceRoi(Vector<Roi> roiVector, int x1, int y1, int x2, int y2, int size, Color color) {
        int halfSize = size / 2;
        Line roi = new Line(x1, y1, x2, y2);
        roi.setName(String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue());
        roiVector.add((Roi)roi);
        if (Math.abs(x1 - x2) < Math.abs(y1 - y2)) {
            roi = new Line(x1 - halfSize, y1, x1 + halfSize, y1);
            roi.setName(String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue());
            roiVector.add((Roi)roi);
            roi = new Line(x2 - halfSize, y2, x2 + halfSize, y2);
            roi.setName(String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue());
            roiVector.add((Roi)roi);
        } else {
            roi = new Line(x1, y1 - halfSize, x1, y1 + halfSize);
            roi.setName(String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue());
            roiVector.add((Roi)roi);
            roi = new Line(x2, y2 - halfSize, x2, y2 + halfSize);
            roi.setName(String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue());
            roiVector.add((Roi)roi);
        }
    }
}

