/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.viewer;

import com.l2fprod.common.swing.JButtonBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.LineBorder;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.viewer.DicomImagePanel;
import lu.tudor.santec.dicom.gui.viewer.Series;
import lu.tudor.santec.i18n.Translatrix;
import net.iharder.dnd.FileDrop;
import org.apache.log4j.Logger;

public class SeriesBar
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private ButtonGroup group = new ButtonGroup();
    private DicomImagePanel dicomImagePanel;
    private JButtonBar jbuttonbar;
    private JScrollPane jsp;
    private JCheckBox imageInMemory;
    private LinkedHashMap<String, Series> series = new LinkedHashMap();
    private Series activeSeries;
    private Logger logger = Logger.getLogger((String)this.getClass().getName());
    private JButton nextButton;
    private JButton prevButton;
    private JPopupMenu popup;
    private boolean memoryButton;
    private JToggleButton currButton;
    private JButton clearButton;
    private boolean tryOpenViaImageJFirst;

    public SeriesBar(int direction, int thumbSize, DicomImagePanel dip) {
        this.init(direction, thumbSize, dip, true, false);
    }

    public SeriesBar(int direction, int thumbSize, DicomImagePanel dip, boolean memoryButton) {
        this.init(direction, thumbSize, dip, memoryButton, false);
    }

    public SeriesBar(int direction, int thumbSize, DicomImagePanel dip, boolean memoryButton, boolean tryOpenViaImageJFirst) {
        this.init(direction, thumbSize, dip, memoryButton, tryOpenViaImageJFirst);
    }

    private void init(int direction, int thumbSize, DicomImagePanel dip, boolean memoryButton, boolean tryOpenViaImageJFirst) {
        this.memoryButton = memoryButton;
        this.tryOpenViaImageJFirst = tryOpenViaImageJFirst;
        this.setLayout(new BorderLayout());
        this.jbuttonbar = new JButtonBar(direction);
        this.dicomImagePanel = dip;
        this.dicomImagePanel.setFilesDropable(false);
        this.jsp = new JScrollPane((Component)this.jbuttonbar);
        this.jsp.getVerticalScrollBar().setUnitIncrement(10);
        this.jsp.getHorizontalScrollBar().setUnitIncrement(10);
        this.jsp.setAutoscrolls(true);
        this.add((Component)this.jsp, "Center");
        this.add((Component)this.getSeriesPanel(), "North");
        this.setMinimumSize(new Dimension(150, 150));
        this.setPreferredSize(new Dimension(200, 200));
        this.imageInMemory = new JCheckBox("Images in Memory", true);
        if (memoryButton) {
            this.add((Component)this.imageInMemory, "South");
        }
        new FileDrop((Component)this, new FileDrop.Listener(){

            public void filesDropped(File[] files) {
                int i = 0;
                while (i < files.length) {
                    if (files[i].isDirectory()) {
                        File[] innerFiles = files[i].listFiles();
                        SeriesBar.this.addSeries(innerFiles);
                    }
                    ++i;
                }
                SeriesBar.this.addSeries(files);
            }
        });
    }

    private JPanel getSeriesPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new GridLayout(1, 2));
        this.nextButton = new JButton(Translatrix.getTranslationString((String)"series.next"));
        this.nextButton.addActionListener(this);
        this.prevButton = new JButton(Translatrix.getTranslationString((String)"series.prev"));
        this.prevButton.addActionListener(this);
        panel.add(this.prevButton);
        panel.add(this.nextButton);
        mainPanel.add((Component)panel, "Center");
        this.clearButton = new JButton(Translatrix.getTranslationString((String)"series.closeAllSeries"));
        this.clearButton.addActionListener(this);
        mainPanel.add((Component)this.clearButton, "South");
        return mainPanel;
    }

    public void addSeries(final File[] files) {
        if (files == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                SeriesBar.this.setCursor(Cursor.getPredefinedCursor(3));
                SeriesBar.this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(3));
                Vector<File[]> seriesFiles = SeriesBar.seperateSeries(files);
                for (File[] files2 : seriesFiles) {
                    Series s = new Series(files2, SeriesBar.this.imageInMemory.isSelected(), SeriesBar.this.tryOpenViaImageJFirst);
                    String actionCommand = s.ID;
                    if (files2.length == 1) {
                        try {
                            actionCommand = String.valueOf(actionCommand) + new DicomHeader(s.imagePlus).getHeaderStringValue(2097171);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (SeriesBar.this.series.containsKey(actionCommand)) continue;
                    if (SeriesBar.this.activeSeries == null) {
                        SeriesBar.this.activeSeries = s;
                        SeriesBar.this.dicomImagePanel.setImage(s.imagePlus);
                        SeriesBar.this.dicomImagePanel.setSeries(SeriesBar.this.activeSeries);
                    }
                    SeriesBar.this.series.put(actionCommand, s);
                    if (s.imagePlus != null) {
                        JToggleButton fileButton = s.button;
                        fileButton.setBorder(new LineBorder(Color.BLACK));
                        fileButton.setActionCommand(actionCommand);
                        fileButton.addActionListener(SeriesBar.this);
                        fileButton.addMouseListener(SeriesBar.this);
                        SeriesBar.this.jbuttonbar.add((Component)fileButton);
                        SeriesBar.this.group.add(fileButton);
                    }
                    SeriesBar.this.jbuttonbar.validate();
                    System.gc();
                }
                SeriesBar.this.jbuttonbar.validate();
                System.gc();
                SeriesBar.this.setCursor(Cursor.getPredefinedCursor(0));
                SeriesBar.this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(0));
            }
        }.start();
    }

    public void addSeries(Collection<byte[]> images) {
        this.addSeries(images, false);
    }

    public void addSeries(final Collection<byte[]> images, boolean selectSeries) {
        new Thread(){

            @Override
            public void run() {
                SeriesBar.this.setCursor(Cursor.getPredefinedCursor(3));
                SeriesBar.this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(3));
                Series s = new Series(images);
                String actionCommand = s.ID;
                if (images.size() == 1) {
                    try {
                        actionCommand = String.valueOf(actionCommand) + new DicomHeader(s.imagePlus).getHeaderStringValue(2097171);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (SeriesBar.this.series.containsKey(actionCommand)) {
                    SeriesBar.this.jbuttonbar.validate();
                    System.gc();
                    SeriesBar.this.setCursor(Cursor.getPredefinedCursor(0));
                    SeriesBar.this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if (SeriesBar.this.activeSeries == null) {
                    SeriesBar.this.activeSeries = s;
                }
                SeriesBar.this.series.put(actionCommand, s);
                if (s.imagePlus != null) {
                    JToggleButton fileButton = s.button;
                    fileButton.setBorder(new LineBorder(Color.BLACK));
                    fileButton.setActionCommand(actionCommand);
                    fileButton.addActionListener(SeriesBar.this);
                    fileButton.addMouseListener(SeriesBar.this);
                    SeriesBar.this.jbuttonbar.add((Component)fileButton);
                    SeriesBar.this.group.add(fileButton);
                    fileButton.doClick();
                }
                SeriesBar.this.jbuttonbar.validate();
                System.gc();
                SeriesBar.this.setCursor(Cursor.getPredefinedCursor(0));
                SeriesBar.this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(0));
            }
        }.start();
    }

    public void removeallSeries() {
        Component[] c = this.jbuttonbar.getComponents();
        this.series.clear();
        int i = 0;
        while (i < c.length) {
            if (c[i] instanceof JToggleButton) {
                this.jbuttonbar.remove(c[i]);
            }
            ++i;
        }
        this.jbuttonbar.removeAll();
        this.jbuttonbar.updateUI();
        this.jbuttonbar.validate();
        this.dicomImagePanel.setImage(null);
        this.dicomImagePanel.setSeries(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.nextButton)) {
            this.showNextImage();
        } else if (e.getSource().equals(this.prevButton)) {
            this.showPreviousImage();
        } else if (e.getSource().equals(this.clearButton)) {
            this.removeallSeries();
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Series s = this.series.get(e.getActionCommand());
                if (s != null) {
                    this.activeSeries = s;
                    this.logger.info((Object)("Loading Series: " + e.getActionCommand()));
                    this.dicomImagePanel.setImage(s.imagePlus);
                    this.dicomImagePanel.setSeries(this.activeSeries);
                } else {
                    this.logger.info((Object)("Error loading Series: " + e.getActionCommand()));
                }
            }
            catch (Error err) {
                err.printStackTrace();
            }
            System.gc();
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void setImagePanel(DicomImagePanel panel) {
        this.dicomImagePanel.setFilesDropable(false);
        this.dicomImagePanel = panel;
    }

    public void showNextImage() {
        if (this.activeSeries == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.activeSeries.next();
            this.dicomImagePanel.setImage(this.activeSeries.imagePlus);
            this.dicomImagePanel.setSeries(this.activeSeries);
        }
        catch (Error err) {
            err.printStackTrace();
        }
        System.gc();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void showPreviousImage() {
        if (this.activeSeries == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.activeSeries.previous();
            this.dicomImagePanel.setImage(this.activeSeries.imagePlus);
            this.dicomImagePanel.setSeries(this.activeSeries);
        }
        catch (Error err) {
            err.printStackTrace();
        }
        System.gc();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void setCurrentSeries(Series s) {
        this.activeSeries = s;
        this.activeSeries.button.setSelected(true);
    }

    public Series getCurrentSeries() {
        return this.activeSeries;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void showPopup(Component c, int x, int y) {
        this.currButton = (JToggleButton)c;
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.popup.add(new AbstractAction(Translatrix.getTranslationString((String)"dicom.SeriesBar.closeSeries")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Series s = (Series)SeriesBar.this.series.get(SeriesBar.this.currButton.getActionCommand());
                        if (s != null) {
                            SeriesBar.this.jbuttonbar.remove((Component)SeriesBar.this.currButton);
                            SeriesBar.this.series.remove(SeriesBar.this.currButton.getActionCommand());
                            SeriesBar.this.jbuttonbar.updateUI();
                            SeriesBar.this.jbuttonbar.validate();
                            SeriesBar.this.logger.info((Object)("Series: " + s.ID + " deleted"));
                            s = null;
                            SeriesBar.this.activeSeries = null;
                            SeriesBar.this.dicomImagePanel.setImage(null);
                            SeriesBar.this.dicomImagePanel.setSeries(null);
                        } else {
                            SeriesBar.this.logger.info((Object)"Error removing Series: ");
                        }
                    }
                    catch (Error err) {
                        err.printStackTrace();
                    }
                }
            });
        }
        this.popup.show(c, x, y);
    }

    public static Vector<File[]> seperateSeries(File[] files2sort) {
        HashMap series = new HashMap();
        try {
            File[] fileArray = files2sort;
            int n = files2sort.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                DicomHeader dh = new DicomHeader(file);
                if (!dh.isEmpty()) {
                    String seriesUID = dh.getHeaderStringValue(0x20000E);
                    int instanceNr = dh.getHeaderIntegerValue(2097171);
                    if (!series.containsKey(seriesUID)) {
                        TreeMap al = new TreeMap();
                        series.put(seriesUID, al);
                    }
                    ((SortedMap)series.get(seriesUID)).put(instanceNr, file);
                }
                ++n2;
            }
        }
        catch (Error e) {
            System.out.println(e);
        }
        Vector<File[]> retVal = new Vector<File[]>();
        for (SortedMap alFiles : series.values()) {
            retVal.add(alFiles.values().toArray(new File[0]));
        }
        return retVal;
    }
}

