/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.viewer;

import com.l2fprod.common.swing.JButtonBar;
import ij.ImagePlus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.viewer.DicomImagePanel;
import org.apache.log4j.Logger;

public class ThumbnailBar
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private int thumbSize;
    private ButtonGroup group;
    private File[] fileArr;
    private DicomImagePanel dicomImagePanel;
    private JButtonBar jbuttonbar;
    private JScrollPane jsp;
    private JToggleButton videoButton;
    private VideoThread vt;
    public boolean videoRunning;
    private JTextField videoSpeed;
    private JCheckBox imageInMemory;
    private HashMap<String, ImagePlus> images = new HashMap();
    private Logger logger = Logger.getLogger((String)"lu.tudor.santec.dicom.gui.viewer.ThumbnailBar");

    public ThumbnailBar(int direction, int thumbSize, DicomImagePanel dip) {
        this.setLayout(new BorderLayout());
        this.jbuttonbar = new JButtonBar(direction);
        this.thumbSize = thumbSize;
        this.dicomImagePanel = dip;
        this.jsp = new JScrollPane((Component)this.jbuttonbar);
        this.jsp.getVerticalScrollBar().setUnitIncrement(10);
        this.jsp.getHorizontalScrollBar().setUnitIncrement(10);
        this.add((Component)this.jsp, "Center");
        this.add((Component)this.getVideoPanel(), "North");
        this.setMinimumSize(new Dimension(thumbSize + 30, thumbSize + 30));
        this.imageInMemory = new JCheckBox("Images in Memory");
        this.add((Component)this.imageInMemory, "South");
    }

    public void setThumbs(File[] files) {
        this.fileArr = files;
        this.group = new ButtonGroup();
        Component[] c = this.jbuttonbar.getComponents();
        int i = 0;
        while (i < c.length) {
            if (c[i] instanceof JToggleButton) {
                this.jbuttonbar.remove(c[i]);
            }
            ++i;
        }
        new Thread(){

            @Override
            public void run() {
                boolean imageSet = false;
                ThumbnailBar.this.setCursor(Cursor.getPredefinedCursor(3));
                ThumbnailBar.this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(3));
                int i = 0;
                while (i < ThumbnailBar.this.fileArr.length) {
                    try {
                        int imageHeight;
                        int imageWidth;
                        double imageRatio;
                        int thumbHeight;
                        int thumbWidth;
                        double thumbRatio;
                        ImagePlus ip = new ImagePlus(ThumbnailBar.this.fileArr[i].getAbsolutePath());
                        if (ThumbnailBar.this.imageInMemory.isSelected()) {
                            ThumbnailBar.this.images.put(ThumbnailBar.this.fileArr[i].getAbsolutePath(), ip);
                        }
                        Image image = ip.getImage();
                        if (!imageSet) {
                            try {
                                ThumbnailBar.this.dicomImagePanel.setImage(ip);
                                imageSet = true;
                            }
                            catch (Error err) {
                                err.printStackTrace();
                            }
                        }
                        if ((thumbRatio = (double)(thumbWidth = ThumbnailBar.this.thumbSize) / (double)(thumbHeight = ThumbnailBar.this.thumbSize)) < (imageRatio = (double)(imageWidth = image.getWidth(null)) / (double)(imageHeight = image.getHeight(null)))) {
                            thumbHeight = (int)((double)thumbWidth / imageRatio);
                        } else {
                            thumbWidth = (int)((double)thumbHeight * imageRatio);
                        }
                        BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
                        Graphics2D graphics2D = thumbImage.createGraphics();
                        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
                        ImageIcon ii = new ImageIcon(thumbImage);
                        if (ii != null) {
                            JToggleButton fileButton = new JToggleButton(ThumbnailBar.this.fileArr[i].getName(), ii);
                            fileButton.setActionCommand(ThumbnailBar.this.fileArr[i].getAbsolutePath());
                            fileButton.addActionListener(ThumbnailBar.this);
                            ThumbnailBar.this.jbuttonbar.add((Component)fileButton);
                            ThumbnailBar.this.group.add(fileButton);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("not an image");
                    }
                    ++i;
                }
                System.gc();
                ThumbnailBar.this.setCursor(Cursor.getPredefinedCursor(0));
                ThumbnailBar.this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(0));
            }
        }.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.videoButton)) {
            if (this.videoButton.isSelected()) {
                this.videoButton.setIcon(DicomIcons.getIcon16("video_pause.png"));
                this.vt = new VideoThread();
                this.vt.start();
            } else {
                this.videoButton.setIcon(DicomIcons.getIcon16("video_play.png"));
                this.videoRunning = false;
                this.vt.interrupt();
            }
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(3));
            try {
                ImagePlus ip = this.images.get(e.getActionCommand());
                if (ip == null) {
                    this.logger.info((Object)"Loading image from File System");
                    ip = new ImagePlus(e.getActionCommand());
                } else {
                    this.logger.info((Object)"Loading image from Memory");
                }
                this.dicomImagePanel.setImage(ip);
            }
            catch (Error err) {
                err.printStackTrace();
            }
            System.gc();
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.dicomImagePanel.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public JPanel getVideoPanel() {
        JPanel videoPanel = new JPanel(new GridLayout(1, 2));
        this.videoButton = new JToggleButton(DicomIcons.getIcon16("video_play.png"));
        this.videoButton.addActionListener(this);
        this.videoSpeed = new JTextField();
        this.videoSpeed.setText("200");
        videoPanel.add(this.videoButton);
        videoPanel.add(this.videoSpeed);
        return videoPanel;
    }

    public void setImagePanel(DicomImagePanel panel) {
        this.dicomImagePanel = panel;
    }

    public class VideoThread
    extends Thread {
        @Override
        public void run() {
            ThumbnailBar.this.videoRunning = true;
            Component[] c = ThumbnailBar.this.jbuttonbar.getComponents();
            block2: while (true) {
                int i = 0;
                while (true) {
                    if (i >= c.length) continue block2;
                    if (!ThumbnailBar.this.videoRunning) {
                        return;
                    }
                    if (c[i] instanceof JToggleButton) {
                        ((JToggleButton)c[i]).doClick();
                        try {
                            Thread.sleep(Integer.parseInt(ThumbnailBar.this.videoSpeed.getText()));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }
}

