/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ProgressMonitorInputStream;
import lu.tudor.santec.dicom.DicomOpener;
import lu.tudor.santec.dicom.anonymizer.DicomAnonymizerGui;
import lu.tudor.santec.dicom.gui.DICOMSettingsPlugin;
import lu.tudor.santec.dicom.gui.DICOMWebViewSettingsPlugin;
import lu.tudor.santec.dicom.gui.DicomFileDialog;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.DicomImageDiffDialog;
import lu.tudor.santec.dicom.gui.DiskspaceMonitorButton;
import lu.tudor.santec.dicom.gui.MemoryMonitorButton;
import lu.tudor.santec.dicom.gui.header.DicomHeaderDiffDialog;
import lu.tudor.santec.dicom.gui.header.selector.HeaderdataEvaluator;
import lu.tudor.santec.dicom.gui.viewer.DicomImage3DViewer;
import lu.tudor.santec.dicom.gui.viewer.DicomImageAngleMeasurement;
import lu.tudor.santec.dicom.gui.viewer.DicomImageHistogramViewerPlugin;
import lu.tudor.santec.dicom.gui.viewer.DicomImageInterpolator;
import lu.tudor.santec.dicom.gui.viewer.DicomImageInverter;
import lu.tudor.santec.dicom.gui.viewer.DicomImageMeasurement;
import lu.tudor.santec.dicom.gui.viewer.DicomImagePanel;
import lu.tudor.santec.dicom.gui.viewer.DicomImageROI;
import lu.tudor.santec.dicom.gui.viewer.SeriesBar;
import lu.tudor.santec.dicom.gui.viewer.SliceListener;
import lu.tudor.santec.dicom.receiver.DicomRXListener;
import lu.tudor.santec.i18n.SwingLocalizer;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.I18nPlugin;
import lu.tudor.santec.settings.LoggingPlugin;
import lu.tudor.santec.settings.SettingsPanel;
import lu.tudor.santec.settings.SettingsPlugin;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Viewer
extends JFrame
implements ActionListener,
FocusListener,
SliceListener {
    public static final String VERSION = "1.9.23";
    private Logger logger = Logger.getLogger((String)Viewer.class.getName());
    private static final long serialVersionUID = 1L;
    private JButton showSettings;
    private JButton infoButton;
    private SettingsPanel settings;
    private DICOMSettingsPlugin dicomPlugin;
    private I18nPlugin i18nPlugin;
    private DicomFileDialog dicomFileDialog;
    private JButton inputButton;
    private JToolBar toolBar;
    private JButton helpButton;
    private DicomImagePanel[] imagePanels;
    private JToolBar imageToolBar;
    private JPanel imageToolBarPanel = new JPanel(new GridLayout(1, 1));
    private SeriesBar seriesBar;
    private JToolBar settingBar;
    private JToggleButton screen1;
    private JToggleButton screen2v;
    private JToggleButton screen2h;
    private JToggleButton screen4;
    private JPanel screenPanel;
    private DicomImagePanel activeScreen;
    private Properties screenSettings = new Properties();
    protected String splitscreen;
    private ActionListener layoutSwitcher;
    private JToggleButton three_monitor;
    private static final String infoMessage = "<html><h1>SANTEC/TUDOR Dicom Viewer 1.9.23</h1><h3>Centre de Recherche Public Henri Tudor<br>Department: Santec www.santec.tudor.lu<br>29, Avenue John F. Kennedy, L-1855 Luxembourg - Kirchberg<h3>written by Johannes Hermen johannes.hermen@tudor.lu<br>Distributable under LGPL license - (c) 2012 Tudor/Santec<br>Visit http://www.santec.tudor.lu/project/dicom for Infos and Updates<br><br>the following libraries were used to build and run this project:<br><ul><li><p>dcm4che2: A OpenSource DICOM Toolkit<br>http://sourceforge.net/projects/dcm4che/<br>&nbsp;</p></li><li><p>ImageJ: Image Processing and Analysis in Java<br>http://rsb.info.nih.gov/ij/<br>&nbsp;</p></li><li><p>FormLayout: Build better screens faster<br>http://www.jgoodies.com/freeware/forms/<br>&nbsp;</p></li><li><p>ImageJ 3D Viewer: An OpenSource 3D Viewer for ImageJ<br>http://3dviewer.neurofly.de/<br>&nbsp;</p></li></ul>Thanks to the following persons for providing patches, bugreports and translations:<br><ul><li><p>David Pinelle, University of Saskatchewan [patches and new features for export and headerhandling]</p></li><li><p>Dante Brunini [italian translation]</p></li><li><p>Juan Miguel Boyero Corral and dgilperez [spanish translation]</p></li></ul>";
    private static final File SCREENPROPERTY_FILE = new File("screensettings.properties");
    private static final File PLUGIN_FILE = new File("DicomViewer.plugins");
    private static final String MAIN_LOCATION_X = "MAIN_LOCATION_X";
    private static final String MAIN_LOCATION_Y = "MAIN_LOCATION_Y";
    private static final String MAIN_WIDTH = "MAIN_WIDTH";
    private static final String MAIN_HEIGHT = "MAIN_HEIGHT";
    private static final String SPLITSCREEN = "SPLITSCREEN";
    private static final String EXTENDED_STATE = "EXTENDED_STATE";
    JDialog[] dialogs = new JDialog[]{new JDialog(), new JDialog()};
    private JButton headerDiffButton;
    private JButton anonButton;
    private JButton headerdataButton;
    private JButton imageDiffButton;
    private Vector<String> enabledPlugins = new Vector();
    private Vector<String> disabledPlugins = new Vector();

    public Viewer(boolean exitOnCLose, DicomFileDialog dicomDialog, SettingsPanel settings, DICOMSettingsPlugin dicomPlugin) {
        super("SANTEC/TUDOR DICOM Viewer 1.9.23");
        this.dicomFileDialog = dicomDialog;
        this.settings = settings;
        this.dicomPlugin = dicomPlugin;
        if (exitOnCLose) {
            this.setDefaultCloseOperation(3);
        } else {
            this.setDefaultCloseOperation(2);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Viewer.this.saveSettings();
                if (Viewer.this.dicomFileDialog != null && ((Viewer)Viewer.this).dicomFileDialog.pacsPanel != null) {
                    ((Viewer)Viewer.this).dicomFileDialog.pacsPanel.stopDicomServer();
                }
                Viewer.this.dicomFileDialog = null;
                Viewer.this.settings = null;
            }
        });
        this.buildPanel();
        if (exitOnCLose) {
            Logger.getLogger((String)"lu.tudor.santec.dicom.query").setLevel(Level.WARN);
        }
    }

    public Viewer(boolean exitOnCLose) {
        super("SANTEC/TUDOR DICOM Viewer 1.9.23");
        if (exitOnCLose) {
            this.setDefaultCloseOperation(3);
        } else {
            this.setDefaultCloseOperation(2);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Viewer.this.saveSettings();
                if (Viewer.this.dicomFileDialog != null && ((Viewer)Viewer.this).dicomFileDialog.pacsPanel != null) {
                    ((Viewer)Viewer.this).dicomFileDialog.pacsPanel.stopDicomServer();
                }
                Viewer.this.dicomFileDialog = null;
                Viewer.this.settings = null;
            }
        });
        this.buildPanel();
        if (exitOnCLose) {
            Logger.getLogger((String)"lu.tudor.santec.dicom.query").setLevel(Level.WARN);
        }
    }

    public Viewer(boolean exitOnCLose, String[] fileNames) {
        super("SANTEC/TUDOR DICOM Viewer 1.9.23");
        if (exitOnCLose) {
            this.setDefaultCloseOperation(3);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Viewer.this.saveSettings();
                    if (Viewer.this.dicomFileDialog != null && ((Viewer)Viewer.this).dicomFileDialog.pacsPanel != null) {
                        ((Viewer)Viewer.this).dicomFileDialog.pacsPanel.stopDicomServer();
                    }
                    Viewer.this.dicomFileDialog = null;
                    Viewer.this.settings = null;
                }
            });
        } else {
            this.setDefaultCloseOperation(2);
        }
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                System.out.println("closing");
                if (Viewer.this.dicomFileDialog != null && ((Viewer)Viewer.this).dicomFileDialog.pacsPanel != null) {
                    ((Viewer)Viewer.this).dicomFileDialog.pacsPanel.stopDicomServer();
                }
                Viewer.this.dicomFileDialog = null;
                Viewer.this.settings = null;
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                System.out.println("hidden");
                Viewer.this.clear();
            }
        });
        this.buildPanel();
        if (exitOnCLose) {
            Logger.getLogger((String)"lu.tudor.santec.dicom.query").setLevel(Level.WARN);
        }
        ArrayList<File> images = new ArrayList<File>();
        int i = 0;
        while (i < fileNames.length) {
            String fileName = fileNames[i];
            System.out.println("loading image(s): " + fileName);
            if (fileName.endsWith(".zip")) {
                try {
                    ZipEntry entry;
                    ArrayList<File> zipImages = new ArrayList<File>();
                    InputStream is = null;
                    try {
                        URL url = new URL(fileName);
                        is = url.openStream();
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        is = new FileInputStream(fileName);
                    }
                    ZipInputStream zis = new ZipInputStream(new ProgressMonitorInputStream(this, "loading images", is));
                    while ((entry = zis.getNextEntry()) != null) {
                        File f = this.createTempFile(zis);
                        if (f.length() < 10L) continue;
                        zipImages.add(f);
                    }
                    zis.close();
                    System.out.println("found " + zipImages.size() + " images");
                    this.seriesBar.addSeries(zipImages.toArray(new File[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.logger.info((Object)("loading file: " + fileName));
                InputStream is = null;
                try {
                    URL url = new URL(fileName);
                    is = url.openStream();
                    File f = this.createTempFile(is);
                    images.add(f);
                    this.seriesBar.addSeries(images.toArray(new File[0]));
                    images.clear();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    images.add(new File(fileName));
                    this.seriesBar.addSeries(images.toArray(new File[0]));
                    images.clear();
                }
            }
            ++i;
        }
    }

    private File createTempFile(InputStream zis) {
        int count = 0;
        try {
            byte[] data = new byte[2048];
            File f = File.createTempFile("dicomViewer", ".dcm");
            f.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(f);
            BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
            while ((count = zis.read(data, 0, 2048)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            return f;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setFiles(File[] files) {
        this.seriesBar.addSeries(files);
    }

    public void clear() {
        this.seriesBar.removeallSeries();
    }

    public static void main(String[] args) {
        new Viewer(true, args);
        System.out.println("done..........");
    }

    private void center(JFrame parent, JDialog dialog) {
        Dimension f = parent.getSize();
        int posX = parent.getX();
        int posY = parent.getY();
        dialog.setLocation(posX + f.width / 2 - dialog.getSize().width / 2, posY + f.height / 2 - dialog.getSize().height / 2);
    }

    private void buildPanel() {
        try {
            this.loadAvailableModules(PLUGIN_FILE.toURL());
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        int i = 0;
        while (i < this.dialogs.length) {
            this.dialogs[i].setTitle("Screen " + (i + 1));
            this.dialogs[i].setLayout(new BorderLayout());
            this.dialogs[i].setDefaultCloseOperation(0);
            ++i;
        }
        try {
            Translatrix.addBundle((String)"lu.tudor.santec.settings.resources.WidgetResources");
            Translatrix.addBundle((String)"lu.tudor.santec.dicom.gui.resources.WidgetResources");
            Translatrix.addBundle((String)SwingLocalizer.getBundle());
            Translatrix.setDefaultWhenMissing((boolean)true);
            SwingLocalizer.localizeJFileChooser();
            SwingLocalizer.localizeJOptionPane();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setIconImage(DicomIcons.getImage("dicom_viewer_64.png", 22));
        this.getContentPane().setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        this.settingBar = new JToolBar();
        this.buildSettings();
        this.showSettings = new JButton(DicomIcons.getIcon("icon_settings.png"));
        this.showSettings.setToolTipText("Show Settings Dialog");
        this.showSettings.addActionListener(this);
        this.buildInput();
        this.inputButton = this.dicomFileDialog.getToolBarButton();
        this.inputButton.addActionListener(this);
        this.toolBar.add(this.inputButton);
        this.infoButton = new JButton(DicomIcons.getIcon("icon_info.png"));
        this.infoButton.setToolTipText("Show Info Dialog");
        this.infoButton.addActionListener(this);
        this.helpButton = new JButton(DicomIcons.getIcon("icon_help.png"));
        this.helpButton.setToolTipText("Show Help Dialog");
        this.helpButton.addActionListener(this);
        this.layoutSwitcher = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewer.this.screen1.setSelected(false);
                Viewer.this.screen2h.setSelected(false);
                Viewer.this.screen2v.setSelected(false);
                Viewer.this.screen4.setSelected(false);
                Viewer.this.three_monitor.setSelected(false);
                Viewer.this.screenPanel.removeAll();
                Viewer.this.splitscreen = e.getActionCommand();
                if (e.getActionCommand().equals("screen1")) {
                    Viewer.this.screen1.setSelected(true);
                    Viewer.this.screenPanel.setLayout(new GridLayout(1, 1));
                    Viewer.this.createImagePanels(1, 800, 800, false);
                } else if (e.getActionCommand().equals("screen2h")) {
                    Viewer.this.screen2h.setSelected(true);
                    Viewer.this.screenPanel.setLayout(new GridLayout(2, 1));
                    Viewer.this.createImagePanels(2, 800, 400, false);
                } else if (e.getActionCommand().equals("screen2v")) {
                    Viewer.this.screen2v.setSelected(true);
                    Viewer.this.screenPanel.setLayout(new GridLayout(1, 2));
                    Viewer.this.createImagePanels(2, 400, 800, false);
                } else if (e.getActionCommand().equals("screen4")) {
                    Viewer.this.screen4.setSelected(true);
                    Viewer.this.screenPanel.setLayout(new GridLayout(2, 2));
                    Viewer.this.createImagePanels(4, 400, 400, false);
                } else if (e.getActionCommand().equals("three_monitor")) {
                    Viewer.this.three_monitor.setSelected(true);
                    Viewer.this.screenPanel.setLayout(new GridLayout(1, 1));
                    Viewer.this.createImagePanels(2, 800, 800, true);
                }
                Viewer.this.screenPanel.validate();
            }
        };
        this.toolBar.addSeparator();
        this.screen1 = new JToggleButton(DicomIcons.getIcon("screens_1.png"));
        this.screen1.setToolTipText("1 Screen");
        this.screen1.setSelected(true);
        this.screen1.setActionCommand("screen1");
        this.screen1.addActionListener(this.layoutSwitcher);
        this.toolBar.add(this.screen1);
        this.screen2v = new JToggleButton(DicomIcons.getIcon("screens_2v.png"));
        this.screen2v.setToolTipText("2 Screens Vertical");
        this.screen2v.setActionCommand("screen2v");
        this.screen2v.addActionListener(this.layoutSwitcher);
        this.toolBar.add(this.screen2v);
        this.screen2h = new JToggleButton(DicomIcons.getIcon("screens_2h.png"));
        this.screen2h.setToolTipText("2 Screens Horizontal");
        this.screen2h.setActionCommand("screen2h");
        this.screen2h.addActionListener(this.layoutSwitcher);
        this.toolBar.add(this.screen2h);
        this.screen4 = new JToggleButton(DicomIcons.getIcon("screens_4.png"));
        this.screen4.setToolTipText("4 Screens");
        this.screen4.setActionCommand("screen4");
        this.screen4.addActionListener(this.layoutSwitcher);
        this.toolBar.add(this.screen4);
        this.three_monitor = new JToggleButton(DicomIcons.getIcon("3display.png"));
        this.three_monitor.setToolTipText("3 Monitors");
        this.three_monitor.setActionCommand("three_monitor");
        this.three_monitor.addActionListener(this.layoutSwitcher);
        this.toolBar.add(this.three_monitor);
        this.toolBar.addSeparator();
        this.anonButton = new JButton(DicomIcons.getIcon("anon_header.png"));
        this.anonButton.setToolTipText("Anonymize DICOM Files");
        this.anonButton.addActionListener(this);
        this.toolBar.add(this.anonButton);
        this.headerDiffButton = new JButton(DicomIcons.getIcon("action_diff.png"));
        this.headerDiffButton.setToolTipText("Compare DICOM Headers");
        this.headerDiffButton.addActionListener(this);
        this.toolBar.add(this.headerDiffButton);
        this.imageDiffButton = new JButton(DicomIcons.getIcon("action_diff_images.png"));
        this.imageDiffButton.setToolTipText("Compare DICOM Images");
        this.imageDiffButton.addActionListener(this);
        this.toolBar.add(this.imageDiffButton);
        this.headerdataButton = new JButton(DicomIcons.getIcon("headerdata_eval.png"));
        this.headerdataButton.setToolTipText(Translatrix.getTranslationString((String)"TagSelectorDialog.title"));
        this.headerdataButton.addActionListener(this);
        this.toolBar.add(this.headerdataButton);
        this.settingBar.add(this.showSettings);
        this.settingBar.add(this.infoButton);
        this.settingBar.add(this.helpButton);
        this.settingBar.addSeparator();
        this.settingBar.add(new DiskspaceMonitorButton(new File((String)this.dicomPlugin.getValue("RecDir")), true));
        this.settingBar.add(new MemoryMonitorButton(true, true));
        JPanel toolBarPanel = new JPanel(new BorderLayout());
        toolBarPanel.add((Component)this.toolBar, "Center");
        toolBarPanel.add((Component)this.settingBar, "East");
        this.getContentPane().add((Component)toolBarPanel, "North");
        this.screenPanel = new JPanel(new GridLayout(1, 1));
        this.layoutSwitcher.actionPerformed(new ActionEvent(this, 0, "screen1"));
        this.seriesBar = new SeriesBar(1, 96, this.activeScreen.parentPanel, false, (Boolean)this.dicomPlugin.getValue("TRY_OPEN_VIA_IMAGEJ"));
        this.getContentPane().add((Component)this.screenPanel, "Center");
        this.getContentPane().add((Component)this.imageToolBarPanel, "West");
        this.getContentPane().add((Component)this.seriesBar, "East");
        this.pack();
        this.loadSettings();
        Locale locale = Locale.getDefault();
        try {
            locale = (Locale)this.i18nPlugin.getValue("Locale");
            if (locale == null) {
                Translatrix.setLocale((String)"en_US");
            } else {
                Translatrix.setLocale((Locale)locale);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Locale.setDefault(Translatrix.getLocale());
        this.settings.relocalize();
        SwingLocalizer.localizeJOptionPane();
        SwingLocalizer.localizeJFileChooser();
        if (this.dicomFileDialog.pacsPanel != null) {
            DicomRXListener dl = new DicomRXListener(5L){

                @Override
                protected void seriesReceived(String seriesUID, File folder) {
                    System.out.println("\n\nSeries Received: " + seriesUID + " in folder: " + folder.getAbsolutePath() + "\n\n");
                    if (((Viewer)Viewer.this).dicomFileDialog.dicomQueryPanel.isOpenOnReceive()) {
                        try {
                            Viewer.this.seriesBar.addSeries(folder.listFiles());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }

                @Override
                protected void studyReceived(String studyUID, File folder) {
                    System.out.println("\n\nStudy Received: " + studyUID + " in folder: " + folder.getAbsolutePath() + "\n\n");
                }

                @Override
                protected void imageReceived(String sopUID, File image) {
                }
            };
            this.dicomFileDialog.pacsPanel.addDicomListener(dl);
        }
        this.setVisible(true);
    }

    private void createImagePanels(int anz, int width, int height, boolean external) {
        this.imagePanels = new DicomImagePanel[anz];
        String[] dicomFields = ((String)this.dicomPlugin.getValue("DicomFields")).split("\n");
        int i = 0;
        while (i < anz) {
            DicomImagePanel imageArea = new DicomImagePanel(10, 10, true, false, false);
            this.imagePanels[i] = imageArea.createBigArea();
            this.imagePanels[i].setImageSize(width, height);
            this.imagePanels[i].addFocusListener(this);
            this.imagePanels[i].setShowDicomInfos(true);
            this.imagePanels[i].setDicomInfos(dicomFields);
            if (this.enabledPlugins.size() > 0) {
                for (String plugin : this.enabledPlugins) {
                    try {
                        Class<?> clazz = Class.forName(plugin);
                        Constructor<?> constructor = clazz.getConstructor(DicomImagePanel.class);
                        if (clazz.equals(DicomImage3DViewer.class)) {
                            try {
                                constructor.newInstance(imageArea);
                            }
                            catch (Exception e) {
                                this.logger.warn((Object)"No Java 3D installed, Not loading DicomImage3DViewer");
                            }
                            continue;
                        }
                        constructor.newInstance(imageArea);
                    }
                    catch (Exception e) {
                        this.logger.log((Priority)Level.WARN, (Object)("Error loading plugin: " + plugin), (Throwable)e);
                    }
                }
            } else {
                try {
                    new DicomImage3DViewer(imageArea);
                }
                catch (Exception e) {
                    this.logger.warn((Object)"No Java 3D installed, Not loading DicomImage3DViewer");
                }
                new DicomImageMeasurement(imageArea);
                new DicomImageAngleMeasurement(imageArea);
                new DicomImageROI(imageArea);
                new DicomImageHistogramViewerPlugin(imageArea);
                new DicomImageInverter(imageArea);
                new DicomImageInterpolator(imageArea);
            }
            this.imagePanels[i].setSliceListener(this);
            if (!external) {
                this.screenPanel.add(this.imagePanels[i]);
            } else {
                try {
                    this.dialogs[i].getContentPane().remove(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.dialogs[i].getContentPane().add(this.imagePanels[i]);
                this.dialogs[i].setSize(800, 800);
                this.dialogs[i].setVisible(true);
            }
            ++i;
        }
        if (!external) {
            i = 0;
            while (i < this.dialogs.length) {
                this.dialogs[i].setVisible(false);
                ++i;
            }
        } else {
            this.setSize(267, this.getWidth());
            this.setExtendedState(4);
        }
        this.activeScreen = this.imagePanels[0];
        try {
            this.imageToolBarPanel.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.imageToolBar = this.activeScreen.createToolBar();
        this.imageToolBarPanel.add(this.imageToolBar);
        this.imageToolBarPanel.validate();
        if (this.seriesBar != null) {
            this.seriesBar.setImagePanel(this.activeScreen.parentPanel);
        }
    }

    private void buildSettings() {
        if (this.settings != null) {
            return;
        }
        Translatrix.loadSupportedLocales((String)"lu.tudor.santec.dicom.gui.resources.supportedLocales");
        this.settings = new SettingsPanel((Frame)this);
        I18nPlugin i18nPlugin = new I18nPlugin("i18n");
        this.settings.addPlugin((SettingsPlugin)i18nPlugin);
        this.dicomPlugin = new DICOMSettingsPlugin("dicom");
        this.settings.addPlugin((SettingsPlugin)this.dicomPlugin);
        LoggingPlugin loggingPlugin = new LoggingPlugin("logging");
        this.settings.addPlugin((SettingsPlugin)loggingPlugin);
        DICOMWebViewSettingsPlugin dicomWebViewPlugin = new DICOMWebViewSettingsPlugin("dicomwebview");
        this.settings.addPlugin((SettingsPlugin)dicomWebViewPlugin);
        File f = new File("settings.xml");
        if (System.getProperty("deployment.javaws.home.jnlp.url") != null) {
            f = new File(System.getProperty("user.home"), "settings.url");
            this.settings.setValue("dicom", "RecEnabled", (Object)false);
        }
        this.settings.setSettingsFile(f);
        this.settings.loadSettings();
    }

    private void buildInput() {
        if (this.dicomFileDialog == null) {
            this.dicomFileDialog = new DicomFileDialog(this, this.settings, this.dicomPlugin);
        }
    }

    private void buildInfo() {
        JOptionPane.showMessageDialog(this, "<html><h1>SANTEC/TUDOR Dicom Viewer 1.9.23</h1><h3>Centre de Recherche Public Henri Tudor<br>Department: Santec www.santec.tudor.lu<br>29, Avenue John F. Kennedy, L-1855 Luxembourg - Kirchberg<h3>written by Johannes Hermen johannes.hermen@tudor.lu<br>Distributable under LGPL license - (c) 2012 Tudor/Santec<br>Visit http://www.santec.tudor.lu/project/dicom for Infos and Updates<br><br>the following libraries were used to build and run this project:<br><ul><li><p>dcm4che2: A OpenSource DICOM Toolkit<br>http://sourceforge.net/projects/dcm4che/<br>&nbsp;</p></li><li><p>ImageJ: Image Processing and Analysis in Java<br>http://rsb.info.nih.gov/ij/<br>&nbsp;</p></li><li><p>FormLayout: Build better screens faster<br>http://www.jgoodies.com/freeware/forms/<br>&nbsp;</p></li><li><p>ImageJ 3D Viewer: An OpenSource 3D Viewer for ImageJ<br>http://3dviewer.neurofly.de/<br>&nbsp;</p></li></ul>Thanks to the following persons for providing patches, bugreports and translations:<br><ul><li><p>David Pinelle, University of Saskatchewan [patches and new features for export and headerhandling]</p></li><li><p>Dante Brunini [italian translation]</p></li><li><p>Juan Miguel Boyero Corral and dgilperez [spanish translation]</p></li></ul><hr>" + DicomOpener.getJavaImageInfos().replaceAll("\n", "<br>"), "Info: Tudor DICOM Viewer", 1, DicomIcons.getIcon("icon_info.png"));
    }

    private void buildHelp() {
        JDialog dialog = new JDialog((Frame)this, "Help: Simple DICOM Viewer");
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        try {
            editorPane.setPage(DicomIcons.class.getResource("resources/dicomviewer.html"));
            JScrollPane editorScrollPane = new JScrollPane(editorPane);
            dialog.getContentPane().add(editorScrollPane);
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(600, 600);
            dialog.setVisible(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.showSettings)) {
            this.settings.setSize(650, 650);
            this.center(this, (JDialog)this.settings);
            this.settings.setVisible(true);
        } else if (e.getSource().equals(this.inputButton)) {
            this.importFiles();
        } else if (e.getSource().equals(this.infoButton)) {
            this.buildInfo();
        } else if (e.getSource().equals(this.helpButton)) {
            this.buildHelp();
        } else if (e.getSource().equals(this.headerDiffButton)) {
            new DicomHeaderDiffDialog(this.dicomFileDialog);
        } else if (e.getSource().equals(this.imageDiffButton)) {
            new DicomImageDiffDialog(this.dicomFileDialog);
        } else if (e.getSource().equals(this.anonButton)) {
            new DicomAnonymizerGui(false);
        } else if (e.getSource().equals(this.headerdataButton)) {
            HeaderdataEvaluator evaluator = new HeaderdataEvaluator(this, this.dicomFileDialog);
            evaluator.setViewer(this);
            evaluator.showDialog(null);
        }
    }

    public void importFiles() {
        new Thread(){

            @Override
            public void run() {
                Vector filterTags = null;
                if (Viewer.this.dicomFileDialog.showNewDialog(Viewer.this, filterTags) == 0) {
                    if (((Viewer)Viewer.this).dicomFileDialog.singleFileSelected) {
                        File[] fArr = new File[]{Viewer.this.dicomFileDialog.getSelectedFile()};
                        Viewer.this.seriesBar.addSeries(fArr);
                    } else {
                        Viewer.this.seriesBar.addSeries(Viewer.this.dicomFileDialog.getSelectedFiles());
                    }
                }
            }
        }.start();
    }

    public void setWaitCursor(boolean on) {
        if (on) {
            this.getGlassPane().setVisible(true);
            this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            this.getGlassPane().setVisible(false);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        try {
            this.imageToolBarPanel.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.activeScreen = (DicomImagePanel)e.getSource();
        this.imageToolBar = this.activeScreen.createToolBar();
        this.imageToolBarPanel.add(this.imageToolBar);
        this.imageToolBarPanel.validate();
        try {
            this.seriesBar.setCurrentSeries(this.activeScreen.parentPanel.getSeries());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.seriesBar.setImagePanel(this.activeScreen.parentPanel);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void nextSlice() {
        this.seriesBar.showNextImage();
    }

    @Override
    public void previousSlice() {
        this.seriesBar.showPreviousImage();
    }

    private void loadSettings() {
        try {
            this.screenSettings.load(new FileInputStream(SCREENPROPERTY_FILE));
            this.setLocation(Integer.parseInt(this.screenSettings.getProperty(MAIN_LOCATION_X)), Integer.parseInt(this.screenSettings.getProperty(MAIN_LOCATION_Y)));
            this.setSize(Integer.parseInt(this.screenSettings.getProperty(MAIN_WIDTH)), Integer.parseInt(this.screenSettings.getProperty(MAIN_HEIGHT)));
            this.layoutSwitcher.actionPerformed(new ActionEvent(this, 0, this.screenSettings.getProperty(SPLITSCREEN)));
            int i = 0;
            while (i < this.dialogs.length) {
                this.dialogs[i].setLocation(Integer.parseInt(this.screenSettings.getProperty("DIALOG_" + i + "_LOCATION_X")), Integer.parseInt(this.screenSettings.getProperty("DIALOG_" + i + "_LOCATION_Y")));
                this.dialogs[i].setSize(Integer.parseInt(this.screenSettings.getProperty("DIALOG_" + i + "_WIDTH")), Integer.parseInt(this.screenSettings.getProperty("DIALOG_" + i + "_HEIGHT")));
                ++i;
            }
            if (this.screenSettings.containsKey(EXTENDED_STATE)) {
                this.setExtendedState(Integer.parseInt(this.screenSettings.getProperty(EXTENDED_STATE)));
            } else {
                this.setExtendedState(6);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Screensettings not found at: " + SCREENPROPERTY_FILE + " ...creating next time...");
            this.setExtendedState(6);
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    private void saveSettings() {
        try {
            this.screenSettings.put(EXTENDED_STATE, String.valueOf(this.getExtendedState()));
            this.screenSettings.put(MAIN_LOCATION_X, String.valueOf(this.getLocation().x));
            this.screenSettings.put(MAIN_LOCATION_Y, String.valueOf(this.getLocation().y));
            this.screenSettings.put(MAIN_WIDTH, String.valueOf(this.getWidth()));
            this.screenSettings.put(MAIN_HEIGHT, String.valueOf(this.getHeight()));
            this.screenSettings.put(SPLITSCREEN, this.splitscreen);
            int i = 0;
            while (i < this.dialogs.length) {
                this.screenSettings.put("DIALOG_" + i + "_LOCATION_X", String.valueOf(this.dialogs[i].getLocation().x));
                this.screenSettings.put("DIALOG_" + i + "_LOCATION_Y", String.valueOf(this.dialogs[i].getLocation().y));
                this.screenSettings.put("DIALOG_" + i + "_WIDTH", String.valueOf(this.dialogs[i].getWidth()));
                this.screenSettings.put("DIALOG_" + i + "_HEIGHT", String.valueOf(this.dialogs[i].getHeight()));
                ++i;
            }
            this.screenSettings.store(new FileOutputStream(SCREENPROPERTY_FILE), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadAvailableModules(URL url) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = new String();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.length() <= 3) continue;
                try {
                    String[] fields = line.split("=");
                    if (fields[1].toLowerCase().equals("on")) {
                        this.enabledPlugins.add(fields[0]);
                        continue;
                    }
                    this.disabledPlugins.add(fields[0]);
                }
                catch (Exception e) {
                    this.logger.log((Priority)Level.WARN, (Object)("line is no valid settingline: " + line));
                }
            }
        }
        catch (FileNotFoundException e) {
            this.logger.log((Priority)Level.INFO, (Object)("No plugins file found at " + url));
        }
        catch (Exception e) {
            this.logger.log((Priority)Level.WARN, (Object)"error parsing file ", (Throwable)e);
        }
    }
}

