/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.receiver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.xml.transform.TransformerConfigurationException;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.receiver.MyExtendedApplicationProfile;
import lu.tudor.santec.dicom.receiver.StudyObject;
import org.apache.log4j.Logger;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.StopTagInputHandler;
import org.dcm4che2.media.ApplicationProfile;
import org.dcm4che2.media.DicomDirWriter;
import org.dcm4che2.media.FileSetInformation;

public class DicomDirReader {
    static final Logger log = Logger.getLogger((String)"DicomDirReader");
    private File STORE_DIR = null;
    public static final String LEVEL_PATIENT = "PATIENT";
    public static final String LEVEL_STUDY = "STUDY";
    public static final String LEVEL_SERIES = "SERIES";
    public static final String LEVEL_IMAGE = "IMAGE";
    private static final String[] QRLEVEL = new String[]{"PATIENT", "STUDY", "SERIES", "IMAGE"};
    private static final int[] DICOM_DIR_NAMING = new int[]{0x100010, 524384, 524320, 524336, 0x200010, 0x200011, 524312};
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("win");
    private org.dcm4che2.media.DicomDirReader dicomDir;
    private int qrLevel;
    private Vector<DicomObject> foundRecords = new Vector();
    private FileSetInformation fsinfo;
    private ApplicationProfile ap = new MyExtendedApplicationProfile();
    private boolean checkDuplicate = true;

    public boolean loadDicomDirFile(File dirFile, boolean create, boolean writeable) {
        log.info((Object)("loading DICOMDIR: \"" + dirFile.getAbsolutePath() + "\""));
        this.STORE_DIR = dirFile;
        try {
            block10: {
                if (create) {
                    File rootDir = this.STORE_DIR.getParentFile();
                    if (rootDir != null && !rootDir.exists()) {
                        rootDir.mkdirs();
                    }
                    try {
                        if (this.STORE_DIR.exists()) {
                            this.dicomDir = new DicomDirWriter(this.STORE_DIR);
                            log.info((Object)("Loading DICOMDIR at: " + this.STORE_DIR.getParentFile() + "  ----------------------------"));
                            break block10;
                        }
                        this.dicomDir = new DicomDirWriter(this.STORE_DIR, this.fsinfo());
                        log.info((Object)("Creating DICOMDIR at: " + this.STORE_DIR.getParentFile() + "  ----------------------------"));
                    }
                    catch (Exception e) {
                        log.info((Object)("Error starting DicomdirWriter: \"" + dirFile + "\"  " + e.getMessage()));
                    }
                } else if (writeable && this.STORE_DIR.exists()) {
                    this.dicomDir = new DicomDirWriter(this.STORE_DIR);
                    log.info((Object)("Loading DICOMDIR at: " + this.STORE_DIR.getParentFile() + "  ----------------------------"));
                } else {
                    this.dicomDir = new org.dcm4che2.media.DicomDirReader(dirFile);
                }
            }
            this.dicomDir.setShowInactiveRecords(false);
        }
        catch (Exception e) {
            log.info((Object)("Error loading Dicomdir: The File: \"" + dirFile + "\"" + " does not exits, or is no dicomdir"));
            return false;
        }
        return true;
    }

    public boolean isOK() {
        return this.dicomDir != null;
    }

    public Vector<DicomObject> getPatients() {
        Vector<DicomObject> patientVector = new Vector<DicomObject>();
        log.info((Object)"reading patient records:");
        try {
            DicomObject next = this.dicomDir.findFirstRootRecord();
            while (next != null) {
                if (LEVEL_PATIENT.equals(next.getString(267312))) {
                    try {
                        patientVector.add(next);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error getting Patients: " + e.getLocalizedMessage()));
                    }
                }
                next = this.dicomDir.findNextSiblingRecord(next);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Error getting Patients: " + e.getLocalizedMessage()));
        }
        return patientVector;
    }

    public Vector<DicomObject> getStudiesFromPatients(DicomObject patientRecord) {
        Vector<DicomObject> studyVector = new Vector<DicomObject>();
        log.info((Object)"reading study records:");
        try {
            DicomObject next = this.dicomDir.findFirstChildRecord(patientRecord);
            while (next != null) {
                if (LEVEL_STUDY.equals(next.getString(267312))) {
                    try {
                        studyVector.add(next);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error getting Studies: " + e.getLocalizedMessage()));
                    }
                }
                next = this.dicomDir.findNextSiblingRecord(next);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Error getting Studies: " + e.getLocalizedMessage()));
        }
        return studyVector;
    }

    public Vector<StudyObject> getAllStudys() {
        String patientName = null;
        String patientID = null;
        Vector<StudyObject> studyVector = new Vector<StudyObject>();
        log.info((Object)"reading patient records:");
        try {
            DicomObject next = this.dicomDir.findFirstRootRecord();
            while (next != null) {
                if (LEVEL_PATIENT.equals(next.getString(267312))) {
                    try {
                        patientName = next.getString(0x100010);
                        patientID = next.getString(0x100020);
                        DicomObject study = this.dicomDir.findFirstChildRecord(next);
                        while (study != null) {
                            if (LEVEL_STUDY.equals(next.getString(267312))) {
                                try {
                                    studyVector.add(new StudyObject(study, patientName, patientID));
                                }
                                catch (Exception e) {
                                    log.warn((Object)("Error getting AllStudies: " + e.getLocalizedMessage()));
                                }
                            }
                            study = this.dicomDir.findNextSiblingRecord(study);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error getting AllStudies: " + e.getLocalizedMessage()));
                    }
                }
                next = this.dicomDir.findNextSiblingRecord(next);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Error getting AllStudies: " + e.getLocalizedMessage()));
        }
        Collections.sort(studyVector, new StudyComparer());
        return studyVector;
    }

    public Vector<DicomObject> getSeriesFromStudy(DicomObject studyRecord) {
        Vector<DicomObject> seriesVector = new Vector<DicomObject>();
        log.info((Object)"reading series records:");
        try {
            DicomObject next = this.dicomDir.findFirstChildRecord(studyRecord);
            while (next != null) {
                if (LEVEL_SERIES.equals(next.getString(267312))) {
                    try {
                        seriesVector.add(next);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error getting Series from Studies: " + e.getLocalizedMessage()));
                    }
                }
                next = this.dicomDir.findNextSiblingRecord(next);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Error getting Series from Studies: " + e.getLocalizedMessage()));
        }
        return seriesVector;
    }

    public Vector<DicomObject> getSeriesFromPatient(DicomObject patientRecord) {
        Vector<DicomObject> seriesVector = new Vector<DicomObject>();
        log.info((Object)"reading series records:");
        try {
            DicomObject study = this.dicomDir.findFirstChildRecord(patientRecord);
            while (study != null) {
                if (LEVEL_STUDY.equals(study.getString(267312))) {
                    try {
                        DicomObject series = this.dicomDir.findFirstChildRecord(study);
                        while (series != null) {
                            if (LEVEL_SERIES.equals(series.getString(267312))) {
                                try {
                                    seriesVector.add(series);
                                    System.out.println("found series: " + series);
                                }
                                catch (Exception e) {
                                    log.warn((Object)("Error getting Series from Patients: " + e.getLocalizedMessage()));
                                }
                            }
                            series = this.dicomDir.findNextSiblingRecord(series);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error getting Series from Patients: " + e.getLocalizedMessage()));
                    }
                }
                study = this.dicomDir.findNextSiblingRecord(study);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Error getting Series from Patients: " + e.getLocalizedMessage()));
        }
        return seriesVector;
    }

    public Vector<DicomObject> getImagesFromSeries(DicomObject seriesRecord) {
        Vector<DicomObject> imageVector = new Vector<DicomObject>();
        log.info((Object)"reading image records:");
        try {
            DicomObject next = this.dicomDir.findFirstChildRecord(seriesRecord);
            while (next != null) {
                try {
                    imageVector.add(next);
                }
                catch (Exception e) {
                    log.warn((Object)("Error getting Images from Series: " + e.getLocalizedMessage()));
                }
                next = this.dicomDir.findNextSiblingRecord(next);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Error getting Images from Series: " + e.getLocalizedMessage()));
        }
        Collections.sort(imageVector, new ImageComparer());
        return imageVector;
    }

    public File[] getImagePathsFromSeries(DicomObject seriesRecord) {
        Vector<DicomObject> imageVector = this.getImagesFromSeries(seriesRecord);
        File[] files = new File[imageVector.size()];
        int i = 0;
        for (DicomObject element : imageVector) {
            try {
                File f = this.dicomDir.toReferencedFile(element);
                files[i] = this.checkFileLowerCase(f.getAbsoluteFile());
                ++i;
            }
            catch (Exception e) {
                log.warn((Object)("Error getting Imagepaths from Series: " + e.getLocalizedMessage()));
            }
        }
        return files;
    }

    public File getImageFromSeriesUID(String seriesInstanceUID, int instanceNumber) {
        try {
            Vector<DicomObject> v = this.getImageRecordFromSeriesUID(seriesInstanceUID, instanceNumber);
            DicomObject dr = v.get(0);
            return this.getImagePathFromImage(dr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getImageFromSOPInstanceUID(String SOPInstanceUID) {
        try {
            DicomObject dr = this.getImageRecordFromSOPInstanceUID(SOPInstanceUID);
            return this.getImagePathFromImage(dr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File[] getSeriesFromSeriesUID(String seriesInstanceUID) {
        ArrayList<File> al = new ArrayList<File>();
        try {
            Vector<DicomObject> v = this.getImageRecordFromSeriesUID(seriesInstanceUID, -1);
            for (DicomObject dr : v) {
                al.add(this.getImagePathFromImage(dr));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return al.toArray(new File[0]);
    }

    public DicomObject getRecordFromSeriesUID(String seriesInstanceUID) {
        Vector v = new Vector();
        BasicDicomObject seriesKeys = new BasicDicomObject();
        seriesKeys.putString(0x20000E, VR.UI, seriesInstanceUID);
        try {
            Vector<DicomObject> results = this.query(LEVEL_SERIES, (DicomObject)seriesKeys);
            if (results.size() > 1) {
                System.out.println("SeriesInstanceUID not unique");
            }
            DicomObject seriesRecord = results.get(0);
            return seriesRecord;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Vector<DicomObject> getImageRecordFromSeriesUID(String seriesInstanceUID, int instanceNumber) {
        Vector<DicomObject> v = new Vector<DicomObject>();
        BasicDicomObject seriesKeys = new BasicDicomObject();
        seriesKeys.putString(0x20000E, VR.UI, seriesInstanceUID);
        try {
            Vector<DicomObject> results = this.query(LEVEL_SERIES, (DicomObject)seriesKeys);
            if (results.size() > 1) {
                System.out.println("SeriesInstanceUID not unique");
            }
            DicomObject seriesRecord = results.get(0);
            DicomObject next = this.dicomDir.findFirstChildRecord(seriesRecord);
            while (next != null) {
                if (LEVEL_IMAGE.equals(next.getString(267312))) {
                    if (instanceNumber == -1) {
                        v.add(next);
                    } else if (next.getInt(2097171) == instanceNumber) {
                        v.add(next);
                        return v;
                    }
                }
                next = this.dicomDir.findNextSiblingRecord(next);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public DicomObject getImageRecordFromSOPInstanceUID(String SOPInstanceUID) {
        BasicDicomObject imageKeys = new BasicDicomObject();
        imageKeys.putString(267537, VR.UI, SOPInstanceUID);
        try {
            Vector<DicomObject> results = this.query(LEVEL_IMAGE, (DicomObject)imageKeys);
            for (DicomObject element : results) {
                if (element.getString(267537) == null || !element.getString(267537).trim().equals(SOPInstanceUID.trim())) continue;
                return element;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public File[] getNextImage(boolean series) {
        BasicDicomObject seriesKeys = new BasicDicomObject();
        ArrayList<File> al = new ArrayList<File>();
        try {
            Vector<DicomObject> results = this.query(LEVEL_SERIES, (DicomObject)seriesKeys);
            DicomObject seriesRecord = results.get(0);
            DicomObject next = this.dicomDir.findFirstChildRecord(seriesRecord);
            while (next != null) {
                if (LEVEL_IMAGE.equals(next.getString(267312))) {
                    if (series) {
                        al.add(this.getImagePathFromImage(next));
                    } else {
                        File[] files = new File[]{this.getImagePathFromImage(next)};
                        return files;
                    }
                }
                next = this.dicomDir.findNextSiblingRecord(next);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return al.toArray(new File[1]);
    }

    public File getImagePathFromImage(DicomObject imageRecord) throws Exception {
        return this.checkFileLowerCase(this.dicomDir.toReferencedFile(imageRecord));
    }

    public void deleteRecord(DicomObject dr) {
        if (!(this.dicomDir instanceof DicomDirWriter)) {
            log.info((Object)"unable to delete Record, DICOMDIR is READ-ONLY");
            return;
        }
        if (LEVEL_PATIENT.equals(dr.getString(267312))) {
            try {
                log.info((Object)("deleting PATIENT: " + dr.getItemOffset()));
                DicomObject studies = this.dicomDir.findFirstChildRecord(dr);
                while (studies != null) {
                    this.deleteRecord(studies);
                    studies = this.dicomDir.findNextSiblingRecord(studies);
                }
                ((DicomDirWriter)this.dicomDir).deleteRecord(dr);
                log.info((Object)"deleted PATIENT");
            }
            catch (Exception e) {
                log.warn((Object)("error deleting PATIENT from DICOMDIR: \"" + this.STORE_DIR + "\""));
            }
        } else if (LEVEL_STUDY.equals(dr.getString(267312))) {
            try {
                log.info((Object)("deleting STUDY: " + dr.getItemOffset()));
                DicomObject series = this.dicomDir.findFirstChildRecord(dr);
                while (series != null) {
                    this.deleteRecord(series);
                    series = this.dicomDir.findNextSiblingRecord(series);
                }
                ((DicomDirWriter)this.dicomDir).deleteRecord(dr);
                log.info((Object)"deleted STUDY");
            }
            catch (Exception e) {
                log.warn((Object)("error deleting STUDY from DICOMDIR: \"" + this.STORE_DIR + "\""));
            }
        } else if (LEVEL_SERIES.equals(dr.getString(267312))) {
            try {
                log.info((Object)("deleting SERIES: " + dr.getItemOffset()));
                DicomObject pictures = this.dicomDir.findFirstChildRecord(dr);
                while (pictures != null) {
                    this.deleteRecord(pictures);
                    pictures = this.dicomDir.findNextSiblingRecord(pictures);
                }
                ((DicomDirWriter)this.dicomDir).deleteRecord(dr);
                log.info((Object)"deleted SERIES");
            }
            catch (Exception e) {
                log.warn((Object)("error deleting SERIES from DICOMDIR: \"" + this.STORE_DIR + "\""));
            }
        } else if (LEVEL_IMAGE.equals(dr.getString(267312))) {
            try {
                log.info((Object)("deleting IMAGE: " + dr.getItemOffset()));
                ((DicomDirWriter)this.dicomDir).deleteRecord(dr);
                log.info((Object)"deleted IMAGE");
                File img = this.getImagePathFromImage(dr);
                img.delete();
            }
            catch (Exception e) {
                log.warn((Object)("error deleting IMAGE from DICOMDIR: \"" + this.STORE_DIR + "\""));
            }
        }
        try {
            ((DicomDirWriter)this.dicomDir).commit();
        }
        catch (IOException e) {
            log.warn((Object)e.getLocalizedMessage());
        }
    }

    public static void deleteEmptyDirs(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            dir = dir.getParentFile();
        }
        if (dir.listFiles() == null || dir.listFiles().length == 0) {
            dir.delete();
            log.info((Object)("deleted dir: \"" + dir.getAbsolutePath() + "\""));
            DicomDirReader.deleteEmptyDirs(dir.getParentFile());
        } else {
            log.info((Object)("not deleting dir: \"" + dir.getAbsolutePath() + "\"" + " (not empty)"));
        }
    }

    public static void main(String[] args) throws Exception {
        DicomDirReader ddr = new DicomDirReader();
        ddr.loadDicomDirFile(new File(new String("DICOMSTORE/DICOMDIR")), false, false);
        System.out.println(ddr.getPatients());
        System.out.println("fertig");
    }

    public String append(File f) throws IOException {
        String iuid;
        if (f.getName().toUpperCase().endsWith("DICOMDIR")) {
            return "";
        }
        int n = 0;
        if (f.isDirectory()) {
            StringBuffer sb = new StringBuffer();
            File[] files = f.listFiles();
            int i = 0;
            while (i < files.length) {
                sb.append(this.append(files[i]));
                ++i;
            }
            return sb.toString();
        }
        DicomInputStream in = new DicomInputStream(f);
        in.setHandler((DicomInputHandler)new StopTagInputHandler(2145386512));
        DicomObject dcmobj = in.readDicomObject();
        in.close();
        String fileName = DicomDirReader.createFileName(dcmobj);
        File outFile = new File(this.STORE_DIR.getParentFile(), fileName);
        outFile.getParentFile().mkdirs();
        if (!f.getAbsolutePath().equals(outFile.getAbsolutePath())) {
            log.info((Object)("moving " + f.getAbsolutePath() + " to " + outFile.getAbsolutePath()));
            f.renameTo(outFile);
        }
        in = new DicomInputStream(outFile);
        in.setHandler((DicomInputHandler)new StopTagInputHandler(2145386512));
        dcmobj = in.readDicomObject();
        DicomObject patrec = this.ap.makePatientDirectoryRecord(dcmobj);
        DicomObject styrec = this.ap.makeStudyDirectoryRecord(dcmobj);
        DicomObject serrec = this.ap.makeSeriesDirectoryRecord(dcmobj);
        DicomObject instrec = this.ap.makeInstanceDirectoryRecord(dcmobj, this.dicomDir.toFileID(outFile));
        DicomObject rec = ((DicomDirWriter)this.dicomDir).addPatientRecord(patrec);
        if (rec == patrec) {
            ++n;
        }
        if ((rec = ((DicomDirWriter)this.dicomDir).addStudyRecord(rec, styrec)) == styrec) {
            ++n;
        }
        if ((rec = ((DicomDirWriter)this.dicomDir).addSeriesRecord(rec, serrec)) == serrec) {
            ++n;
        }
        if (n == 0 && this.checkDuplicate && this.dicomDir.findInstanceRecord(rec, iuid = dcmobj.getString(131075)) != null) {
            System.out.print('D');
            ((DicomDirWriter)this.dicomDir).commit();
            this.dicomDir.clearCache();
            return outFile.getAbsolutePath();
        }
        ((DicomDirWriter)this.dicomDir).addChildRecord(rec, instrec);
        System.out.print('.');
        ((DicomDirWriter)this.dicomDir).commit();
        this.dicomDir.clearCache();
        in.close();
        return outFile.getAbsolutePath();
    }

    public static String createFileName(DicomObject dcmobj) {
        return DicomDirReader.createFileName(dcmobj, File.separator);
    }

    public static String createFileName(DicomObject dcmobj, String separator) {
        StringBuffer fileName = new StringBuffer();
        String field = String.valueOf(dcmobj.getString(DICOM_DIR_NAMING[0])).replaceAll("\\W", "_");
        fileName.append(field);
        int i = 1;
        while (i < DICOM_DIR_NAMING.length) {
            fileName.append(separator);
            fileName.append(String.valueOf(dcmobj.getString(DICOM_DIR_NAMING[i])).replaceAll("\\W", "_"));
            ++i;
        }
        String filePath = fileName.toString().replaceAll("\\00", "");
        return filePath;
    }

    public Vector<DicomObject> query(String queryLevel, DicomObject queryKeys) throws IOException, TransformerConfigurationException {
        this.qrLevel = Arrays.asList(QRLEVEL).indexOf(queryLevel);
        this.foundRecords.removeAllElements();
        this.query("", 1, 0, this.dicomDir.findFirstRootRecord(), queryKeys);
        return this.foundRecords;
    }

    private int query(String prefix, int no, int level, DicomObject dr, DicomObject queryKeys) throws IOException, TransformerConfigurationException {
        int count = 1;
        while (dr != null) {
            if (level >= this.qrLevel) {
                System.out.println("found " + dr);
                this.foundRecords.add(dr);
                ++no;
            } else {
                no = this.query(String.valueOf(prefix) + count + '.', no, level + 1, this.dicomDir.findFirstChildRecord(dr), queryKeys);
            }
            ++count;
            dr = this.dicomDir.findNextMatchingSiblingRecord(dr, queryKeys, true);
        }
        return no;
    }

    public void deleteImageFromSeriesUID(String seriesInstanceUID, int instanceNumber) {
        if (instanceNumber == -1) {
            BasicDicomObject seriesKeys = new BasicDicomObject();
            seriesKeys.putString(0x20000E, VR.UI, seriesInstanceUID);
            try {
                Vector<DicomObject> results = this.query(LEVEL_SERIES, (DicomObject)seriesKeys);
                if (results.size() > 1) {
                    System.out.println("SeriesInstanceUID not unique");
                }
                DicomObject seriesRecord = results.get(0);
                this.deleteRecord(seriesRecord);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Vector<DicomObject> v = this.getImageRecordFromSeriesUID(seriesInstanceUID, instanceNumber);
            for (DicomObject dr : v) {
                this.deleteRecord(dr);
            }
        }
    }

    public void deleteRecord(String level, DicomHeader dh) {
        DicomObject patRec;
        DicomObject studRec;
        int ref;
        DicomObject rec = this.getRecord(level, dh);
        this.deleteRecord(rec);
        if (LEVEL_SERIES.equals(level) && (ref = (studRec = this.getRecord(LEVEL_STUDY, dh)).getInt(267296)) == 0) {
            this.deleteRecord(studRec);
            level = LEVEL_STUDY;
        }
        if (LEVEL_STUDY.equals(level) && (ref = (patRec = this.getRecord(LEVEL_PATIENT, dh)).getInt(267296)) == 0) {
            this.deleteRecord(patRec);
        }
    }

    public DicomObject getRecord(String level, DicomHeader dh) {
        Vector<DicomObject> results;
        block11: {
            Vector v = new Vector();
            BasicDicomObject keys = new BasicDicomObject();
            if (LEVEL_PATIENT.equals(level)) {
                keys.putString(0x100020, VR.UI, dh.getHeaderStringValue(0x100020));
            } else if (LEVEL_STUDY.equals(level)) {
                keys.putString(0x20000D, VR.UI, dh.getHeaderStringValue(0x20000D));
            } else if (LEVEL_SERIES.equals(level)) {
                keys.putString(0x20000E, VR.UI, dh.getHeaderStringValue(0x20000E));
            } else if (LEVEL_IMAGE.equals(level)) {
                keys.putString(524312, VR.UI, dh.getHeaderStringValue(524312));
            }
            try {
                results = this.query(level, (DicomObject)keys);
                if (results.size() > 1) {
                    System.out.println("UID not unique");
                }
                if (results.size() != 0) break block11;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        DicomObject rec = results.get(0);
        return rec;
    }

    public void deleteImage(String sopInstanceUID) throws Exception {
        DicomObject rec = this.getImageRecordFromSOPInstanceUID(sopInstanceUID);
        this.deleteRecord(rec);
    }

    public FileSetInformation fsinfo() {
        if (this.fsinfo == null) {
            this.fsinfo = new FileSetInformation();
            this.fsinfo.init();
        }
        return this.fsinfo;
    }

    private File checkFileLowerCase(File f) {
        File newFile;
        if (IS_WINDOWS) {
            return f;
        }
        if (!f.exists() && (newFile = new File(f.getAbsolutePath().toLowerCase())).exists()) {
            return newFile;
        }
        return f;
    }

    public void close() {
        if (this.dicomDir != null) {
            try {
                this.dicomDir.clearCache();
                this.dicomDir.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void clearCache() {
        this.dicomDir.clearCache();
    }

    public boolean isWriteable() {
        return this.dicomDir instanceof DicomDirWriter;
    }

    class ImageComparer
    implements Comparator<DicomObject> {
        ImageComparer() {
        }

        @Override
        public int compare(DicomObject obj1, DicomObject obj2) {
            int nr1 = Integer.parseInt(obj1.getString(2097171));
            int nr2 = Integer.parseInt(obj2.getString(2097171));
            return nr1 - nr2;
        }
    }

    class StudyComparer
    implements Comparator<StudyObject> {
        StudyComparer() {
        }

        @Override
        public int compare(StudyObject obj1, StudyObject obj2) {
            String str1 = obj1.getDirRecord().getString(524320);
            String str2 = obj2.getDirRecord().getString(524320);
            int dateCompare = str2.compareTo(str1);
            if (dateCompare != 0) {
                return dateCompare;
            }
            String str1b = obj1.getDirRecord().getString(524336);
            String str2b = obj2.getDirRecord().getString(524336);
            return str2b.compareTo(str1b);
        }
    }
}

