/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.receiver;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Vector;
import java.util.concurrent.Executor;
import lu.tudor.santec.dicom.receiver.DICOMListener;
import lu.tudor.santec.dicom.receiver.DicomDirReader;
import lu.tudor.santec.dicom.receiver.DicomEvent;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.io.StopTagInputHandler;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.DicomServiceException;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.PDVInputStream;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.service.DicomService;
import org.dcm4che2.net.service.StorageService;
import org.dcm4che2.net.service.VerificationService;
import org.dcm4che2.tool.dcmrcv.DcmRcv;

public class DicomStorageServer
extends StorageService {
    private static Logger log = Logger.getLogger((String)DicomStorageServer.class.getName());
    private static char[] SECRET = new char[]{'s', 'e', 'c', 'r', 'e', 't'};
    private static final String[] ONLY_DEF_TS = new String[]{"1.2.840.10008.1.2"};
    private static final String[] NATIVE_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.2.840.10008.1.2"};
    private static final String[] NATIVE_LE_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    private static final String[] NON_RETIRED_TS = new String[]{"1.2.840.10008.1.2.4.80", "1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.57", "1.2.840.10008.1.2.4.90", "1.2.840.10008.1.2.1.99", "1.2.840.10008.1.2.5", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.2.840.10008.1.2", "1.2.840.10008.1.2.4.50", "1.2.840.10008.1.2.4.51", "1.2.840.10008.1.2.4.81", "1.2.840.10008.1.2.4.91", "1.2.840.10008.1.2.4.100"};
    private static final String[] NON_RETIRED_LE_TS = new String[]{"1.2.840.10008.1.2.4.80", "1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.57", "1.2.840.10008.1.2.4.90", "1.2.840.10008.1.2.1.99", "1.2.840.10008.1.2.5", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2", "1.2.840.10008.1.2.4.50", "1.2.840.10008.1.2.4.51", "1.2.840.10008.1.2.4.81", "1.2.840.10008.1.2.4.91", "1.2.840.10008.1.2.4.100"};
    private static final String[] CUIDS = new String[]{"1.2.840.10008.1.9", "1.2.840.10008.5.1.1.27", "1.2.840.10008.5.1.1.29", "1.2.840.10008.5.1.1.30", "1.2.840.10008.5.1.4.1.1.1", "1.2.840.10008.5.1.4.1.1.1.1", "1.2.840.10008.5.1.4.1.1.1.1.1", "1.2.840.10008.5.1.4.1.1.1.2", "1.2.840.10008.5.1.4.1.1.1.2.1", "1.2.840.10008.5.1.4.1.1.1.3", "1.2.840.10008.5.1.4.1.1.1.3.1", "1.2.840.10008.5.1.4.1.1.10", "1.2.840.10008.5.1.4.1.1.104.1", "1.2.840.10008.5.1.4.1.1.11", "1.2.840.10008.5.1.4.1.1.11.1", "1.2.840.10008.5.1.4.1.1.11.2", "1.2.840.10008.5.1.4.1.1.11.3", "1.2.840.10008.5.1.4.1.1.11.4", "1.2.840.10008.5.1.4.1.1.12.1", "1.2.840.10008.5.1.4.1.1.12.1.1", "1.2.840.10008.5.1.4.1.1.12.2", "1.2.840.10008.5.1.4.1.1.12.2.1", "1.2.840.10008.5.1.4.1.1.12.3", "1.2.840.10008.5.1.4.1.1.128", "1.2.840.10008.5.1.4.1.1.129", "1.2.840.10008.5.1.4.1.1.2", "1.2.840.10008.5.1.4.1.1.2.1", "1.2.840.10008.5.1.4.1.1.20", "1.2.840.10008.5.1.4.1.1.3", "1.2.840.10008.5.1.4.1.1.3.1", "1.2.840.10008.5.1.4.1.1.4", "1.2.840.10008.5.1.4.1.1.4.1", "1.2.840.10008.5.1.4.1.1.4.2", "1.2.840.10008.5.1.4.1.1.481.1", "1.2.840.10008.5.1.4.1.1.481.2", "1.2.840.10008.5.1.4.1.1.481.3", "1.2.840.10008.5.1.4.1.1.481.4", "1.2.840.10008.5.1.4.1.1.481.5", "1.2.840.10008.5.1.4.1.1.481.6", "1.2.840.10008.5.1.4.1.1.481.7", "1.2.840.10008.5.1.4.1.1.5", "1.2.840.10008.5.1.4.1.1.6", "1.2.840.10008.5.1.4.1.1.6.1", "1.2.840.10008.5.1.4.1.1.66", "1.2.840.10008.5.1.4.1.1.66.1", "1.2.840.10008.5.1.4.1.1.66.2", "1.2.840.10008.5.1.4.1.1.67", "1.2.840.10008.5.1.4.1.1.7", "1.2.840.10008.5.1.4.1.1.7.1", "1.2.840.10008.5.1.4.1.1.7.2", "1.2.840.10008.5.1.4.1.1.7.3", "1.2.840.10008.5.1.4.1.1.7.4", "1.2.840.10008.5.1.4.1.1.77.1", "1.2.840.10008.5.1.4.1.1.77.1.1", "1.2.840.10008.5.1.4.1.1.77.1.1.1", "1.2.840.10008.5.1.4.1.1.77.1.2", "1.2.840.10008.5.1.4.1.1.77.1.2.1", "1.2.840.10008.5.1.4.1.1.77.1.3", "1.2.840.10008.5.1.4.1.1.77.1.4", "1.2.840.10008.5.1.4.1.1.77.1.4.1", "1.2.840.10008.5.1.4.1.1.77.1.5.1", "1.2.840.10008.5.1.4.1.1.77.1.5.2", "1.2.840.10008.5.1.4.1.1.77.1.5.3", "1.2.840.10008.5.1.4.1.1.77.2", "1.2.840.10008.5.1.4.1.1.8", "1.2.840.10008.5.1.4.1.1.88.11", "1.2.840.10008.5.1.4.1.1.88.22", "1.2.840.10008.5.1.4.1.1.88.33", "1.2.840.10008.5.1.4.1.1.88.40", "1.2.840.10008.5.1.4.1.1.88.50", "1.2.840.10008.5.1.4.1.1.88.59", "1.2.840.10008.5.1.4.1.1.88.65", "1.2.840.10008.5.1.4.1.1.88.67", "1.2.840.10008.5.1.4.1.1.104.1", "1.2.840.10008.5.1.4.1.1.104.2", "1.2.840.10008.5.1.4.1.1.9", "1.2.840.10008.5.1.4.1.1.9.1.1", "1.2.840.10008.5.1.4.1.1.9.1.2", "1.2.840.10008.5.1.4.1.1.9.1.3", "1.2.840.10008.5.1.4.1.1.9.2.1", "1.2.840.10008.5.1.4.1.1.9.3.1", "1.2.840.10008.5.1.4.1.1.9.4.1", "1.2.840.10008.5.1.4.38.1", "1.3.12.2.1107.5.9.1", "1.2.40.0.13.1.3.1.2.3.1.1"};
    private Executor executor = new NewThreadExecutor("DCMRCV");
    private Device device = new Device("DCMRCV");
    private NetworkApplicationEntity ae = new NetworkApplicationEntity();
    private NetworkConnection nc = new NetworkConnection();
    private String[] tsuids = NON_RETIRED_LE_TS;
    private File destination;
    private boolean devnull;
    private int fileBufferSize = 256;
    private int rspdelay = 0;
    private String keyStoreURL = "resource:tls/test_sys_2.p12";
    private char[] keyStorePassword = SECRET;
    private char[] keyPassword;
    private String trustStoreURL = "resource:tls/mesa_certs.jks";
    private char[] trustStorePassword = SECRET;
    private boolean allowDoubles;
    private Integer port;
    private String password;
    private Vector<DICOMListener> dicomListeners = new Vector();
    private String AETName;
    private String storeDir;
    private boolean isRunning;
    private boolean useDICOMDIR;
    private DicomDirReader dicomDirWriter;
    private boolean stripImagesToHeaders = false;

    public DicomStorageServer(String AETName, Integer port, String storeDir, boolean allowDoubles, String managePassword, boolean startup) throws IOException {
        this(AETName, port, storeDir, allowDoubles, managePassword, startup, false, null);
    }

    public DicomStorageServer(String AETName, Integer port, String storeDir, boolean allowDoubles, String managePassword, boolean startup, DicomDirReader dicomDirWriter) throws IOException {
        this(AETName, port, storeDir, allowDoubles, managePassword, startup, false, dicomDirWriter);
    }

    public DicomStorageServer(String AETName, Integer port, String storeDir, boolean allowDoubles, String managePassword, boolean startup, boolean stripImagesToHeaders, DicomDirReader dicomDirWriter) throws IOException {
        super(CUIDS);
        this.stripImagesToHeaders = stripImagesToHeaders;
        this.allowDoubles = allowDoubles;
        this.port = port;
        this.password = managePassword;
        this.AETName = AETName;
        this.storeDir = storeDir;
        this.dicomDirWriter = dicomDirWriter;
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.nc);
        this.ae.setNetworkConnection(this.nc);
        this.ae.setAssociationAcceptor(true);
        this.ae.register((DicomService)new VerificationService());
        this.ae.register((DicomService)this);
        this.ae.setAETitle(AETName);
        this.nc.setPort(port.intValue());
        this.initTransferCapability();
        if (storeDir.toUpperCase().endsWith("DICOMDIR")) {
            this.useDICOMDIR = true;
            File store = new File(storeDir);
            store.getParentFile().mkdirs();
            if (this.dicomDirWriter == null) {
                this.dicomDirWriter = new DicomDirReader();
                this.dicomDirWriter.loadDicomDirFile(store, true, true);
            }
            this.setDestination(new File(storeDir).getParent());
        } else {
            this.setDestination(storeDir);
        }
        if (startup) {
            this.start();
        }
    }

    public final void setHostname(String hostname) {
        this.nc.setHostname(hostname);
    }

    public final void setTlsWithoutEncyrption() {
        this.nc.setTlsWithoutEncyrption();
    }

    public final void setTls3DES_EDE_CBC() {
        this.nc.setTls3DES_EDE_CBC();
    }

    public final void setTlsAES_128_CBC() {
        this.nc.setTlsAES_128_CBC();
    }

    public final void disableSSLv2Hello() {
        this.nc.disableSSLv2Hello();
    }

    public final void setTlsNeedClientAuth(boolean needClientAuth) {
        this.nc.setTlsNeedClientAuth(needClientAuth);
    }

    public final void setKeyStoreURL(String url) {
        this.keyStoreURL = url;
    }

    public final void setKeyStorePassword(String pw) {
        this.keyStorePassword = pw.toCharArray();
    }

    public final void setKeyPassword(String pw) {
        this.keyPassword = pw.toCharArray();
    }

    public final void setTrustStorePassword(String pw) {
        this.trustStorePassword = pw.toCharArray();
    }

    public final void setTrustStoreURL(String url) {
        this.trustStoreURL = url;
    }

    public final void setPackPDV(boolean packPDV) {
        this.ae.setPackPDV(packPDV);
    }

    public final void setAssociationReaperPeriod(int period) {
        this.device.setAssociationReaperPeriod(period);
    }

    public final void setTcpNoDelay(boolean tcpNoDelay) {
        this.nc.setTcpNoDelay(tcpNoDelay);
    }

    public final void setRequestTimeout(int timeout) {
        this.nc.setRequestTimeout(timeout);
    }

    public final void setReleaseTimeout(int timeout) {
        this.nc.setReleaseTimeout(timeout);
    }

    public final void setSocketCloseDelay(int delay) {
        this.nc.setSocketCloseDelay(delay);
    }

    public final void setIdleTimeout(int timeout) {
        this.ae.setIdleTimeout(timeout);
    }

    public final void setDimseRspTimeout(int timeout) {
        this.ae.setDimseRspTimeout(timeout);
    }

    public final void setMaxPDULengthSend(int maxLength) {
        this.ae.setMaxPDULengthSend(maxLength);
    }

    public void setMaxPDULengthReceive(int maxLength) {
        this.ae.setMaxPDULengthReceive(maxLength);
    }

    public final void setReceiveBufferSize(int bufferSize) {
        this.nc.setReceiveBufferSize(bufferSize);
    }

    public final void setSendBufferSize(int bufferSize) {
        this.nc.setSendBufferSize(bufferSize);
    }

    private void setDimseRspDelay(int delay) {
        this.rspdelay = delay;
    }

    private void setTransferSyntax(String[] tsuids) {
        this.tsuids = tsuids;
    }

    private void initTransferCapability() {
        TransferCapability[] tc = new TransferCapability[CUIDS.length + 1];
        tc[0] = new TransferCapability("1.2.840.10008.1.1", ONLY_DEF_TS, "SCP");
        int i = 0;
        while (i < CUIDS.length) {
            tc[i + 1] = new TransferCapability(CUIDS[i], this.tsuids, "SCP");
            ++i;
        }
        this.ae.setTransferCapability(tc);
    }

    private void setFileBufferSize(int size) {
        this.fileBufferSize = size;
    }

    private void setMaxOpsPerformed(int maxOps) {
        this.ae.setMaxOpsPerformed(maxOps);
    }

    private void setDestination(String filePath) {
        this.destination = new File(filePath);
        this.devnull = "/dev/null".equals(filePath);
        if (!this.devnull) {
            this.destination.mkdir();
        }
    }

    public void initTLS() throws GeneralSecurityException, IOException {
        KeyStore keyStore = DicomStorageServer.loadKeyStore(this.keyStoreURL, this.keyStorePassword);
        KeyStore trustStore = DicomStorageServer.loadKeyStore(this.trustStoreURL, this.trustStorePassword);
        this.device.initTLS(keyStore, this.keyPassword != null ? this.keyPassword : this.keyStorePassword, trustStore);
    }

    private static KeyStore loadKeyStore(String url, char[] password) throws GeneralSecurityException, IOException {
        KeyStore key = KeyStore.getInstance(DicomStorageServer.toKeyStoreType(url));
        InputStream in = DicomStorageServer.openFileOrURL(url);
        try {
            key.load(in, password);
        }
        finally {
            in.close();
        }
        return key;
    }

    private static InputStream openFileOrURL(String url) throws IOException {
        if (url.startsWith("resource:")) {
            return DcmRcv.class.getClassLoader().getResourceAsStream(url.substring(9));
        }
        try {
            return new URL(url).openStream();
        }
        catch (MalformedURLException e) {
            return new FileInputStream(url);
        }
    }

    private static String toKeyStoreType(String fname) {
        return fname.endsWith(".p12") || fname.endsWith(".P12") ? "PKCS12" : "JKS";
    }

    public void start() throws IOException {
        this.device.startListening(this.executor);
        System.out.println("Start Server listening on port " + this.nc.getPort());
        this.openManagePort();
        this.isRunning = true;
    }

    public void stop() throws IOException {
        this.device.stopListening();
        System.out.println("Stopped Server listening on port " + this.nc.getPort());
        this.nc.unbind();
        this.isRunning = false;
    }

    private static String[] split(String s, char delim, int defPos) {
        String[] s2 = new String[2];
        s2[defPos] = s;
        int pos = s.indexOf(delim);
        if (pos != -1) {
            s2[0] = s.substring(0, pos);
            s2[1] = s.substring(pos + 1);
        }
        return s2;
    }

    private static void exit(String msg) {
        System.err.println(msg);
        System.err.println("Try 'dcmrcv -h' for more information.");
        System.exit(1);
    }

    private static int parseInt(String s, String errPrompt, int min, int max) {
        try {
            int i = Integer.parseInt(s);
            if (i >= min && i <= max) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        DicomStorageServer.exit(errPrompt);
        throw new RuntimeException();
    }

    public void cstore(final Association as, final int pcid, DicomObject rq, PDVInputStream dataStream, String tsuid) throws DicomServiceException, IOException {
        final DicomObject rsp = CommandUtils.mkRSP((DicomObject)rq, (int)0);
        this.onCStoreRQ(as, pcid, rq, dataStream, tsuid, rsp);
        if (this.rspdelay > 0) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(DicomStorageServer.this.rspdelay);
                        as.writeDimseRSP(pcid, rsp);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            as.writeDimseRSP(pcid, rsp);
        }
        this.onCStoreRSP(as, pcid, rq, dataStream, tsuid, rsp);
    }

    protected void onCStoreRQ(Association as, int pcid, DicomObject rq, PDVInputStream dataStream, String tsuid, DicomObject rsp) throws IOException, DicomServiceException {
        String seriesUID = rq.getString(0x20000E);
        if (this.destination == null) {
            super.onCStoreRQ(as, pcid, rq, dataStream, tsuid, rsp);
            this.fireDicomEvent(new DicomEvent(this.destination));
        } else {
            try {
                String cuid = rq.getString(2);
                String iuid = rq.getString(4096);
                BasicDicomObject fmi = new BasicDicomObject();
                fmi.initFileMetaInformation(cuid, iuid, tsuid);
                if (this.destination.isFile()) {
                    this.destination = this.destination.getParentFile();
                } else if (!this.destination.exists()) {
                    this.destination.mkdirs();
                }
                File file = this.devnull ? this.destination : new File(this.destination, iuid);
                FileOutputStream fos = new FileOutputStream(file);
                BufferedOutputStream bos = new BufferedOutputStream(fos, this.fileBufferSize);
                DicomOutputStream dos = new DicomOutputStream((OutputStream)bos);
                dos.writeFileMetaInformation((DicomObject)fmi);
                dataStream.copyTo((OutputStream)dos);
                dos.close();
                if (this.stripImagesToHeaders) {
                    try {
                        DicomInputStream in = new DicomInputStream(file);
                        in.setHandler((DicomInputHandler)new StopTagInputHandler(2145386512));
                        DicomObject dcmobj = in.readDicomObject();
                        in.close();
                        file.delete();
                        FileOutputStream fos2 = new FileOutputStream(file);
                        BufferedOutputStream bos2 = new BufferedOutputStream(fos2);
                        DicomOutputStream dos2 = new DicomOutputStream((OutputStream)bos2);
                        dos2.writeDicomFile(dcmobj);
                        dos2.close();
                    }
                    catch (Exception e) {
                        log.log((Priority)Level.WARN, (Object)("error stripping file :" + file.getAbsolutePath()));
                    }
                }
                if (this.useDICOMDIR) {
                    File newfile = new File(this.dicomDirWriter.append(file));
                    if (file.exists() && !file.getAbsolutePath().equals(newfile.getAbsolutePath())) {
                        file.delete();
                    }
                    this.fireDicomEvent(new DicomEvent(this.destination, newfile, "ADD"));
                } else {
                    this.fireDicomEvent(new DicomEvent(this.destination, file, "ADD"));
                }
            }
            catch (IOException e) {
                throw new DicomServiceException(rq, 272, e.getMessage());
            }
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void openManagePort() {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ServerSocket s = new ServerSocket(DicomStorageServer.this.port + 1);
                    log.info((Object)("openend new DicomServerManageConnection at: " + s.getLocalPort()));
                    while (true) {
                        Socket incoming = s.accept();
                        this.handleSocket(incoming);
                        incoming.close();
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }

            public void handleSocket(Socket incoming) {
                try {
                    incoming.setSoTimeout(20000);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(incoming.getInputStream()));
                    OutputStreamWriter writer = new OutputStreamWriter(incoming.getOutputStream());
                    log.info((Object)("openend new DicomServerManageConnection at: " + incoming.getPort()));
                    String compName = "unKnown";
                    String compAddress = "127.0.0.1";
                    try {
                        compName = InetAddress.getLocalHost().getHostName();
                        compAddress = InetAddress.getAllByName(compName)[0].toString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!incoming.getInetAddress().toString().equals(incoming.getLocalAddress().toString())) {
                        writer.write("DicomStorageServer@" + compAddress + ": only local connections allowed" + "\n");
                        writer.flush();
                        return;
                    }
                    writer.write("Welcome to DicomStorageServer@" + compAddress + " [enter 'password:help' for more info]" + "\n");
                    writer.flush();
                    while (true) {
                        String s = reader.readLine();
                        String pass = s.split(":")[0];
                        String cmd = s.split(":")[1];
                        log.info((Object)("recieved |xxx:" + cmd + "| on " + incoming.getLocalAddress() + " from " + incoming.getInetAddress()));
                        if (!pass.equals(DicomStorageServer.this.password)) {
                            writer.write("wrong password\n");
                            writer.flush();
                        }
                        if (cmd.toLowerCase().equals("exit")) {
                            try {
                                writer.write("Server exiting\n");
                                writer.flush();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            DicomStorageServer.this.stop();
                            log.info((Object)"Dicom Server exiting......");
                            System.exit(0);
                            continue;
                        }
                        if (cmd.toLowerCase().equals("info")) {
                            writer.write("DicomStorageServer with AET '" + DicomStorageServer.this.AETName + "' on DICOMDIR: '" + DicomStorageServer.this.storeDir + "'\n");
                            writer.flush();
                            continue;
                        }
                        if (!cmd.toLowerCase().equals("help")) continue;
                        writer.write("password:info will show a small Server Info.\n");
                        writer.write("password:exit will exit the Server.\n");
                        writer.flush();
                    }
                }
                catch (SocketTimeoutException e) {
                    log.info((Object)"DicomStorageServer closing manage connection (SocketTimeOut)");
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    log.info((Object)"DicomStorageServer closing manage connection (wrong command send)");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    public void fireDicomEvent(DicomEvent event) {
        for (DICOMListener listener : this.dicomListeners) {
            listener.fireDicomEvent(event);
        }
    }

    public void addDICOMListener(DICOMListener dl) {
        this.dicomListeners.add(dl);
    }

    public void removeDICOMListener(DICOMListener dl) {
        this.dicomListeners.remove(dl);
    }

    public boolean getStripImagesToHeaders() {
        return this.stripImagesToHeaders;
    }

    public void setStripImagesToHeaders(boolean stripImagesToHeaders) {
        this.stripImagesToHeaders = stripImagesToHeaders;
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("Please start with parameters AETitle PORT STOREAGEDIR STRIPTOHEADERS(true/false)");
            System.out.println("e.g. lu.tudor.santec.dicom.receiver.DicomStorageServer TUDOR 5104 DICOMSTORE/DICOMDIR false");
            System.out.println("Exiting....");
            System.exit(-1);
        }
        try {
            DicomStorageServer dss = new DicomStorageServer(args[0], Integer.parseInt(args[1]), args[2], true, "password", true, Boolean.parseBoolean(args[3]), null);
            dss.addDICOMListener(new DICOMListener(){

                @Override
                public void fireDicomEvent(DicomEvent event) {
                    System.out.println("event: " + event);
                }
            });
            System.out.println("DICOM STORE started....press CTRL-C to stop.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDicomDirReader(DicomDirReader dicomDirWriter) {
        this.dicomDirWriter = dicomDirWriter;
    }
}

