/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import org.apache.poi.util.HexDumpTudor;

public class DICOMHexDump {
    private static final DecimalFormat format = new DecimalFormat("00000000");

    public static String[] dump2HEX(File f, long byteAnz, int linebreak) {
        String[] retVal = new String[3];
        StringBuffer sbLines = new StringBuffer();
        StringBuffer sbHex = new StringBuffer();
        StringBuffer sbText = new StringBuffer();
        try {
            FileInputStream fr = new FileInputStream(f);
            byte[] bytes = new byte[linebreak];
            int i = 0;
            while ((long)i < byteAnz / 16L) {
                fr.read(bytes);
                sbLines.append(String.valueOf(format.format(linebreak * i)) + "\n");
                sbHex.append(DICOMHexDump.toHex(bytes));
                sbText.append(String.valueOf(new String(bytes).replaceAll("[^\\p{Print}]", "_")) + "\n");
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        sbHex.append("stripped after " + byteAnz + " bytes...");
        retVal[0] = sbLines.toString();
        retVal[1] = sbHex.toString();
        retVal[2] = sbText.toString();
        return retVal;
    }

    private static String toHex(byte[] value) {
        StringBuffer retVal = new StringBuffer();
        int x = 0;
        while (x < value.length) {
            retVal.append(HexDumpTudor.toHex(value[x]));
            if (x == value.length - 1) {
                retVal.append("\n");
            } else {
                retVal.append(" ");
            }
            ++x;
        }
        return retVal.toString();
    }
}

