/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.win32;

import com.roxes.win32.Registry;
import com.roxes.win32.Win32Exception;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class LnkFile {
    String folder;
    String name;
    String description;
    String path;
    String workingDirectory;
    String arguments;
    String iconLocation;
    int iconIndex;
    static final String VERSION = "1.0.5";

    public LnkFile() {
    }

    public LnkFile(String folder, String name) {
        this();
        this.setFolder(folder);
        this.setName(name);
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setPath(String path) {
        this.path = path;
        if (this.workingDirectory == null) {
            String parent = new File(path).getParent();
            this.setWorkingDirectory(parent);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setIconLocation(String iconLocation) {
        this.iconLocation = iconLocation;
    }

    public String getIconLocation() {
        return this.iconLocation;
    }

    public void setIconIndex(int iconIndex) {
        this.iconIndex = iconIndex;
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    private native void load(String var1) throws Win32Exception;

    public void load() throws Win32Exception {
        this.load(this.getLinkFilePath());
    }

    private native void resolve(String var1) throws Win32Exception;

    public void resolve() throws Win32Exception {
        this.resolve(this.getLinkFilePath());
    }

    public String getLinkFilePath() {
        return this.getFolder() + File.separator + this.getName() + ".lnk";
    }

    private native void save(String var1) throws Win32Exception;

    public void save() throws Win32Exception {
        this.save(this.getLinkFilePath());
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File file = new File(System.getProperty("java.home") + File.separator + "bin" + File.separator + "roxes-lnkfile-" + VERSION + ".dll");
        if (!file.exists()) {
            try {
                System.out.println("Install native library " + file.getAbsolutePath());
                InputStream in = Registry.class.getResourceAsStream("lnkfile.dll");
                FileOutputStream out = new FileOutputStream(file);
                byte[] buffer = new byte[8192];
                InputStream inputStream = in;
                synchronized (inputStream) {
                    FileOutputStream fileOutputStream = out;
                    synchronized (fileOutputStream) {
                        int read;
                        while ((read = in.read(buffer)) > -1) {
                            ((OutputStream)out).write(buffer, 0, read);
                        }
                    }
                }
                ((OutputStream)out).close();
            }
            catch (Exception ex) {
                throw new Win32Exception("Unable to copy " + file.getName() + " to JAVA_HOME" + File.separator + "bin.");
            }
        }
        if (System.getProperty("roxes.native.lnkfile.1.0.5") == null) {
            System.load(file.getAbsolutePath());
            System.setProperty("roxes.native.lnkfile.1.0.5", "loaded");
        }
    }
}

