/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.win32;

import com.roxes.win32.Win32Exception;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.net.URL;

public class UrlFile {
    public static final String SIGNATURE = "[InternetShortcut]";
    public static final String LINE_BREAK = "\r\n";
    public static final int SHOWCOMMAND_NORMAL = -1;
    public static final int SHOWCOMMAND_MAXIMIZED = 3;
    public static final int SHOWCOMMAND_MINIMIZED = 7;
    String workingDirectory = null;
    String iconFile = null;
    int iconIndex = -1;
    URL url = null;
    int showCommand = -1;
    int hotKey = -1;
    String modified = null;
    File file = null;

    public UrlFile(File file) throws IOException {
        this.file = file;
        if (!file.exists() || file.length() == 0L) {
            return;
        }
        LineNumberReader reader = new LineNumberReader(new FileReader(file));
        String line = reader.readLine();
        if (!line.equals(SIGNATURE)) {
            throw new Win32Exception("Shortcut Signature \"[InternetShortcut]\" not found in file " + file.getAbsolutePath());
        }
        while ((line = reader.readLine()) != null) {
            int i = line.indexOf(61);
            if (i == -1) {
                throw new Win32Exception("Invalid Shortcut file format (line " + reader.getLineNumber() + "): \"=\" expected in \"" + line + "\"");
            }
            String key = line.substring(0, i);
            String value = line.substring(i + 1);
            if (key.equals("URL")) {
                this.url = new URL(value);
                continue;
            }
            if (key.equals("WorkingDirectory")) {
                this.workingDirectory = value;
                continue;
            }
            if (key.equals("IconFile")) {
                this.iconFile = value;
                continue;
            }
            if (key.equals("IconIndex")) {
                this.iconIndex = Integer.parseInt(value);
                continue;
            }
            if (key.equals("ShowCommand")) {
                this.showCommand = Integer.parseInt(value);
                continue;
            }
            if (key.equals("Modified")) {
                this.modified = value;
                continue;
            }
            if (key.equals("HotKey")) {
                this.hotKey = Integer.parseInt(value);
                continue;
            }
            throw new Win32Exception("Invalid Shortcut file format (line " + reader.getLineNumber() + "): dont know key " + key);
        }
        reader.close();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SIGNATURE).append(LINE_BREAK);
        if (this.url != null) {
            sb.append("URL=").append(this.url).append(LINE_BREAK);
        }
        if (this.workingDirectory != null) {
            sb.append("WorkingDirectory=").append(this.workingDirectory).append(LINE_BREAK);
        }
        if (this.iconFile != null) {
            sb.append("IconFile=").append(this.iconFile).append(LINE_BREAK);
        }
        if (this.iconIndex != -1) {
            sb.append("IconIndex=").append(this.iconIndex).append(LINE_BREAK);
        }
        if (this.modified != null) {
            sb.append("Modified=").append(this.modified).append(LINE_BREAK);
        }
        if (this.hotKey != -1) {
            sb.append("HotKey=").append(this.hotKey).append(LINE_BREAK);
        }
        return sb.toString();
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public String getModified() {
        return this.modified;
    }

    public int getShowCommand() {
        return this.showCommand;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setIconIndex(int iconIndex) {
        this.iconIndex = iconIndex;
    }

    public void setModified(String string) {
        this.modified = string;
    }

    public void setShowCommand(int i) {
        this.showCommand = i;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectory = string;
    }

    public void save() throws IOException {
        if (!this.file.getName().endsWith(".url")) {
            throw new Win32Exception("Shortcut/Favorite files must have prefix \".url\".");
        }
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        PrintStream out = new PrintStream(new FileOutputStream(this.file));
        out.print(this.toString());
        out.close();
    }

    public void save(File file) throws IOException {
        this.file = file;
        this.save();
    }

    public int getHotKey() {
        return this.hotKey;
    }

    public String getIconFile() {
        return this.iconFile;
    }

    public void setHotKey(int i) {
        this.hotKey = i;
    }

    public void setIconFile(String string) {
        this.iconFile = string;
    }
}

