/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.composite;

import org.dcm4che2.data.DicomObject;
import org.dcm4che2.iod.composite.Image;
import org.dcm4che2.iod.module.composite.AcquisitionContextModule;
import org.dcm4che2.iod.module.composite.ContrastBolusModule;
import org.dcm4che2.iod.module.composite.DeviceModule;
import org.dcm4che2.iod.module.dx.DXAnatomyImagedModule;
import org.dcm4che2.iod.module.dx.DXDetectorModule;
import org.dcm4che2.iod.module.dx.DXImageModule;
import org.dcm4che2.iod.module.dx.DXPositioningModule;
import org.dcm4che2.iod.module.dx.DXSeriesModule;
import org.dcm4che2.iod.module.lut.VoiLutModule;
import org.dcm4che2.iod.module.overlay.OverlayPlaneModule;
import org.dcm4che2.iod.validation.ValidationContext;
import org.dcm4che2.iod.validation.ValidationResult;

public class DXImage
extends Image {
    protected final ContrastBolusModule contrastBolusModule;
    protected final DeviceModule deviceModule;
    protected final DXAnatomyImagedModule dxAnatomyImagedModule;
    protected final DXDetectorModule dxDetectorModule;
    protected final DXPositioningModule dxPositioningModule;
    protected final OverlayPlaneModule overlayPlaneModule;
    protected final VoiLutModule voiLUTModule;
    protected final AcquisitionContextModule acquisitionContextModule;

    public DXImage(DicomObject dcmobj) {
        super(dcmobj, new DXSeriesModule(dcmobj), new DXImageModule(dcmobj));
        this.contrastBolusModule = new ContrastBolusModule(dcmobj);
        this.deviceModule = new DeviceModule(dcmobj);
        this.dxAnatomyImagedModule = new DXAnatomyImagedModule(dcmobj);
        this.dxDetectorModule = new DXDetectorModule(dcmobj);
        this.dxPositioningModule = new DXPositioningModule(dcmobj);
        this.overlayPlaneModule = new OverlayPlaneModule(dcmobj);
        this.voiLUTModule = new VoiLutModule(dcmobj);
        this.acquisitionContextModule = new AcquisitionContextModule(dcmobj);
    }

    public void init() {
        super.init();
        this.contrastBolusModule.init();
        this.deviceModule.init();
        this.dxAnatomyImagedModule.init();
        this.dxDetectorModule.init();
        this.dxPositioningModule.init();
        this.overlayPlaneModule.init();
        this.voiLUTModule.init();
        this.acquisitionContextModule.init();
    }

    public void validate(ValidationContext ctx, ValidationResult result) {
        super.validate(ctx, result);
        this.contrastBolusModule.validate(ctx, result);
        this.deviceModule.validate(ctx, result);
        this.dxAnatomyImagedModule.validate(ctx, result);
        this.dxDetectorModule.validate(ctx, result);
        this.dxPositioningModule.validate(ctx, result);
        this.overlayPlaneModule.validate(ctx, result);
        this.voiLUTModule.validate(ctx, result);
        this.acquisitionContextModule.validate(ctx, result);
    }

    public final DXSeriesModule getDXSeriesModule() {
        return (DXSeriesModule)this.generalSeriesModule;
    }

    public final ContrastBolusModule getContrastBolusModule() {
        return this.contrastBolusModule;
    }

    public final DeviceModule getDeviceModule() {
        return this.deviceModule;
    }

    public final DXAnatomyImagedModule getDXAnatomyImageModule() {
        return this.dxAnatomyImagedModule;
    }

    public final DXImageModule getDXImageModule() {
        return (DXImageModule)this.generalImageModule;
    }

    public final DXDetectorModule getDXDetectorModule() {
        return this.dxDetectorModule;
    }

    public final DXPositioningModule getDXPositioningModule() {
        return this.dxPositioningModule;
    }

    public final OverlayPlaneModule getOverlayPlaneModule() {
        return this.overlayPlaneModule;
    }

    public final VoiLutModule getVOILUTModule() {
        return this.voiLUTModule;
    }

    public final AcquisitionContextModule getAcquisitionContextModule() {
        return this.acquisitionContextModule;
    }
}

