/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.composite;

import java.util.Date;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.composite.ImagePixel;
import org.dcm4che2.iod.module.composite.SourceImage;
import org.dcm4che2.iod.module.macro.Code;
import org.dcm4che2.iod.module.macro.ImageSOPInstanceReferenceAndPurpose;
import org.dcm4che2.iod.module.macro.SOPInstanceReferenceAndPurpose;
import org.dcm4che2.iod.validation.ValidationContext;
import org.dcm4che2.iod.validation.ValidationResult;
import org.dcm4che2.iod.value.Flag;
import org.dcm4che2.iod.value.LossyImageCompression;
import org.dcm4che2.iod.value.PresentationLUTShape;

public class GeneralImageModule
extends ImagePixel {
    public GeneralImageModule(DicomObject dcmobj) {
        super(dcmobj);
    }

    public void init() {
        super.init();
        this.setSamplesPerPixel(1);
        this.setPixelRepresentation(0);
    }

    public void validate(ValidationContext ctx, ValidationResult result) {
        super.validate(ctx, result);
        if (!PresentationLUTShape.isValidSoftCopy(this.getPresentationLUTShape())) {
            result.logInvalidValue(0x20500020, this.dcmobj);
        }
        if (!LossyImageCompression.isValid(this.getLossyImageCompression())) {
            result.logInvalidValue(2629904, this.dcmobj);
        }
        if (!Flag.isValid(this.getBurnedInAnnotation())) {
            result.logInvalidValue(2622209, this.dcmobj);
        }
    }

    public String getInstanceNumber() {
        return this.dcmobj.getString(2097171);
    }

    public void setInstanceNumber(String s) {
        this.dcmobj.putString(2097171, VR.IS, s);
    }

    public String[] getPatientOrientation() {
        return this.dcmobj.getStrings(0x200020);
    }

    public void setPatientOrientation(String[] s) {
        this.dcmobj.putStrings(0x200020, VR.CS, s);
    }

    public Date getContentDateTime() {
        return this.dcmobj.getDate(524323, 524339);
    }

    public void setContentDateTime(Date d) {
        this.dcmobj.putDate(524323, VR.DA, d);
        this.dcmobj.putDate(524339, VR.TM, d);
    }

    public String[] getImageType() {
        return this.dcmobj.getStrings(524296);
    }

    public void setImageType(String[] s) {
        this.dcmobj.putStrings(524296, VR.CS, s);
    }

    public String getAcquisitionNumber() {
        return this.dcmobj.getString(0x200012);
    }

    public void setAcquisitionNumber(String s) {
        this.dcmobj.putString(0x200012, VR.IS, s);
    }

    public Date getAcquisitionDateAndTime() {
        return this.dcmobj.getDate(524322, 524338);
    }

    public void setAcquisitionDateAndTime(Date d) {
        this.dcmobj.putDate(524322, VR.DA, d);
        this.dcmobj.putDate(524338, VR.TM, d);
    }

    public Date getAcquisitionDateTime() {
        return this.dcmobj.getDate(524330);
    }

    public void setAcquisitionDateTime(Date d) {
        this.dcmobj.putDate(524330, VR.DT, d);
    }

    public ImageSOPInstanceReferenceAndPurpose[] getReferencedImages() {
        return ImageSOPInstanceReferenceAndPurpose.toImageSOPInstanceReferenceAndPurposes(this.dcmobj.get(528704));
    }

    public void setReferencedImages(ImageSOPInstanceReferenceAndPurpose[] sops) {
        this.updateSequence(528704, sops);
    }

    public String getDerivationDescription() {
        return this.dcmobj.getString(532753);
    }

    public void setDerivationDescription(String s) {
        this.dcmobj.putString(532753, VR.ST, s);
    }

    public Code[] getDerivationCodes() {
        return Code.toCodes(this.dcmobj.get(561685));
    }

    public void setDerivationCodes(Code[] codes) {
        this.updateSequence(561685, codes);
    }

    public SourceImage[] getSourceImages() {
        return SourceImage.toSourceImages(this.dcmobj.get(532754));
    }

    public void setSourceImages(SourceImage[] sops) {
        this.updateSequence(532754, sops);
    }

    public SOPInstanceReferenceAndPurpose[] getReferencedInstances() {
        return SOPInstanceReferenceAndPurpose.toSOPInstanceReferenceAndPurposes(this.dcmobj.get(528714));
    }

    public void setReferencedInstances(SOPInstanceReferenceAndPurpose[] sops) {
        this.updateSequence(528714, sops);
    }

    public int getImagesInAcquisition() {
        return this.dcmobj.getInt(0x201002);
    }

    public void setImagesInAcquisition(int i) {
        this.dcmobj.putInt(0x201002, VR.IS, i);
    }

    public String getImageComments() {
        return this.dcmobj.getString(0x204000);
    }

    public void setImageComments(String s) {
        this.dcmobj.putString(0x204000, VR.LT, s);
    }

    public String getQualityControlImage() {
        return this.dcmobj.getString(2622208);
    }

    public void setQualityControlImage(String s) {
        this.dcmobj.putString(2622208, VR.CS, s);
    }

    public String getBurnedInAnnotation() {
        return this.dcmobj.getString(2622209);
    }

    public void setBurnedInAnnotation(String s) {
        this.dcmobj.putString(2622209, VR.CS, s);
    }

    public String getLossyImageCompression() {
        return this.dcmobj.getString(2629904);
    }

    public void setLossyImageCompression(String s) {
        this.dcmobj.putString(2629904, VR.CS, s);
    }

    public float[] getLossyImageCompressionRatio() {
        return this.dcmobj.getFloats(0x282112);
    }

    public void setLossyImageCompression(float[] floats) {
        this.dcmobj.putFloats(0x282112, VR.DS, floats);
    }

    public String[] getLossyImageCompressionMethod() {
        return this.dcmobj.getStrings(2629908);
    }

    public void setLossyImageCompressionMethod(String[] ss) {
        this.dcmobj.putStrings(2629908, VR.CS, ss);
    }

    public ImagePixel getIconImage() {
        DicomObject item = this.dcmobj.getNestedDicomObject(0x880200);
        return item != null ? new ImagePixel(item) : null;
    }

    public void setIconImage(ImagePixel icon) {
        this.updateSequence(0x880200, icon);
    }

    public String getPresentationLUTShape() {
        return this.dcmobj.getString(0x20500020);
    }

    public void setPresentationLUTShape(String s) {
        this.dcmobj.putString(0x20500020, VR.CS, s);
    }

    public String getIrradiationEventUID() {
        return this.dcmobj.getString(536592);
    }

    public void setIrradiationEventUID(String s) {
        this.dcmobj.putString(536592, VR.UI, s);
    }

    public String getPixelDataProviderURL() {
        return this.dcmobj.getString(2654176);
    }

    public void setPixelDataProviderURL(String s) {
        this.dcmobj.putString(2654176, VR.UT, s);
    }
}

