/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.composite;

import java.util.Date;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.composite.RelatedSeries;
import org.dcm4che2.iod.module.composite.RequestAttributes;
import org.dcm4che2.iod.module.macro.PersonIdentification;
import org.dcm4che2.iod.module.macro.ProtocolCodeAndContext;
import org.dcm4che2.iod.module.macro.SOPInstanceReference;
import org.dcm4che2.iod.value.PixelRepresentation;

public class GeneralSeriesModule
extends Module {
    public GeneralSeriesModule(DicomObject dcmobj) {
        super(dcmobj);
    }

    public String getModality() {
        return this.dcmobj.getString(524384);
    }

    public void setModality(String s) {
        this.dcmobj.putString(524384, VR.CS, s);
    }

    public String getSeriesInstanceUID() {
        return this.dcmobj.getString(0x20000E);
    }

    public void setSeriesInstanceUID(String s) {
        this.dcmobj.putString(0x20000E, VR.UI, s);
    }

    public String getSeriesNumber() {
        return this.dcmobj.getString(0x200011);
    }

    public void setSeriesNumber(String s) {
        this.dcmobj.putString(0x200011, VR.IS, s);
    }

    public String getLaterality() {
        return this.dcmobj.getString(0x200060);
    }

    public void setLaterality(String s) {
        this.dcmobj.putString(0x200060, VR.CS, s);
    }

    public Date getSeriesDateTime() {
        return this.dcmobj.getDate(524321, 524337);
    }

    public void setSeriesDateTime(Date d) {
        this.dcmobj.putDate(524321, VR.DA, d);
        this.dcmobj.putDate(524337, VR.TM, d);
    }

    public String[] getPerformingPhysicianName() {
        return this.dcmobj.getStrings(528464);
    }

    public void setPerformingPhysicianName(String[] ss) {
        this.dcmobj.putStrings(528464, VR.PN, ss);
    }

    public PersonIdentification[] getPerformingPhysicianIdentification() {
        return PersonIdentification.toPersonIdentifications(this.dcmobj.get(528466));
    }

    public void setPerformingPhysicianIdentification(PersonIdentification[] ids) {
        this.updateSequence(528466, ids);
    }

    public String getProtocolName() {
        return this.dcmobj.getString(1577008);
    }

    public void setProtocolName(String s) {
        this.dcmobj.putString(1577008, VR.LO, s);
    }

    public String getSeriesDescription() {
        return this.dcmobj.getString(528446);
    }

    public void setSeriesDescription(String s) {
        this.dcmobj.putString(528446, VR.LO, s);
    }

    public String[] getOperatorName() {
        return this.dcmobj.getStrings(528496);
    }

    public void setOperatorName(String[] ss) {
        this.dcmobj.putStrings(528496, VR.PN, ss);
    }

    public PersonIdentification[] getOperatorIdentification() {
        return PersonIdentification.toPersonIdentifications(this.dcmobj.get(528498));
    }

    public void setOperatorIdentification(PersonIdentification[] ids) {
        this.updateSequence(528498, ids);
    }

    public SOPInstanceReference getReferencedPerformedProcedureStep() {
        DicomObject item = this.dcmobj.getNestedDicomObject(528657);
        return item != null ? new SOPInstanceReference(item) : null;
    }

    public void setReferencedPerformedProcedureStep(SOPInstanceReference refSOP) {
        this.updateSequence(528657, refSOP);
    }

    public RelatedSeries[] getRelatedSeries() {
        return RelatedSeries.toRelatedSeries(this.dcmobj.get(528976));
    }

    public void setRelatedSeries(RelatedSeries[] relseries) {
        this.updateSequence(528976, relseries);
    }

    public String getBodyPartExamined() {
        return this.dcmobj.getString(1572885);
    }

    public void setBodyPartExamined(String s) {
        this.dcmobj.putString(1572885, VR.CS, s);
    }

    public String getPatientPosition() {
        return this.dcmobj.getString(1593600);
    }

    public void setPatientPosition(String s) {
        this.dcmobj.putString(1593600, VR.CS, s);
    }

    public int getSmallestPixelValueInSeries() {
        return this.dcmobj.getInt(2621704);
    }

    public void setSmallestPixelValueInSeries(int s) {
        this.dcmobj.putInt(2621704, PixelRepresentation.isSigned(this.dcmobj) ? VR.SS : VR.US, s);
    }

    public int getLargestPixelValueInSeries() {
        return this.dcmobj.getInt(2621705);
    }

    public void setLargestPixelValueInSeries(int s) {
        this.dcmobj.putInt(2621705, PixelRepresentation.isSigned(this.dcmobj) ? VR.SS : VR.US, s);
    }

    public RequestAttributes[] getRequestAttributes() {
        return RequestAttributes.toRequestAttributes(this.dcmobj.get(4194933));
    }

    public void setRequestAttributes(RequestAttributes[] rqattrs) {
        this.updateSequence(4194933, rqattrs);
    }

    public String getPerformedProcedureStepID() {
        return this.dcmobj.getString(4194899);
    }

    public void setPerformedProcedureStepID(String s) {
        this.dcmobj.putString(4194899, VR.SH, s);
    }

    public Date getPerformedProcedureStepDateTime() {
        return this.dcmobj.getDate(0x400244, 4194885);
    }

    public void setPerformedProcedureStepDateTime(Date d) {
        this.dcmobj.putDate(0x400244, VR.DA, d);
        this.dcmobj.putDate(4194885, VR.TM, d);
    }

    public String getPerformedProcedureStepDescription() {
        return this.dcmobj.getString(4194900);
    }

    public void setPerformedProcedureStepDescription(String s) {
        this.dcmobj.putString(4194900, VR.LO, s);
    }

    public ProtocolCodeAndContext[] getPerformedProtocolCodes() {
        return ProtocolCodeAndContext.toProtocolCodeAndContexts(this.dcmobj.get(4194912));
    }

    public void setPerformedProtocolCodes(ProtocolCodeAndContext[] codes) {
        this.updateSequence(4194912, codes);
    }

    public String getCommentsOnThePerformedProcedureStep() {
        return this.dcmobj.getString(4194944);
    }

    public void setCommentsOnThePerformedProcedureStep(String s) {
        this.dcmobj.putString(4194944, VR.ST, s);
    }
}

