/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.composite;

import java.util.Date;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.macro.Code;
import org.dcm4che2.iod.module.macro.PersonIdentification;
import org.dcm4che2.iod.module.macro.SOPInstanceReference;

public class GeneralStudyModule
extends Module {
    public GeneralStudyModule(DicomObject dcmobj) {
        super(dcmobj);
    }

    public String getStudyInstanceUID() {
        return this.dcmobj.getString(0x20000D);
    }

    public void setStudyInstanceUID(String s) {
        this.dcmobj.putString(0x20000D, VR.UI, s);
    }

    public Date getStudyDateTime() {
        return this.dcmobj.getDate(524320, 524336);
    }

    public void setStudyDateTime(Date d) {
        this.dcmobj.putDate(524320, VR.DA, d);
        this.dcmobj.putDate(524336, VR.TM, d);
    }

    public String getReferringPhysiciansName() {
        return this.dcmobj.getString(524432);
    }

    public void setReferringPhysiciansName(String s) {
        this.dcmobj.putString(524432, VR.PN, s);
    }

    public PersonIdentification getReferringPhysicianIdentification() {
        DicomObject item = this.dcmobj.getNestedDicomObject(524438);
        return item != null ? new PersonIdentification(item) : null;
    }

    public void setReferringPhysicianIdentification(PersonIdentification id) {
        this.updateSequence(524438, id);
    }

    public String getStudyID() {
        return this.dcmobj.getString(0x200010);
    }

    public void setStudyID(String s) {
        this.dcmobj.putString(0x200010, VR.SH, s);
    }

    public String getAccessionNumber() {
        return this.dcmobj.getString(524368);
    }

    public void setAccessionNumber(String s) {
        this.dcmobj.putString(524368, VR.SH, s);
    }

    public String getStudyDescription() {
        return this.dcmobj.getString(528432);
    }

    public void setStudyDescription(String s) {
        this.dcmobj.putString(528432, VR.LO, s);
    }

    public String[] getPhysiciansOfRecord() {
        return this.dcmobj.getStrings(528456);
    }

    public void setPhysiciansOfRecord(String[] ss) {
        this.dcmobj.putStrings(528456, VR.PN, ss);
    }

    public PersonIdentification[] getPhysiciansOfRecordIdentification() {
        return PersonIdentification.toPersonIdentifications(this.dcmobj.get(528457));
    }

    public void setPhysiciansOfRecordIdentification(PersonIdentification[] ids) {
        this.updateSequence(528457, ids);
    }

    public String[] getNameOfPhysiciansReadingStudy() {
        return this.dcmobj.getStrings(528480);
    }

    public void setNameOfPhysiciansReadingStudy(String[] ss) {
        this.dcmobj.putStrings(528480, VR.PN, ss);
    }

    public PersonIdentification[] getPhysiciansReadingStudyIdentification() {
        return PersonIdentification.toPersonIdentifications(this.dcmobj.get(528482));
    }

    public void setPhysiciansReadingStudyIdentification(PersonIdentification[] ids) {
        this.updateSequence(528482, ids);
    }

    public SOPInstanceReference getReferencedStudySOPInstance() {
        DicomObject item = this.dcmobj.getNestedDicomObject(528656);
        return item != null ? new SOPInstanceReference(item) : null;
    }

    public void setReferencedStudySOPInstance(SOPInstanceReference refSOP) {
        this.updateSequence(528656, refSOP);
    }

    public Code[] getProcedureCodes() {
        return Code.toCodes(this.dcmobj.get(528434));
    }

    public void setProcedureCodes(Code[] codes) {
        this.updateSequence(528434, codes);
    }
}

