/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.composite;

import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.macro.Code;
import org.dcm4che2.iod.module.macro.ProtocolCodeAndContext;

public class RequestAttributes
extends Module {
    public RequestAttributes(DicomObject dcmobj) {
        super(dcmobj);
    }

    public RequestAttributes() {
        this((DicomObject)new BasicDicomObject());
    }

    public static RequestAttributes[] toRequestAttributes(DicomElement sq) {
        if (sq == null || !sq.hasItems()) {
            return null;
        }
        RequestAttributes[] a = new RequestAttributes[sq.countItems()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new RequestAttributes(sq.getDicomObject(i));
        }
        return a;
    }

    public String getRequestedProcedureID() {
        return this.dcmobj.getString(0x401001);
    }

    public void setRequestedProcedureID(String s) {
        this.dcmobj.putString(0x401001, VR.SH, s);
    }

    public String getReasonForTheRequestedProcedure() {
        return this.dcmobj.getString(4198402);
    }

    public void setReasonForTheRequestedProcedure(String s) {
        this.dcmobj.putString(4198402, VR.LO, s);
    }

    public Code getReasonForRequestedProcedureCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(4198410);
        return item != null ? new Code(item) : null;
    }

    public void setReasonForRequestedProcedureCode(Code code) {
        this.updateSequence(4198410, code);
    }

    public String getScheduledProcedureStepID() {
        return this.dcmobj.getString(0x400009);
    }

    public void setScheduledProcedureStepID(String s) {
        this.dcmobj.putString(0x400009, VR.SH, s);
    }

    public String getScheduledProcedureStepDescription() {
        return this.dcmobj.getString(0x400007);
    }

    public void setScheduledProcedureStepDescription(String s) {
        this.dcmobj.putString(0x400007, VR.LO, s);
    }

    public ProtocolCodeAndContext[] getScheduledProtocolCode() {
        return ProtocolCodeAndContext.toProtocolCodeAndContexts(this.dcmobj.get(0x400008));
    }

    public void setScheduledProtocolCode(ProtocolCodeAndContext[] codes) {
        this.updateSequence(0x400008, codes);
    }
}

