/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.dx;

import java.util.Date;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;

public class DXDetector
extends Module {
    public DXDetector(DicomObject dcmobj) {
        super(dcmobj);
    }

    public String getDetectorType() {
        return this.dcmobj.getString(1601540);
    }

    public void setDetectorType(String s) {
        this.dcmobj.putString(1601540, VR.CS, s);
    }

    public String getDetectorConfiguration() {
        return this.dcmobj.getString(1601541);
    }

    public void setDetectorConfiguration(String s) {
        this.dcmobj.putString(1601541, VR.CS, s);
    }

    public String getDetectorDescription() {
        return this.dcmobj.getString(1601542);
    }

    public void setDetectorDescription(String s) {
        this.dcmobj.putString(1601542, VR.LT, s);
    }

    public String getDetectorMode() {
        return this.dcmobj.getString(1601544);
    }

    public void setDetectorMode(String s) {
        this.dcmobj.putString(1601544, VR.LT, s);
    }

    public String getDetectorID() {
        return this.dcmobj.getString(1601546);
    }

    public void setDetectorID(String s) {
        this.dcmobj.putString(1601546, VR.SH, s);
    }

    public Date getDateTimeOfLastDetectorCalibration() {
        return this.dcmobj.getDate(1601548, 1601550);
    }

    public void setDateTimeOfLastDetectorCalibration(Date d) {
        this.dcmobj.putDate(1601548, VR.DA, d);
        this.dcmobj.putDate(1601550, VR.TM, d);
    }

    public int getExposuresOnDetectorSinceLastCalibration() {
        return this.dcmobj.getInt(1601552);
    }

    public void setExposuresOnDetectorSinceLastCalibration(int i) {
        this.dcmobj.putInt(1601552, VR.IS, i);
    }

    public int getExposuresOnDetectorSinceManufactured() {
        return this.dcmobj.getInt(1601553);
    }

    public void setExposuresOnDetectorSinceManufactured(int i) {
        this.dcmobj.putInt(1601553, VR.IS, i);
    }

    public float getDetectorTimeSinceLastExposure() {
        return this.dcmobj.getFloat(1601554);
    }

    public void setDetectorTimeSinceLastExposure(float f) {
        this.dcmobj.putFloat(1601554, VR.DS, f);
    }

    public float[] getDetectorBinning() {
        return this.dcmobj.getFloats(1601562);
    }

    public void setDetectorBinning(float[] f) {
        this.dcmobj.putFloats(1601562, VR.DS, f);
    }

    public String getDetectorManufacturerName() {
        return this.dcmobj.getString(1601578);
    }

    public void setDetectorManufacturerName(String s) {
        this.dcmobj.putString(1601578, VR.LO, s);
    }

    public String getDetectorManufacturerModelName() {
        return this.dcmobj.getString(1601579);
    }

    public void setDetectorManufacturerModelName(String s) {
        this.dcmobj.putString(1601579, VR.LO, s);
    }

    public String getDetectorConditionsNominalFlag() {
        return this.dcmobj.getString(1601536);
    }

    public void setDetectorConditionsNominalFlag(String s) {
        this.dcmobj.putString(1601536, VR.CS, s);
    }

    public float getDetectorTemperature() {
        return this.dcmobj.getFloat(1601537);
    }

    public void setDetectorTemperature(float f) {
        this.dcmobj.putFloat(1601537, VR.DS, f);
    }

    public float getSensitivity() {
        return this.dcmobj.getFloat(1597440);
    }

    public void setSensitivity(float s) {
        this.dcmobj.putFloat(1597440, VR.DS, s);
    }

    public float[] getDetectorElementPhysicalSize() {
        return this.dcmobj.getFloats(1601568);
    }

    public void setDetectorElementPhysicalSize(float[] f) {
        this.dcmobj.putFloats(1601568, VR.DS, f);
    }

    public float[] getDetectorElementSpacing() {
        return this.dcmobj.getFloats(1601570);
    }

    public void setDetectorElementSpacing(float[] f) {
        this.dcmobj.putFloats(1601570, VR.DS, f);
    }

    public String getDetectorActiveShape() {
        return this.dcmobj.getString(1601572);
    }

    public void setDetectorActiveShape(String s) {
        this.dcmobj.putString(1601572, VR.CS, s);
    }

    public float[] getDetectorActiveDimensions() {
        return this.dcmobj.getFloats(1601574);
    }

    public void setDetectorActiveDimensions(float[] f) {
        this.dcmobj.putFloats(1601574, VR.DS, f);
    }

    public float[] getDetectorActiveOrigin() {
        return this.dcmobj.getFloats(1601576);
    }

    public void setDetectorActiveOrigin(float[] f) {
        this.dcmobj.putFloats(1601576, VR.DS, f);
    }
}

