/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.dx;

import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.lut.LutModule;
import org.dcm4che2.iod.module.lut.ModalityLutModule;
import org.dcm4che2.iod.validation.ValidationContext;
import org.dcm4che2.iod.validation.ValidationResult;
import org.dcm4che2.iod.value.Flag;
import org.dcm4che2.iod.value.PixelIntensityRelationship;
import org.dcm4che2.iod.value.Sign;

public class DXImageModule
extends LutModule {
    public DXImageModule(DicomObject dcmobj) {
        super(dcmobj);
    }

    public void init() {
        super.init();
        ModalityLutModule modalityLutModule = this.getModalityLutModule();
        modalityLutModule.setRescaleIntercept(0.0f);
        modalityLutModule.setRescaleSlope(1.0f);
        modalityLutModule.setRescaleType("US");
    }

    public void validate(ValidationContext ctx, ValidationResult result) {
        super.validate(ctx, result);
        if (!PixelIntensityRelationship.isValid(this.getPixelIntensityRelationship())) {
            result.logInvalidValue(2625600, this.dcmobj);
        }
        if (!Sign.isValid(this.getPixelIntensityRelationshipSign()) && this.dcmobj.containsValue(2625601)) {
            result.logInvalidValue(2625601, this.dcmobj);
        }
        if (!Flag.isValid(this.getCalibrationImage())) {
            result.logInvalidValue(0x500004, this.dcmobj);
        }
    }

    public void setPixelIntensityRelationship(String s) {
        this.dcmobj.putString(2625600, VR.CS, s);
    }

    public String getPixelIntensityRelationship() {
        return this.dcmobj.getString(2625600);
    }

    public void setPixelIntensityRelationshipSign(int ss) {
        this.dcmobj.putInt(2625601, VR.SS, ss);
    }

    public int getPixelIntensityRelationshipSign() {
        return this.dcmobj.getInt(2625601);
    }

    public void setAcquisitionDeviceProcessingDescription(String lo) {
        this.dcmobj.putString(1577984, VR.LO, lo);
    }

    public String getAcquisitionDeviceProcessingDescription() {
        return this.dcmobj.getString(1577984);
    }

    public void setAcquisitionDeviceProcessingCode(String lo) {
        this.dcmobj.putString(1577985, VR.LO, lo);
    }

    public String getAcquisitionDeviceProcessingCode() {
        return this.dcmobj.getString(1577985);
    }

    public void setCalibrationImage(String cs) {
        this.dcmobj.putString(0x500004, VR.CS, cs);
    }

    public String getCalibrationImage() {
        return this.dcmobj.getString(0x500004);
    }
}

